# ZenRTC — Robust RTC helper for ESP32 + DS3231

**Why ZenRTC?** Many DS3231 modules trigger OSF and cause time jumps when the coin cell sags or boards brown out. ZenRTC hardens your setup by clearing flags, validating time, and persisting a last‑known‑good epoch in NVS.

## Features
- Auto‑detects **OSF** and invalid time; clears flags safely
- **Sanity checks** time (range & large jump detection)
- **Clamps** wild jumps back to last‑known‑good
- Optional **seed from build time** on first invalid boot
- Simple API; Arduino‑compatible; ESP32 only

## Installation
**Arduino IDE**
1. Download/clone this repo as **`ZenRTC`**.
2. Place it under your Arduino `libraries/` folder.
3. Restart Arduino IDE → **File → Examples → ZenRTC → Basic**.

**PlatformIO**
- As a project library: copy `ZenRTC/` to your project’s `lib/` folder.
- Or use `lib_deps` with a VCS URL.

## Usage
```cpp
#include <ZenRTC.h>
ZenRTC rtc;

void setup(){
  Serial.begin(115200);
  rtc.begin(true);
}

void loop(){
  ZenRTC::DateTime dt;
  if (rtc.now(dt)) {
    Serial.printf("%04u-%02u-%02u %02u:%02u:%02u\n", dt.year, dt.month, dt.day, dt.hour, dt.minute, dt.second);
  }
  delay(1000);
}
```

## License
MIT © 2025 NexByteIO
