/*
  See https://www.RoxXxtar.com/bmc for more details
  Copyright (c) 2025 Roxxxtar.com
  Licensed under the MIT license.
  See LICENSE file in the project root for full license information.
*/

#ifndef BMC_PIXEL_COLORS_H
#define BMC_PIXEL_COLORS_H

#include <FastLED.h>





// BMC_PIXEL_MAX_BRIGHTNESS sets the brightness of the WS2812Serial library.
// this value must be anything from 1 to 255 as long as it's higher than BMC_PIXEL_DIM_BRIGHTNESS
// BMC_PIXEL_MAX_BRIGHTNESS is the brightness when the Pixel is OFF when the "Dim LEDs when Off"
// is enabled under Settings.
// Since the WS2812Serial library will set the maximum brightness the DIM value
// must be pre-calculated so that when the WS2812Serial library converts the brightness
// it converts it to the BMC_PIXEL_MAX_BRIGHTNESS.
// For example, if BMC_PIXEL_MAX_BRIGHTNESS is 127 then White (0xFFFFFF) will be
// converted to 0x7F7F7F by the WS2812Serial library to make that pixel white
// then if BMC_PIXEL_DIM_BRIGHTNESS is 10 BMC will convert White from 0xFFFFFF
// to 0x151515 so that when the WS2812Serial library converts it it will result
// in 0x0A0A0A


#if !defined(BMC_PIXEL_MAX_BRIGHTNESS)
  #define BMC_PIXEL_MAX_BRIGHTNESS 10
#endif

#if !defined(BMC_PIXEL_DIM_BRIGHTNESS)
  #define BMC_PIXEL_DIM_BRIGHTNESS 3
#endif

#if BMC_PIXEL_DIM_BRIGHTNESS >= BMC_PIXEL_MAX_BRIGHTNESS
  #error "BMC_PIXEL_DIM_BRIGHTNESS can NOT be higher than or equal to BMC_PIXEL_MAX_BRIGHTNESS"
#endif

// You can override any of these colors in your config file, however
// the overall maximum brightness will be set by BMC_PIXEL_MAX_BRIGHTNESS
#ifndef BMC_COLOR_RGB_BLACK
  #define BMC_COLOR_RGB_BLACK 0x000000
#endif
#ifndef BMC_COLOR_RGB_RED
  #define BMC_COLOR_RGB_RED 0xFF0000
#endif
#ifndef BMC_COLOR_RGB_GREEN
  #define BMC_COLOR_RGB_GREEN 0x00FF00
#endif
#ifndef BMC_COLOR_RGB_YELLOW
  #define BMC_COLOR_RGB_YELLOW 0xFFB200
#endif
#ifndef BMC_COLOR_RGB_BLUE
  #define BMC_COLOR_RGB_BLUE 0x0000FF
#endif
#ifndef BMC_COLOR_RGB_MAGENTA
  #define BMC_COLOR_RGB_MAGENTA 0xFF00FF
#endif
#ifndef BMC_COLOR_RGB_CYAN
  #define BMC_COLOR_RGB_CYAN 0x00C8FF
#endif
#ifndef BMC_COLOR_RGB_WHITE
  #define BMC_COLOR_RGB_WHITE 0x999999
#endif
#ifndef BMC_COLOR_RGB_LIME
  #define BMC_COLOR_RGB_LIME 0x7FCC19
#endif
#ifndef BMC_COLOR_RGB_PINK
  #define BMC_COLOR_RGB_PINK 0xFF197F
#endif
#ifndef BMC_COLOR_RGB_PURPLE
  #define BMC_COLOR_RGB_PURPLE 0x6619CC
#endif
#ifndef BMC_COLOR_RGB_ORANGE
  #define BMC_COLOR_RGB_ORANGE 0xFF3300
#endif
#ifndef BMC_COLOR_RGB_TEAL
  #define BMC_COLOR_RGB_TEAL 0x00FF7F
#endif
#ifndef BMC_COLOR_RGB_CORAL
  #define BMC_COLOR_RGB_CORAL 0xFF1919
#endif
#ifndef BMC_COLOR_RGB_RAINBOW
  #define BMC_COLOR_RGB_RAINBOW 0xFFFFFF
#endif
#ifndef BMC_COLOR_RGB_RAINBOW_FADE
  #define BMC_COLOR_RGB_RAINBOW_FADE 0xFFFFFE
#endif


#define BMC_PIXEL_MULTIPLIER (BMC_PIXEL_MAX_BRIGHTNESS+1)

#ifndef BMC_COLOR_RGB_DIM_BLACK
  #define BMC_COLOR_RGB_DIM_BLACK 0
#endif
#ifndef BMC_COLOR_RGB_DIM_RED
  #define BMC_PIXEL_DIM_B_PERCENT_RED ((uint8_t)ceil( (((BMC_COLOR_RGB_RED)&0xFF) / (BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS) ))
  #define BMC_PIXEL_DIM_G_PERCENT_RED ((uint8_t)ceil( ((((BMC_COLOR_RGB_RED)>>8)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_PIXEL_DIM_R_PERCENT_RED ((uint8_t)ceil( ((((BMC_COLOR_RGB_RED)>>16)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_COLOR_RGB_DIM_RED ( BMC_PIXEL_DIM_B_PERCENT_RED | ((BMC_PIXEL_DIM_G_PERCENT_RED) << 8) | ((BMC_PIXEL_DIM_R_PERCENT_RED) << 16) )
#endif
#ifndef BMC_COLOR_RGB_DIM_GREEN
  #define BMC_PIXEL_DIM_B_PERCENT_GREEN ((uint8_t)ceil( (((BMC_COLOR_RGB_GREEN)&0xFF) / (BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS) ))
  #define BMC_PIXEL_DIM_G_PERCENT_GREEN ((uint8_t)ceil( ((((BMC_COLOR_RGB_GREEN)>>8)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_PIXEL_DIM_R_PERCENT_GREEN ((uint8_t)ceil( ((((BMC_COLOR_RGB_GREEN)>>16)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_COLOR_RGB_DIM_GREEN ( BMC_PIXEL_DIM_B_PERCENT_GREEN | ((BMC_PIXEL_DIM_G_PERCENT_GREEN) << 8) | ((BMC_PIXEL_DIM_R_PERCENT_GREEN) << 16) )
#endif
#ifndef BMC_COLOR_RGB_DIM_YELLOW
  #define BMC_PIXEL_DIM_B_PERCENT_YELLOW ((uint8_t)ceil( (((BMC_COLOR_RGB_YELLOW)&0xFF) / (BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS) ))
  #define BMC_PIXEL_DIM_G_PERCENT_YELLOW ((uint8_t)ceil( ((((BMC_COLOR_RGB_YELLOW)>>8)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_PIXEL_DIM_R_PERCENT_YELLOW ((uint8_t)ceil( ((((BMC_COLOR_RGB_YELLOW)>>16)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_COLOR_RGB_DIM_YELLOW ( BMC_PIXEL_DIM_B_PERCENT_YELLOW | ((BMC_PIXEL_DIM_G_PERCENT_YELLOW) << 8) | ((BMC_PIXEL_DIM_R_PERCENT_YELLOW) << 16) )
#endif
#ifndef BMC_COLOR_RGB_DIM_BLUE
  #define BMC_PIXEL_DIM_B_PERCENT_BLUE ((uint8_t)ceil( (((BMC_COLOR_RGB_BLUE)&0xFF) / (BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS) ))
  #define BMC_PIXEL_DIM_G_PERCENT_BLUE ((uint8_t)ceil( ((((BMC_COLOR_RGB_BLUE)>>8)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_PIXEL_DIM_R_PERCENT_BLUE ((uint8_t)ceil( ((((BMC_COLOR_RGB_BLUE)>>16)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_COLOR_RGB_DIM_BLUE ( BMC_PIXEL_DIM_B_PERCENT_BLUE | ((BMC_PIXEL_DIM_G_PERCENT_BLUE) << 8) | ((BMC_PIXEL_DIM_R_PERCENT_BLUE) << 16) )
#endif
#ifndef BMC_COLOR_RGB_DIM_MAGENTA
  #define BMC_PIXEL_DIM_B_PERCENT_MAGENTA ((uint8_t)ceil( (((BMC_COLOR_RGB_MAGENTA)&0xFF) / (BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS) ))
  #define BMC_PIXEL_DIM_G_PERCENT_MAGENTA ((uint8_t)ceil( ((((BMC_COLOR_RGB_MAGENTA)>>8)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_PIXEL_DIM_R_PERCENT_MAGENTA ((uint8_t)ceil( ((((BMC_COLOR_RGB_MAGENTA)>>16)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_COLOR_RGB_DIM_MAGENTA ( BMC_PIXEL_DIM_B_PERCENT_MAGENTA | ((BMC_PIXEL_DIM_G_PERCENT_MAGENTA) << 8) | ((BMC_PIXEL_DIM_R_PERCENT_MAGENTA) << 16) )
#endif
#ifndef BMC_COLOR_RGB_DIM_CYAN
  #define BMC_PIXEL_DIM_B_PERCENT_CYAN ((uint8_t)ceil( (((BMC_COLOR_RGB_CYAN)&0xFF) / (BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS) ))
  #define BMC_PIXEL_DIM_G_PERCENT_CYAN ((uint8_t)ceil( ((((BMC_COLOR_RGB_CYAN)>>8)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_PIXEL_DIM_R_PERCENT_CYAN ((uint8_t)ceil( ((((BMC_COLOR_RGB_CYAN)>>16)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_COLOR_RGB_DIM_CYAN ( BMC_PIXEL_DIM_B_PERCENT_CYAN | ((BMC_PIXEL_DIM_G_PERCENT_CYAN) << 8) | ((BMC_PIXEL_DIM_R_PERCENT_CYAN) << 16) )
#endif
#ifndef BMC_COLOR_RGB_DIM_WHITE
  #define BMC_PIXEL_DIM_B_PERCENT_WHITE ((uint8_t)ceil( (((BMC_COLOR_RGB_WHITE)&0xFF) / (BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS) ))
  #define BMC_PIXEL_DIM_G_PERCENT_WHITE ((uint8_t)ceil( ((((BMC_COLOR_RGB_WHITE)>>8)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_PIXEL_DIM_R_PERCENT_WHITE ((uint8_t)ceil( ((((BMC_COLOR_RGB_WHITE)>>16)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_COLOR_RGB_DIM_WHITE ( BMC_PIXEL_DIM_B_PERCENT_WHITE | ((BMC_PIXEL_DIM_G_PERCENT_WHITE) << 8) | ((BMC_PIXEL_DIM_R_PERCENT_WHITE) << 16) )
#endif
#ifndef BMC_COLOR_RGB_DIM_LIME
  #define BMC_PIXEL_DIM_B_PERCENT_LIME ((uint8_t)ceil( (((BMC_COLOR_RGB_LIME)&0xFF) / (BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS) ))
  #define BMC_PIXEL_DIM_G_PERCENT_LIME ((uint8_t)ceil( ((((BMC_COLOR_RGB_LIME)>>8)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_PIXEL_DIM_R_PERCENT_LIME ((uint8_t)ceil( ((((BMC_COLOR_RGB_LIME)>>16)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_COLOR_RGB_DIM_LIME ( BMC_PIXEL_DIM_B_PERCENT_LIME | ((BMC_PIXEL_DIM_G_PERCENT_LIME) << 8) | ((BMC_PIXEL_DIM_R_PERCENT_LIME) << 16) )
#endif
#ifndef BMC_COLOR_RGB_DIM_PINK
  #define BMC_PIXEL_DIM_B_PERCENT_PINK ((uint8_t)ceil( (((BMC_COLOR_RGB_PINK)&0xFF) / (BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS) ))
  #define BMC_PIXEL_DIM_G_PERCENT_PINK ((uint8_t)ceil( ((((BMC_COLOR_RGB_PINK)>>8)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_PIXEL_DIM_R_PERCENT_PINK ((uint8_t)ceil( ((((BMC_COLOR_RGB_PINK)>>16)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_COLOR_RGB_DIM_PINK ( BMC_PIXEL_DIM_B_PERCENT_PINK | ((BMC_PIXEL_DIM_G_PERCENT_PINK) << 8) | ((BMC_PIXEL_DIM_R_PERCENT_PINK) << 16) )
#endif
#ifndef BMC_COLOR_RGB_DIM_PURPLE
  #define BMC_PIXEL_DIM_B_PERCENT_PURPLE ((uint8_t)ceil( (((BMC_COLOR_RGB_PURPLE)&0xFF) / (BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS) ))
  #define BMC_PIXEL_DIM_G_PERCENT_PURPLE ((uint8_t)ceil( ((((BMC_COLOR_RGB_PURPLE)>>8)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_PIXEL_DIM_R_PERCENT_PURPLE ((uint8_t)ceil( ((((BMC_COLOR_RGB_PURPLE)>>16)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_COLOR_RGB_DIM_PURPLE ( BMC_PIXEL_DIM_B_PERCENT_PURPLE | ((BMC_PIXEL_DIM_G_PERCENT_PURPLE) << 8) | ((BMC_PIXEL_DIM_R_PERCENT_PURPLE) << 16) )
#endif
#ifndef BMC_COLOR_RGB_DIM_ORANGE
  #define BMC_PIXEL_DIM_B_PERCENT_ORANGE ((uint8_t)ceil( (((BMC_COLOR_RGB_ORANGE)&0xFF) / (BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS) ))
  #define BMC_PIXEL_DIM_G_PERCENT_ORANGE ((uint8_t)ceil( ((((BMC_COLOR_RGB_ORANGE)>>8)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_PIXEL_DIM_R_PERCENT_ORANGE ((uint8_t)ceil( ((((BMC_COLOR_RGB_ORANGE)>>16)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_COLOR_RGB_DIM_ORANGE ( BMC_PIXEL_DIM_B_PERCENT_ORANGE | ((BMC_PIXEL_DIM_G_PERCENT_ORANGE) << 8) | ((BMC_PIXEL_DIM_R_PERCENT_ORANGE) << 16) )
#endif
#ifndef BMC_COLOR_RGB_DIM_TEAL
  #define BMC_PIXEL_DIM_B_PERCENT_TEAL ((uint8_t)ceil( (((BMC_COLOR_RGB_TEAL)&0xFF) / (BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS) ))
  #define BMC_PIXEL_DIM_G_PERCENT_TEAL ((uint8_t)ceil( ((((BMC_COLOR_RGB_TEAL)>>8)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_PIXEL_DIM_R_PERCENT_TEAL ((uint8_t)ceil( ((((BMC_COLOR_RGB_TEAL)>>16)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_COLOR_RGB_DIM_TEAL ( BMC_PIXEL_DIM_B_PERCENT_TEAL | ((BMC_PIXEL_DIM_G_PERCENT_TEAL) << 8) | ((BMC_PIXEL_DIM_R_PERCENT_TEAL) << 16) )
#endif
#ifndef BMC_COLOR_RGB_DIM_CORAL
  #define BMC_PIXEL_DIM_B_PERCENT_CORAL ((uint8_t)ceil( (((BMC_COLOR_RGB_CORAL)&0xFF) / (BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS) ))
  #define BMC_PIXEL_DIM_G_PERCENT_CORAL ((uint8_t)ceil( ((((BMC_COLOR_RGB_CORAL)>>8)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_PIXEL_DIM_R_PERCENT_CORAL ((uint8_t)ceil( ((((BMC_COLOR_RGB_CORAL)>>16)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_COLOR_RGB_DIM_CORAL ( BMC_PIXEL_DIM_B_PERCENT_CORAL | ((BMC_PIXEL_DIM_G_PERCENT_CORAL) << 8) | ((BMC_PIXEL_DIM_R_PERCENT_CORAL) << 16) )
#endif
// for dim rainbow the leds will be red
#ifndef BMC_COLOR_RGB_DIM_RAINBOW
  #define BMC_PIXEL_DIM_B_PERCENT_RAINBOW ((uint8_t)ceil( (((BMC_COLOR_RGB_RED)&0xFF) / (BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS) ))
  #define BMC_PIXEL_DIM_G_PERCENT_RAINBOW ((uint8_t)ceil( ((((BMC_COLOR_RGB_RED)>>8)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_PIXEL_DIM_R_PERCENT_RAINBOW ((uint8_t)ceil( ((((BMC_COLOR_RGB_RED)>>16)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_COLOR_RGB_DIM_RAINBOW ( BMC_PIXEL_DIM_B_PERCENT_RAINBOW | ((BMC_PIXEL_DIM_G_PERCENT_RAINBOW) << 8) | ((BMC_PIXEL_DIM_R_PERCENT_RAINBOW) << 16) )
#endif
#ifndef BMC_COLOR_RGB_DIM_RAINBOW_FADE
  #define BMC_PIXEL_DIM_B_PERCENT_RAINBOW_FADE ((uint8_t)ceil( (((BMC_COLOR_RGB_RED)&0xFF) / (BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS) ))
  #define BMC_PIXEL_DIM_G_PERCENT_RAINBOW_FADE ((uint8_t)ceil( ((((BMC_COLOR_RGB_RED)>>8)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_PIXEL_DIM_R_PERCENT_RAINBOW_FADE ((uint8_t)ceil( ((((BMC_COLOR_RGB_RED)>>16)&0xFF)/(BMC_PIXEL_MAX_BRIGHTNESS+0.0)) * (BMC_PIXEL_DIM_BRIGHTNESS)))
  #define BMC_COLOR_RGB_DIM_RAINBOW_FADE ( BMC_PIXEL_DIM_B_PERCENT_RAINBOW_FADE | ((BMC_PIXEL_DIM_G_PERCENT_RAINBOW_FADE) << 8) | ((BMC_PIXEL_DIM_R_PERCENT_RAINBOW_FADE) << 16) )
#endif


#define BMC_HSV_HUE_RED       0
#define BMC_HSV_HUE_ORANGE    30
#define BMC_HSV_HUE_YELLOW    64
#define BMC_HSV_HUE_GREEN     96
#define BMC_HSV_HUE_CYAN      136 // 128
#define BMC_HSV_HUE_BLUE      160
#define BMC_HSV_HUE_PURPLE    192
#define BMC_HSV_HUE_MAGENTA   224
#define BMC_HSV_HUE_WHITE     0

class BMCPixelColors {
private:
  BMCPixelColors(){}
public:
  static uint32_t getRgbColor(uint8_t t_color){
    switch(t_color & 0x7F){
      case BMC_COLOR_BLACK: return BMC_COLOR_RGB_BLACK;
      case BMC_COLOR_RED: return BMC_COLOR_RGB_RED;
      case BMC_COLOR_GREEN: return BMC_COLOR_RGB_GREEN;
      case BMC_COLOR_YELLOW: return BMC_COLOR_RGB_YELLOW;
      case BMC_COLOR_BLUE: return BMC_COLOR_RGB_BLUE;
      case BMC_COLOR_MAGENTA: return BMC_COLOR_RGB_MAGENTA;
      case BMC_COLOR_CYAN: return BMC_COLOR_RGB_CYAN;
      case BMC_COLOR_WHITE: return BMC_COLOR_RGB_WHITE;
      //case BMC_COLOR_LIME: return BMC_COLOR_RGB_LIME;
      //case BMC_COLOR_PINK: return BMC_COLOR_RGB_PINK;
      //case BMC_COLOR_PURPLE: return BMC_COLOR_RGB_PURPLE;
      case BMC_COLOR_ORANGE: return BMC_COLOR_RGB_ORANGE;
      //case BMC_COLOR_TEAL: return BMC_COLOR_RGB_TEAL;
      //case BMC_COLOR_CORAL: return BMC_COLOR_RGB_CORAL;
      case BMC_COLOR_RAINBOW: return BMC_COLOR_RGB_RAINBOW;
      case BMC_COLOR_RAINBOW_FADE: return BMC_COLOR_RGB_RAINBOW_FADE;
    }
    return BMC_COLOR_RGB_BLACK;
  }

  // static uint32_t getDimmedColor(uint8_t t_index){
  //   #if BMC_TOTAL_PIXELS > 0
  //   switch(t_index){
  //     case BMC_COLOR_BLACK: return BMC_COLOR_RGB_DIM_BLACK;
  //     case BMC_COLOR_RED: return BMC_COLOR_RGB_DIM_RED;
  //     case BMC_COLOR_GREEN: return BMC_COLOR_RGB_DIM_GREEN;
  //     case BMC_COLOR_YELLOW: return BMC_COLOR_RGB_DIM_YELLOW;
  //     case BMC_COLOR_BLUE: return BMC_COLOR_RGB_DIM_BLUE;
  //     case BMC_COLOR_MAGENTA: return BMC_COLOR_RGB_DIM_MAGENTA;
  //     case BMC_COLOR_CYAN: return BMC_COLOR_RGB_DIM_CYAN;
  //     case BMC_COLOR_WHITE: return BMC_COLOR_RGB_DIM_WHITE;
  //     case BMC_COLOR_LIME: return BMC_COLOR_RGB_DIM_LIME;
  //     case BMC_COLOR_PINK: return BMC_COLOR_RGB_DIM_PINK;
  //     case BMC_COLOR_PURPLE: return BMC_COLOR_RGB_DIM_PURPLE;
  //     case BMC_COLOR_ORANGE: return BMC_COLOR_RGB_DIM_ORANGE;
  //     case BMC_COLOR_TEAL: return BMC_COLOR_RGB_DIM_TEAL;
  //     case BMC_COLOR_CORAL: return BMC_COLOR_RGB_DIM_CORAL;
  //     case BMC_COLOR_RAINBOW: return BMC_COLOR_RGB_DIM_RAINBOW;
  //     case BMC_COLOR_RAINBOW_FADE: return BMC_COLOR_RGB_DIM_RAINBOW_FADE;
  //   }
  //   #endif
  //   // default color would always be dimmed RED
  //   return BMC_COLOR_RGB_DIM_RED;
  // }

  static CHSV getHSVColor(uint8_t t_color){
    switch(t_color & 0x7F){
      case BMC_COLOR_BLACK: return CHSV(0, 0, 0);
      case BMC_COLOR_RED: return CHSV(BMC_HSV_HUE_RED, 255, 255);
      case BMC_COLOR_GREEN: return CHSV(BMC_HSV_HUE_GREEN, 255, 255);
      case BMC_COLOR_YELLOW: return CHSV(BMC_HSV_HUE_YELLOW, 255, 255);
      case BMC_COLOR_BLUE: return CHSV(BMC_HSV_HUE_BLUE, 255, 255);
      case BMC_COLOR_MAGENTA: return CHSV(BMC_HSV_HUE_MAGENTA, 255, 255);
      case BMC_COLOR_CYAN: return CHSV(BMC_HSV_HUE_CYAN, 255, 255);
      case BMC_COLOR_WHITE: return CHSV(BMC_HSV_HUE_WHITE, 0, 255); // White can be represented as low saturation and high value
      //case BMC_COLOR_LIME: return CHSV(85, 255, 255);  // Lime can be a bright green, hue 85
      //case BMC_COLOR_PINK: return CHSV(213, 255, 255); // Pink is closer to magenta, hue 213
      //case BMC_COLOR_PURPLE: return CHSV(160, 255, 255); // Purple is between red and blue, hue 160
      case BMC_COLOR_ORANGE: return CHSV(BMC_HSV_HUE_ORANGE, 255, 255); // Orange is between red and yellow, hue 42
      //case BMC_COLOR_TEAL: return CHSV(170, 255, 255); // Teal is cyan-like, hue 170
      //case BMC_COLOR_CORAL: return CHSV(15, 255, 255); // Coral is a reddish-orange, hue 15
      case BMC_COLOR_RAINBOW: return CHSV(0, 0, 0);
      case BMC_COLOR_RAINBOW_FADE: return CHSV(0, 0, 0);
    }
    return CHSV(0, 0, 0);
  }
  static uint32_t getDimmedColor(uint8_t t_index){
    #if BMC_TOTAL_PIXELS > 0
    switch(t_index){
      case BMC_COLOR_BLACK: return BMC_COLOR_RGB_DIM_BLACK;
      case BMC_COLOR_RED: return BMC_COLOR_RGB_DIM_RED;
      case BMC_COLOR_GREEN: return BMC_COLOR_RGB_DIM_GREEN;
      case BMC_COLOR_YELLOW: return BMC_COLOR_RGB_DIM_YELLOW;
      case BMC_COLOR_BLUE: return BMC_COLOR_RGB_DIM_BLUE;
      case BMC_COLOR_MAGENTA: return BMC_COLOR_RGB_DIM_MAGENTA;
      case BMC_COLOR_CYAN: return BMC_COLOR_RGB_DIM_CYAN;
      case BMC_COLOR_WHITE: return BMC_COLOR_RGB_DIM_WHITE;
      case BMC_COLOR_LIME: return BMC_COLOR_RGB_DIM_LIME;
      case BMC_COLOR_PINK: return BMC_COLOR_RGB_DIM_PINK;
      case BMC_COLOR_PURPLE: return BMC_COLOR_RGB_DIM_PURPLE;
      case BMC_COLOR_ORANGE: return BMC_COLOR_RGB_DIM_ORANGE;
      case BMC_COLOR_TEAL: return BMC_COLOR_RGB_DIM_TEAL;
      case BMC_COLOR_CORAL: return BMC_COLOR_RGB_DIM_CORAL;
      case BMC_COLOR_RAINBOW: return BMC_COLOR_RGB_DIM_RAINBOW;
      case BMC_COLOR_RAINBOW_FADE: return BMC_COLOR_RGB_DIM_RAINBOW_FADE;
    }
    #endif
    // default color would always be dimmed RED
    return BMC_COLOR_RGB_DIM_RED;
  }
};
#endif
