## The mystery of control registers for FM6126A chips

  
The only available Datasheet for this chips is in Chinese and does not shed a light on what those two control regs are.

An excellent insight could be found here https://github.com/hzeller/rpi-rgb-led-matrix/issues/746#issuecomment-453860510

  

So there are two regs in this chip - **REG1** and **REG2**,
one could be written with 12 clock pulses (and usually called reg12, dunno why :))
the other one could be written with 13 clock pulses (and usually called reg13, dunno why :))
  

I've done some measurements on power consumption while toggling bits of **REG1** and it looks that it could provide a fine grained brightness control over the entire matrix with no need for bitbanging over RGB or EO pins.
There are 6 bits (6 to 11) giving an increased brightness (compared to all-zeroes) and 4 bits (2-5) giving decreased brightness!!!
Still unclear if FM6112A brightness control is internally PWMed or current limited, might require some poking with oscilloscope.

So it seems that the most bright (and hungry for power) value is bool REG1[16] = {0,0,0,0,0, 1,1,1,1,1,1, 0,0,0,0,0}; and not {0,1,1,1,1, 1,1,1,1,1,1, 1,1,1,1,1} as it is usually used.
I'm not sure about bit 1 - it is either not used or I was unable to measure it's influence to brightness/power.

Giving at least 10 bits of hardware brightness control opens pretty nice options for offloading and simplifying matrix output. Should dig into this more deeper.

Here are some of the measurements I've took for 2 64x64 panels filled with white color - reg value and corresponding current drain in amps.
  

|REG1 |bit value|Current, amps |
|--|--|--|
|REG1| 0111111 00000| >5 amps|
|REG1| 0100010 00000| 3.890 amp|
|REG1| 0100000 00000| 3.885 amp|
|REG1| 0011110 00000| 3.640 amp|
|REG1| 0011100 00000| 3.620 amp|
|REG1| 0011000 00000| 3.240 amp|
|REG1| 0010010 00000| 2.520 amp|
|REG1| 0010001 00000| 2.518 amp|
|REG1| 0010001 10000| 2.493 amp|
|REG1| 0010000 00000| 2.490 amp|
|REG1| 0010000 11110| 2.214 amp|
|REG1| 0001100 00000| 2.120 amp|
|REG1| 0001000 00000| 1.750 amp|
|REG1| 0000100 00000| 1.375 amp|
|REG1| 0000010 00000| 1.000 amp|
|REG1| **0000000 00000**| 0.995 amp|
|REG1| 0000001 11111| 0.700 amp|
|REG1| 0000000 01111| 0.690 amp|
|REG1| 0000000 10000| 0.690 amp|
|REG1| 0000000 11110| 0.686 amp|


/Vortigont/