/* Uncomment one and only one below Dev Device pins header */
// #include <PINS_ESP32-S3-CAM.h>
// #include <PINS_T-DECK.h>
// #include <PINS_T-DISPLAY_S3_AMOLED.h>
// #include <PINS_XIAO_ESP32C6.h>

#ifndef DEV_DEVICE_PINS
#error "Please include one of the Dev Device pins header"
#endif

#ifndef LED_A
#ifndef GFX_BL
#error "No LED_A pin defined in this Dev Device"
#else
#define LED_A GFX_BL // Blink display backlight instead
#endif
#endif

/*
  Blink

  Turns an LED on for one second, then off for one second, repeatedly.

  Most Arduinos have an on-board LED you can control. On the UNO, MEGA and ZERO
  it is attached to digital pin 13, on MKR1000 on pin 6. LED_BUILTIN is set to
  the correct LED pin independent of which board is used.
  If you want to know what pin the on-board LED is connected to on your Arduino
  model, check the Technical Specs of your board at:
  https://www.arduino.cc/en/Main/Products

  modified 8 May 2014
  by Scott Fitzgerald
  modified 2 Sep 2016
  by Arturo Guadalupi
  modified 8 Sep 2016
  by Colby Newman

  This example code is in the public domain.

  https://www.arduino.cc/en/Tutorial/BuiltInExamples/Blink
*/

// the setup function runs once when you press reset or power the board
void setup()
{
#ifdef DEV_DEVICE_INIT
  DEV_DEVICE_INIT();
#endif

  // initialize digital pin LED_BUILTIN as an output.
  pinMode(LED_A, OUTPUT);
}

// the loop function runs over and over again forever
void loop()
{
  digitalWrite(LED_A, HIGH); // turn the LED on (HIGH is the voltage level)
  delay(1000);               // wait for a second
  digitalWrite(LED_A, LOW);  // turn the LED off by making the voltage LOW
  delay(1000);               // wait for a second
}
