/**
 * The example to add new message to the mailbox.
 * For proper network/SSL client and port selection, please see http://bit.ly/46Xu9Yk
 */
#include <Arduino.h>
#include "Networks.h"


#define ENABLE_SMTP  // Allows SMTP class and data
#define ENABLE_IMAP  // Allows IMAP class and data
#define ENABLE_DEBUG // Allows debugging
#define READYMAIL_DEBUG_PORT Serial
#include <ReadyMail.h>

#define IMAP_HOST "_______"
#define IMAP_PORT 993 // SSL or 143 for PLAIN TEXT or STARTTLS
#define AUTHOR_EMAIL "_______"
#define AUTHOR_PASSWORD "_______"

#define WIFI_SSID "_______"
#define WIFI_PASSWORD "_______"

#define READ_ONLY_MODE false
#define AWAIT_MODE true
#define FLAGS ""

const char *dinoImg = "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";

WiFiClientSecure ssl_client;
IMAPClient imap(ssl_client);

// For more information, see https://bit.ly/4h9JR7p
void imapCb(IMAPStatus status)
{
    ReadyMail.printf("ReadyMail[imap][%d]%s\n", status.state, status.text.c_str());
}

void setup()
{
    Serial.begin(115200);
    Serial.println();

    WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
    Serial.print("Connecting to Wi-Fi");
    while (WiFi.status() != WL_CONNECTED)
    {
        Serial.print(".");
        delay(300);
    }
    Serial.println();
    Serial.print("Connected with IP: ");
    Serial.println(WiFi.localIP());
    Serial.println();

    // If server SSL certificate verification was ignored for this ESP32 WiFiClientSecure.
    // To verify root CA or server SSL cerificate,
    // please consult your SSL client documentation.
    ssl_client.setInsecure();

    // In case ESP8266 crashes, please see https://bit.ly/48r4wSe

    imap.connect(IMAP_HOST, IMAP_PORT, imapCb);
    if (!imap.isConnected())
        return;

    imap.authenticate(AUTHOR_EMAIL, AUTHOR_PASSWORD, readymail_auth_password);
    if (!imap.isAuthenticated())
        return;

    // Select INBOX mailbox.
    imap.select("INBOX", READ_ONLY_MODE);

    SMTPMessage smtp_msg;

    smtp_msg.headers.add(rfc822_subject, "afternoon meeting");
    smtp_msg.headers.add(rfc822_from, "Fred Foobar <oobar@Blurdybloop.example.com>");
    smtp_msg.headers.add(rfc822_to, "Joe Mooch <mooch@owatagu.example.net>");

    smtp_msg.text.body("Hello Joe, do you think we can meet at 3:30 tomorrow?");
    smtp_msg.text.charset("us-ascii");
    smtp_msg.text.transferEncoding("7bit");

    Attachment attachment;
    attachment.filename = "dino.png";
    attachment.mime = "image/png";
    attachment.name = "dino";
    attachment.attach_file.blob = (uint8_t *)dinoImg;
    attachment.attach_file.blob_size = strlen(dinoImg);

    // Specify only when content is already encoded.
    attachment.content_encoding = "base64";
    smtp_msg.attachments.add(attachment, attach_type_attachment);

    // Append new message (some IMAP server may not support APPEND and returns error)
    imap.append(smtp_msg, FLAGS, ReadyMail.getDateTimeString(1745680924, "%a, %d %b %Y %H:%M:%S %z") /* rfc 2822 date */, AWAIT_MODE);
}

void loop()
{
}