/**
 * Responds to any HTTP request.
 *
 * @param {!express:Request} req HTTP request context.
 * @param {!express:Response} res HTTP response context.
 */
exports.helloWorld = (req, res) => {
    let message = req.query.message || req.body.message || "Hello World!";
    if (typeof req.body.info !== "undefined") {
        message = "Hello, I am " + req.body.info.name + ". I am " + req.body.info.age + " years old.";
    }
    res.status(200).send(message);
};