/**
 * Created February 1, 2023
 */

#ifndef GS_Error_H
#define GS_Error_H

#pragma once

#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_UNDEFINED -1000
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE -100

/// TCP client errors
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TCP_ERROR_CONNECTION_REFUSED (-1)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TCP_ERROR_SEND_REQUEST_FAILED (-2)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TCP_ERROR_NOT_CONNECTED (-3)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TCP_ERROR_CONNECTION_LOST (-4)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TCP_ERROR_NO_STREAM (-5)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TCP_ERROR_NO_HTTP_SERVER (-6)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TCP_ERROR_TOO_LESS_RAM (-7)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TCP_ERROR_ENCODING (-8)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TCP_ERROR_STREAM_WRITE (-9)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TCP_ERROR_CONNECTION_INUSED (-10)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TCP_RESPONSE_PAYLOAD_READ_TIMED_OUT (-11)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TCP_RESPONSE_READ_FAILED (-12)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TCP_CLIENT_MISSING_NETWORK_CONNECTION_CB (-13)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TCP_CLIENT_MISSING_NETWORK_STATUS_CB (-14)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TCP_CLIENT_NOT_INITIALIZED (-15)


/// HTTP codes see RFC7231
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_OK 200
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_NON_AUTHORITATIVE_INFORMATION 203
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_NO_CONTENT 204
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_MOVED_PERMANENTLY 301
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_FOUND 302
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_USE_PROXY 305
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_TEMPORARY_REDIRECT 307
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_PERMANENT_REDIRECT 308
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_BAD_REQUEST 400
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_UNAUTHORIZED 401
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_FORBIDDEN 403
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_NOT_FOUND 404
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_METHOD_NOT_ALLOWED 405
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_NOT_ACCEPTABLE 406
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_PROXY_AUTHENTICATION_REQUIRED 407
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_REQUEST_TIMEOUT 408
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_LENGTH_REQUIRED 411
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_PRECONDITION_FAILED 412
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_PAYLOAD_TOO_LARGE 413
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_URI_TOO_LONG 414
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_MISDIRECTED_REQUEST 421
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_UNPROCESSABLE_ENTITY 422
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_TOO_MANY_REQUESTS 429
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_REQUEST_HEADER_FIELDS_TOO_LARGE 431
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_INTERNAL_SERVER_ERROR 500
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_NOT_IMPLEMENTED 501
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_BAD_GATEWAY 502
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_SERVICE_UNAVAILABLE 503
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_GATEWAY_TIMEOUT 504
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_HTTP_VERSION_NOT_SUPPORTED 505
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_LOOP_DETECTED 508
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_HTTP_CODE_NETWORK_AUTHENTICATION_REQUIRED 511

// Gsheet error
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_BUFFER_OVERFLOW /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 1)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_DATA_TYPE_MISMATCH /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 2)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_PATH_NOT_EXIST /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 3)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_EXTERNAL_CLIENT_DISABLED /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 4)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_EXTERNAL_CLIENT_NOT_INITIALIZED /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 5)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TOKEN_SET_TIME /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 6)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TOKEN_PARSE_PK /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 7)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TOKEN_SIGN /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 8)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TOKEN_EXCHANGE /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 9)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TOKEN_NOT_READY /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 10)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_SYS_TIME_IS_NOT_READY /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 11)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_NTP_SYNC_TIMED_OUT /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 12)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TOKEN_COMPLETE_NOTIFY /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 13)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TOKEN_COMPLETE_UNNOTIFY /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 14)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_TOKEN_ERROR_UNNOTIFY /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 15)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_MISSING_SERVICE_ACCOUNT_CREDENTIALS /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 16)
#define ESP_GOOGLE_SHEET_CLIENT_ERROR_SERVICE_ACCOUNT_JSON_FILE_PARSING_ERROR /*          */ (ESP_GOOGLE_SHEET_CLIENT_ERROR_RANGE - 17)
#endif