# SchneiderModbusTCP

A lightweight Modbus TCP client library for Schneider Conext inverters, MPPTs, and battery monitors. 

## Features

- Read 16-bit and 32-bit Modbus holding registers
- Write 16-bit and 32-bit values
- Read/write single coil values
- Optimized for ESP32

## Example

```cpp
#include <WiFi.h>
#include <SchneiderModbusTCP.h>

SchneiderModbusTCP modbus;

void setup() {
  Serial.begin(115200);
  WiFi.begin("your_ssid", "your_password");
  while (WiFi.status() != WL_CONNECTED) delay(500);

  uint16_t volts;
  if (modbus.readHoldingRegister16("192.168.3.131", 503, 191, 71, volts)) {
    Serial.printf("Battery Voltage: %.1f V\n", volts / 10.0);
  } else {
    Serial.println("Failed to read voltage.");
  }
}

void loop() {}
```

## License

MIT
