#include <WiFi.h>
#include <SchneiderModbusTCP.h>

SchneiderModbusTCP modbus;

const char* ssid = "your_ssid";
const char* password = "your_password";
const char* inverterIP = "192.168.3.131";
const int port = 503;

void setup() {
  Serial.begin(115200);
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("\nConnected to WiFi!");

  uint16_t reg16;
  if (modbus.readHoldingRegister16(inverterIP, port, 10, 40084, reg16)) {
    Serial.printf("Inverter Power (16-bit): %d W\n", reg16);
  } else {
    Serial.println("Failed to read 16-bit power register.");
  }

  uint32_t reg32;
  if (modbus.readHoldingRegister32(inverterIP, port, 10, 40078, reg32)) {
    Serial.printf("Inverter Voltage (32-bit): %.2f V\n", reg32 / 100.0);
  } else {
    Serial.println("Failed to read 32-bit voltage register.");
  }

  // Write a test value to a 16-bit register
  if (modbus.writeSingleRegister16(inverterIP, port, 10, 40500, 1234)) {
    Serial.println("Wrote 1234 to register 40500.");
  }

  // Write a test value to a 32-bit register
  if (modbus.writeSingleRegister32(inverterIP, port, 10, 40510, 12345678)) {
    Serial.println("Wrote 12345678 to register 40510.");
  }

  // Read and toggle a coil
  bool coil;
  if (modbus.readCoil(inverterIP, port, 50, 1, coil)) {
    Serial.printf("Generator coil is currently: %s\n", coil ? "ON" : "OFF");
    modbus.writeSingleCoil(inverterIP, port, 50, 1, !coil);
  } else {
    Serial.println("Failed to read generator coil.");
  }
}

void loop() {}
