#include <RGBLEDMatrix.h>
#include <TimerAction.h>
#include <RGBAnimation.h>
#include <RGBAnimationSequence.h>

RGBLEDMatrix leds(10,10);

PROGMEM const RGBColorType invader1A[64] = {
    BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR, 
    BLACK_COLOR,BLACK_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,BLACK_COLOR,
    BLACK_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,
    DARK_GREEN_COLOR,DARK_GREEN_COLOR,WHITE_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,WHITE_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,
    DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,
    BLACK_COLOR,BLACK_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,BLACK_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,BLACK_COLOR,
    BLACK_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,
    DARK_GREEN_COLOR,BLACK_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,BLACK_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,DARK_GREEN_COLOR
};

PROGMEM const RGBColorType invader1B[64] = {
    BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
    BLACK_COLOR,BLACK_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,BLACK_COLOR,
    BLACK_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,
    DARK_GREEN_COLOR,DARK_GREEN_COLOR,WHITE_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,WHITE_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,
    DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,
    BLACK_COLOR,BLACK_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,BLACK_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,BLACK_COLOR,
    BLACK_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,DARK_GREEN_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,
    BLACK_COLOR,DARK_GREEN_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,DARK_GREEN_COLOR,BLACK_COLOR
};


PROGMEM const RGBColorType invader2A[64] = {
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,BLACK_COLOR,
  RED_COLOR,RED_COLOR,LIME_COLOR,RED_COLOR,RED_COLOR,LIME_COLOR,RED_COLOR,RED_COLOR,
  RED_COLOR,RED_COLOR,LIME_COLOR,RED_COLOR,RED_COLOR,LIME_COLOR,RED_COLOR,RED_COLOR,
  BLACK_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,RED_COLOR,BLACK_COLOR,BLACK_COLOR,RED_COLOR,BLACK_COLOR,BLACK_COLOR,
  RED_COLOR,RED_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,RED_COLOR,RED_COLOR
};

PROGMEM const RGBColorType invader2B[64] = {
  BLACK_COLOR,BLACK_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,BLACK_COLOR,
  RED_COLOR,RED_COLOR,LIME_COLOR,RED_COLOR,RED_COLOR,LIME_COLOR,RED_COLOR,RED_COLOR,
  RED_COLOR,RED_COLOR,LIME_COLOR,RED_COLOR,RED_COLOR,LIME_COLOR,RED_COLOR,RED_COLOR,
  BLACK_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,RED_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,RED_COLOR,BLACK_COLOR,BLACK_COLOR,RED_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,RED_COLOR,BLACK_COLOR,BLACK_COLOR,RED_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,RED_COLOR,BLACK_COLOR,BLACK_COLOR,RED_COLOR,BLACK_COLOR,BLACK_COLOR
};

PROGMEM const RGBColorType invader3A[64] = {
  BLACK_COLOR,BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR,BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR,BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,BLACK_COLOR,
  ORANGE_COLOR,ORANGE_COLOR,WHITE_COLOR,ORANGE_COLOR,ORANGE_COLOR,WHITE_COLOR,ORANGE_COLOR,ORANGE_COLOR,
  ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,
  ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,
  ORANGE_COLOR,BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR,BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR,ORANGE_COLOR,
  BLACK_COLOR,BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR,BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR,BLACK_COLOR
};

PROGMEM const RGBColorType invader3B[64] = {
  BLACK_COLOR,BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR,BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR,BLACK_COLOR,
  ORANGE_COLOR,BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR,BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR,ORANGE_COLOR,
  ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,
  ORANGE_COLOR,ORANGE_COLOR,WHITE_COLOR,ORANGE_COLOR,ORANGE_COLOR,WHITE_COLOR,ORANGE_COLOR,ORANGE_COLOR,
  ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,
  BLACK_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,ORANGE_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR,BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,ORANGE_COLOR,BLACK_COLOR
};

PROGMEM const RGBColorType invader4A[72] = {
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  YELLOW_COLOR,YELLOW_COLOR,BLUE_COLOR,BLUE_COLOR,YELLOW_COLOR,YELLOW_COLOR,BLUE_COLOR,BLUE_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,CORAL_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR
};
 
PROGMEM const RGBColorType invader4B[72] = {
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  BLUE_COLOR,YELLOW_COLOR,YELLOW_COLOR,BLUE_COLOR,BLUE_COLOR,YELLOW_COLOR,YELLOW_COLOR,BLUE_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,CORAL_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,CORAL_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR
};
 
PROGMEM const RGBColorType invader4C[72] = {
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  BLUE_COLOR,BLUE_COLOR,YELLOW_COLOR,YELLOW_COLOR,BLUE_COLOR,BLUE_COLOR,YELLOW_COLOR,YELLOW_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,CORAL_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,CORAL_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,CORAL_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR
};
 
PROGMEM const RGBColorType invader4D[72] = {
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  YELLOW_COLOR,BLUE_COLOR,BLUE_COLOR,YELLOW_COLOR,YELLOW_COLOR,BLUE_COLOR,BLUE_COLOR,YELLOW_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,CORAL_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,CORAL_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR
};

PROGMEM const RGBColorType invader4E[72] = {
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  YELLOW_COLOR,YELLOW_COLOR,BLUE_COLOR,BLUE_COLOR,YELLOW_COLOR,YELLOW_COLOR,BLUE_COLOR,BLUE_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,CORAL_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR
};

PROGMEM const RGBColorType invader4F[72] = {
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  BLUE_COLOR,YELLOW_COLOR,YELLOW_COLOR,BLUE_COLOR,BLUE_COLOR,YELLOW_COLOR,YELLOW_COLOR,BLUE_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR
};

PROGMEM const RGBColorType invader4G[72] = {
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  BLUE_COLOR,BLUE_COLOR,YELLOW_COLOR,YELLOW_COLOR,BLUE_COLOR,BLUE_COLOR,YELLOW_COLOR,YELLOW_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR
};

PROGMEM const RGBColorType invader4H[72] = {
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  YELLOW_COLOR,BLUE_COLOR,BLUE_COLOR,YELLOW_COLOR,YELLOW_COLOR,BLUE_COLOR,BLUE_COLOR,YELLOW_COLOR,
  BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLUE_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,
  BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR,BLACK_COLOR
};

// first
ColorBitmapSequenceAnimation::Frame ani1[2] = {
  {
    invader1A,
    8, 8,
    1, 1,
    500
  },
  {
    invader1B,
    8, 8,
    1, 1,
    500
  }
};

// second
ColorBitmapSequenceAnimation::Frame ani2[2] = {
  {
    invader2A,
    8, 8,
    1, 1,
    500
  },
  {
    invader2B,
    8, 8,
    1, 1,
    500
  },
};
 
// third
ColorBitmapSequenceAnimation::Frame ani3[2] = {
  {
    invader3A,
    8, 8,
    1, 1,
    500
  },
  {
    invader3B,
    8, 8,
    1, 1,
    500
  }
};

// fourth
ColorBitmapSequenceAnimation::Frame ani4[8] = {
  {
    invader4A,
    8, 9,
    1, 1,
    250
  },
  {
    invader4B,
    8, 9,
    1, 1,
    250
  },
  {
    invader4C,
    8, 9,
    1, 1,
    250
  },
  {
    invader4D,
    8, 9,
    1, 1,
    250
  },
  {
    invader4E,
    8, 9,
    1, 1,
    250
  },
  {
    invader4F,
    8, 9,
    1, 1,
    250
  },
  {
    invader4G,
    8, 9,
    1, 1,
    250
  },
  {
    invader4H,
    8, 9,
    1, 1,
    250
  }
};

// animation
const int ANIMATION_ITEMS_SIZE = 9;
RGBAnimationSequence::AnimationItem aniItems[ANIMATION_ITEMS_SIZE] {
  {
    new ColorBitmapSequenceAnimation( leds, ani1, 2, BLACK_COLOR ),
    4000,
    2000,
    RGBAnimationSequence::TRANSITION_SLIDE_LEFT,
    2
  },
  {
    new ColorBitmapSequenceAnimation( leds, ani1, 2, BLACK_COLOR ),
    4000,
    2000,
    RGBAnimationSequence::TRANSITION_SLIDE_DOWN,
    2
  },
  {
    new ColorBitmapSequenceAnimation( leds, ani2, 2, BLACK_COLOR ),
    4000,
    2000,
    RGBAnimationSequence::TRANSITION_SLIDE_RIGHT,
    2
  },
  {
    new ColorBitmapSequenceAnimation( leds, ani2, 2, BLACK_COLOR ),
    4000,
    2000,
    RGBAnimationSequence::TRANSITION_SLIDE_DOWN,
    2
  },
  {
    new ColorBitmapSequenceAnimation( leds, ani3, 2, BLACK_COLOR ),
    4000,
    2000,
    RGBAnimationSequence::TRANSITION_SLIDE_LEFT,
    2
  },
  {
    new ColorBitmapSequenceAnimation( leds, ani3, 2, BLACK_COLOR ),
    4000,
    2000,
    RGBAnimationSequence::TRANSITION_SLIDE_DOWN,
    2
  },
  {
    new ColorBitmapSequenceAnimation( leds, ani4, 8, BLACK_COLOR ),
    6000,
    2000,
    RGBAnimationSequence::TRANSITION_SLIDE_UP,
    2
  },
  {
    new ColorBitmapSequenceAnimation( leds, ani3, 2, BLACK_COLOR ),
    0,
    2000,
    RGBAnimationSequence::TRANSITION_SLIDE_UP,
    2
  },
  {
    new ColorBitmapSequenceAnimation( leds, ani2, 2, BLACK_COLOR ),
    0,
    2000,
    RGBAnimationSequence::TRANSITION_SLIDE_UP,
    2
  },
  
};

RGBAnimationSequence animation( aniItems, ANIMATION_ITEMS_SIZE);

void setup() {
    leds.setup();
    leds.startScanning();
}

void loop() {  
  leds.loop();
  animation.loop();
}

