#include <Arduino.h>
#include <SoftwareSerial.h>
#include <pdulib.h>

//SoftwareSerial GSM(2,3);  // UNO
SoftwareSerial GSM(10,11);  // Mega2560

// Adjust BUFFER_SIZE until the buffer overflow message goes away
#define BUFFER_SIZE 100
PDU mypdu=PDU(BUFFER_SIZE);

#define BUF_SIZE 340 // at least 340 for a full length message
char linebuf[BUF_SIZE];
int inCount = 0;
bool nextLinePDU = false;

void setup() {
  Serial.begin(9600);
#ifdef PM
  Serial.println("Using PM");
#else
  Serial.println("Not using PM");
#endif
  Serial.print("Buffer Size ");Serial.println(BUFFER_SIZE);
  GSM.begin(9600);
  delay(500);
  GSM.println("ATE0");  // echo off
  delay(500);
  GSM.println("ST+CMGF=0");  // PDU mode
  delay(500);
  Serial.println("Send me text messages.. now  ");
}

void processLine() {
//  Serial.print(linebuf);   // uncomment if you want to see inciming data from GSM device
  if (nextLinePDU) {
    if (mypdu.decodePDU(linebuf)) {
      if (mypdu.getOverflow())
        Serial.println("Buffer Overflow, partial message only");
      Serial.print("From: "); Serial.println(mypdu.getSender());
      Serial.print("Timestamp: "); Serial.println(mypdu.getTimeStamp());
      Serial.print("Msg: "); Serial.print("Length "); Serial.println(strlen(mypdu.getText()));
      Serial.println(mypdu.getText());
      // is this standalone or multi-part ?
      int *concat = mypdu.getConcatInfo();
      if (concat[0] == 0)
        Serial.println("This is a standalone message");
      else {
        sprintf(linebuf,"Mulitpart %d of %d ref %d",concat[1],concat[2],concat[0]);
        Serial.println(linebuf);
      }
    }
    nextLinePDU = false;
  }
  else if (strncmp("+CMT:",linebuf,5) == 0) {
    nextLinePDU = true;
  }
  memset(linebuf,0,sizeof(linebuf));
  inCount = 0;  
}
void loop() {
  while (GSM.available()) {
    byte b = GSM.read();
    //Serial.print(b,HEX);
    linebuf[inCount++] = b;
    if (inCount == BUF_SIZE) {
      Serial.println("buffer overflow");
      inCount = 0;
    }
    if (b == 0x0A) {   // end of line
      processLine();
    }
  }
}