#include <iostream>
#include <iomanip>
#include <cstring>

using std::hex;
using std::setw;

#include <pdulib.h>

const char *msgs[] = {
    /* 16 bit concatenated 1 byte ref number*/
//  "07917952140230F2440C917952541989680008224031013445218C05000361080105D005DC002005EA05D205D905D305D5002005DC05D0002005D905D305E205E005D5002005DC05D0002005E905DE05E205E005D5000A05DE05D105E605E205D9002005D705D2002005D405D005D105D905D1002005D105DC05D905E705E8002005DE05E805E705D800200078006F000A05DE05D705DB05D905DD002005DC05DB05DD002005DC",
//  "07917952140230F2440C917952541989680008224031013455218C05000361080205E705E805D005EA002005D405E405E105D7002005D105DB05DC002005D405DE05D705DC05E705D505EA002005E905DC05E005D5000A05D105DC05D905E705E8002005DE05E805E705D80020006200690067002005E705E805D905D505EA000A05E605DC05E605DC05D5002005D005DC05D905E005D5003A00300034002D0038003700320034",
//  "07917952140230F2440C917952541989680008224031013455218C050003610803003300330033000A05DE05D105D705E8002005DE05D105E605E205D905DD002005DC05D705D105E805D9002005DE05D505E205D305D505DF000A05E805DE05EA002005D705D105E805D505DF002005D005E805DE05D205D305D505DF0020003400330039000A05E405D905D905D1002005E105D805D505E005E1002005D505D905E805D805D5",
//  "07917952140230F2440C917952541989680008224031013465218C05000361080605E805D805D5002005E705D505D505D005DC05D9002005DE05D505D705D905D805D5002005DC05D905D805E80020003100330039000A05E705DE05E405E805D9002005DC05D905D805E8002000370034002E00390030000A002A05DC05DC05D0002005E605D105D905E805EA002005E005E705F3002C05E205D3002005D205DE05E8002005D4",
//  "07917952140230F2440C917952541989680008224031013465218C05000361080705DE05DC05D005D9000A05D405DE05D105E605E2002005D105EA05D505E705E3002005E205D3002005D400320034002E0034000A05DC05D405E105E805D4002005DC05D705E5003A00200068007400740070003A002F002F006200690074002E006C0079002F00320062004E007300610067007A000A05DC05D0002005E005D905EA05DF0020",
//  "07917952140230F2440C917952541989680008224031013465212205000361080805DC05D405E905D905D1002005DC05DE05E105E405E8002005D605D4",
//  "07917952140230F2440C917952541989680008224031013455218C05000361080405D005D505D60020003200320039000A05D805D505E805D0002005DE05D005D505E005D805D905DF002005E405D905E70020003100370020003100380039000A05D405E805D9002005D205DC05D905DC002005DE05D905E805D505DF002000370035000A05DE05D205D505D505DF002005D105E705F3002005DE05D205E005D505DD00200031",
    /* 16 bit concateneated 2 byte ref number */
//  "07917952140230F2440C917952541989680008224031013465218D0608040261080500300025002005D405E005D705D40021000A05D205F305D905DF002005E205DB05D5002005D905D505DC05D905D505E10020003100350039000A05D505D505D305E705D4002005E805D505D105E805D805D5002005E705D505D505D005DC05D9002005DC05D905D805E80020003100330039000A05D505D505D305E705D4002005E805D505D1",
  /* 16 bit not concatenated */
//  "07917952140230F2040C917952777777770008120170016131212200680065006C006C006F003000A505D02660D83CDCA1D83DDE0005E905DC05D505DD",
  /* 7 bit concatenated */
 //   "07917952140280F2440C91795254198968000022408201643121A00500035D030140C170381C0E87C3E170301C0E87C3E17038AC0886C3E170381C0E8783E170381C0E87C3E160381C0E87C38A60381C0E87C3E17038180E87C3E170381C0605C3E170381C0E8715C170381C0E87C3E170301C0E87C3E17038AC0886C3E170381C0E8783E170381C0E87C3E160381C0E87C38A60381C0E87C3E17038180E87C3E170381C0605C3",
 //   "07917952140230F2440C91795254198968000022408201643121300500035D0303C2E170381C0E07C3E170381C0E87C3A060381C0E87C3E1B04228168BC56231482C168B15",
 //   "07917952140280F1440C91795254198968000022408201643121A00500035D0302C2E170381C0E2B8462B1582C1683C462B158110C87C3E170381C0E07C3E170381C0E87C38A60381C0E87C3E17038180E87C3E170381C0E86C3E17038AC0886C3E170381C0E8783E170381C0E87C36150301C0E87C3E17058110C87C3E170381C0E07C3E170381C0E87C38A60381C0E87C3E17038180E87C3E170381C0E86C3E17038AC0886C3",
//    "07917952140230F2440C91795254198968000022408281038421A00500035F020182E170381C0E87C361A1582C168BC562B178381E8FC7E3F1783C5610C96432994C2693C9C572B95C2E97CBE5B2D16C369BCD66B3D9AC389ECFE7F3F97C3E9F9168341A8D46A3D1E8643A9D4EA7D3E9745A110C87C3E170381C0E0BC562B1582C168BC5C3F1783C1E8FC7E3B182482693C96432994C2E96CBE572B95C2E978D66B3D96C369BCD",
  //  "07917952140230F2440C91795254198968000022408281038421280500035F0202CC8AE3F97C3E9FCFE7F3198946A3D168341A8D4EA6D3E9743A9D4EA715",
  //  "07917952140230F2440C91795254198968000022408261731121A00500035E020182E170381C0E87C3E170381C0E87C7E3F1783C1E8FC7E3F1783C1E8FC7E3F1783C1E8FC7E3F1783C1E8FC776BBDD6EB7DBED76BBFD7C3E9FCFE7F3F97C3E9FCFE7F3F97C3E9FCFE7F3F97C3E9FCFE7F3F97C3E9FCFE7F3F97C3E9FEDE7F3F97C3E9FCFE7F3F97C3E9FCFE7F3F97C3E9FCFE7F3F97C3E9FCFE7F3F97C3E9FCFE7F3F97C3E9FCF",
  //  "07917952140230F2440C91795254198968000022408261731121240500035E0202CEE7F3F97C3E9FCFE7F3F97C3E9FCFE7F3F97C3E9FCFE7F3F90C",
  /* 7 bit not concatenated */
 // "06910379010023040DD05774983EAFC20100002230603023928046456C318901D960B013C8027D62404FCA13447D3A41CB27A6F904519F59D01519A49EA6A02A146479664114E4E4997582A8482708167BC168A0984C078301", 
 // "07917952140230F2040C9179527777777700001201216123732106CA405B8D6000", //    GSM 7 bit
// "07917952140230F2040C917952541989680000224082618490218EC170381C0E87C3E170381C0E87C3E3F1783C1E8FC7E3F1783C1E8FC7E3F1783C1E8FC7E3F1783C1E8FC763BBDD6EB7DBED76BBDD7E3E9FCFE7F3F97C3E9FCFE7F3F97C3E9FCFE7F3F97C3E9FCFE7F3F97C3E9FCFE7F3F97C3E9FCFF6F3F97C3E9FCFE7F3F97C3E9FCFE7F3F97C3E9FCFE7F3F97C3E9FCFE7F3F97C3E03"
    /*  MMS should be rejected */
//  "07917952939899F94406D1CDE61400F522507011138121750B05040B8423F000031902010006291F226170706C69636174696F6E2F766E642E7761702E6D6D732D6D657373616765008184AF848D01008C8298317469643937323533323235343538315F307337717365008D918919802B3937323534353931393838362F545950453D504C4D4E00964D4D5300",
//  "07917952939899F94406D1CDE61400F522507011130221680B05040B8423F0000319020286818A808E030115FF8805810303F48083687474703A2F2F6D6D732E686F746D6F62696C652E636F2E696C2F6D6D732F776170656E633F6C6F636174696F6E3D3937323533323235343538315F307337717365267269643D30393600"
};

// send multipart message
const char *mpmessage[] = {
  "Abcdefghijk",    // GSM 7 bit
  // Too long for multi-part
  "123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123", // 153 chars
  // next OK for multi-part single byte ref num, not OK for 2 byte ref number
  "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012", // 152
  // next OK for multi-part 2 byte ref num
  "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901", // 152
//  "01234567890",    
//  "[][][][][]]",
//  "אבגדה",     // 16 bit
//  "😻"  // surrogate pair
};
const char *SCANumber = "+97254123456";
const char *To = "0541111111";
#define SMILEY 0x1f600

void UdhDecode(PDU mypdu) {
  char temp[20];
  mypdu.buildUtf(SMILEY,temp);
 // mpmessage[2] = temp;
  mypdu.setSCAnumber(SCANumber);
#if 1
  int concat[3];
  for (unsigned long x=0; x< sizeof(msgs)/sizeof(const char *);x++) {
      if (mypdu.decodePDU(msgs[x])) {
          std::cout << mypdu.getSCAnumber() << std::endl;
          std::cout << mypdu.getSender() << std::endl;
          std::cout << mypdu.getText() << std::endl;
          memcpy(concat,mypdu.getConcatInfo(),sizeof(concat));
          if (concat[0] != 0) {
              std::cout << "CSMS " << concat[0] <<" Part " << concat[1] << " of " << concat[2] << std::endl;
          }
          else
              std::cout << "Not concatenated\n";
      }
      else
          std::cout << "Could not decode\n";
  }
#endif
#if 0
  if (mypdu.encodePDU(To,mpmessage[0]) == -1)
    std::cout << "Message too long or other error\n";
  else
    std::cout << "Default parms OK\n";
  if (mypdu.encodePDU(To,mpmessage[0],0,0,0) == -1)
    std::cout << "Message too long or other error\n";
  else
    std::cout << "Explicit Default parms OK\n";
  if (mypdu.encodePDU(To,mpmessage[0],10,3,1) == -1)
    std::cout << "Message too long or other error\n";
  else
    std::cout << "Explicit concat parms OK\n";
  if (mypdu.encodePDU(To,mpmessage[0],10,3,0) == -1)
    std::cout << "Message too long or other error\n";
  else
    std::cout << "Explicit concat parms including zeroOK\n";
  if (mypdu.encodePDU(To,mpmessage[0],10,3,4) == -1)
    std::cout << "Message too long or other error\n";
  else
    std::cout << "Explicit concat parms part number > num partsOK\n";
#endif
#if 0
  unsigned numparts = sizeof(mpmessage)/sizeof(const char *);
  unsigned refnumber = 0x1ff;
  for (unsigned p=0;p<numparts;p++) {
    if (mypdu.encodePDU(To,mpmessage[p],refnumber,numparts,p+1) == -1)
      std::cout << "Message " << p << " too long\n";
    else 
      std::cout << mypdu.getSMS() << std::endl;
  }
#endif
}
