/* Automatically generated nanopb header */
/* Generated by nanopb-0.4.9 */

#ifndef PB_MESHTASTIC_MESHTASTIC_MESH_PB_H_INCLUDED
#define PB_MESHTASTIC_MESHTASTIC_MESH_PB_H_INCLUDED
#include <pb.h>
#include "meshtastic/channel.pb.h"
#include "meshtastic/config.pb.h"
#include "meshtastic/module_config.pb.h"
#include "meshtastic/portnums.pb.h"
#include "meshtastic/telemetry.pb.h"
#include "meshtastic/xmodem.pb.h"
#include "meshtastic/device_ui.pb.h"

#if PB_PROTO_HEADER_VERSION != 40
#error Regenerate this file with the current version of nanopb generator.
#endif

/* Enum definitions */
/* Note: these enum names must EXACTLY match the string used in the device
 bin/build-all.sh script.
 Because they will be used to find firmware filenames in the android app for OTA updates.
 To match the old style filenames, _ is converted to -, p is converted to . */
typedef enum _meshtastic_HardwareModel {
    /* TODO: REPLACE */
    meshtastic_HardwareModel_UNSET = 0,
    /* TODO: REPLACE */
    meshtastic_HardwareModel_TLORA_V2 = 1,
    /* TODO: REPLACE */
    meshtastic_HardwareModel_TLORA_V1 = 2,
    /* TODO: REPLACE */
    meshtastic_HardwareModel_TLORA_V2_1_1P6 = 3,
    /* TODO: REPLACE */
    meshtastic_HardwareModel_TBEAM = 4,
    /* The original heltec WiFi_Lora_32_V2, which had battery voltage sensing hooked to GPIO 13
 (see HELTEC_V2 for the new version). */
    meshtastic_HardwareModel_HELTEC_V2_0 = 5,
    /* TODO: REPLACE */
    meshtastic_HardwareModel_TBEAM_V0P7 = 6,
    /* TODO: REPLACE */
    meshtastic_HardwareModel_T_ECHO = 7,
    /* TODO: REPLACE */
    meshtastic_HardwareModel_TLORA_V1_1P3 = 8,
    /* TODO: REPLACE */
    meshtastic_HardwareModel_RAK4631 = 9,
    /* The new version of the heltec WiFi_Lora_32_V2 board that has battery sensing hooked to GPIO 37.
 Sadly they did not update anything on the silkscreen to identify this board */
    meshtastic_HardwareModel_HELTEC_V2_1 = 10,
    /* Ancient heltec WiFi_Lora_32 board */
    meshtastic_HardwareModel_HELTEC_V1 = 11,
    /* New T-BEAM with ESP32-S3 CPU */
    meshtastic_HardwareModel_LILYGO_TBEAM_S3_CORE = 12,
    /* RAK WisBlock ESP32 core: https://docs.rakwireless.com/Product-Categories/WisBlock/RAK11200/Overview/ */
    meshtastic_HardwareModel_RAK11200 = 13,
    /* B&Q Consulting Nano Edition G1: https://uniteng.com/wiki/doku.php?id=meshtastic:nano */
    meshtastic_HardwareModel_NANO_G1 = 14,
    /* TODO: REPLACE */
    meshtastic_HardwareModel_TLORA_V2_1_1P8 = 15,
    /* TODO: REPLACE */
    meshtastic_HardwareModel_TLORA_T3_S3 = 16,
    /* B&Q Consulting Nano G1 Explorer: https://wiki.uniteng.com/en/meshtastic/nano-g1-explorer */
    meshtastic_HardwareModel_NANO_G1_EXPLORER = 17,
    /* B&Q Consulting Nano G2 Ultra: https://wiki.uniteng.com/en/meshtastic/nano-g2-ultra */
    meshtastic_HardwareModel_NANO_G2_ULTRA = 18,
    /* LoRAType device: https://loratype.org/ */
    meshtastic_HardwareModel_LORA_TYPE = 19,
    /* wiphone https://www.wiphone.io/ */
    meshtastic_HardwareModel_WIPHONE = 20,
    /* WIO Tracker WM1110 family from Seeed Studio. Includes wio-1110-tracker and wio-1110-sdk */
    meshtastic_HardwareModel_WIO_WM1110 = 21,
    /* RAK2560 Solar base station based on RAK4630 */
    meshtastic_HardwareModel_RAK2560 = 22,
    /* Heltec HRU-3601: https://heltec.org/project/hru-3601/ */
    meshtastic_HardwareModel_HELTEC_HRU_3601 = 23,
    /* Heltec Wireless Bridge */
    meshtastic_HardwareModel_HELTEC_WIRELESS_BRIDGE = 24,
    /* B&Q Consulting Station Edition G1: https://uniteng.com/wiki/doku.php?id=meshtastic:station */
    meshtastic_HardwareModel_STATION_G1 = 25,
    /* RAK11310 (RP2040 + SX1262) */
    meshtastic_HardwareModel_RAK11310 = 26,
    /* Makerfabs SenseLoRA Receiver (RP2040 + RFM96) */
    meshtastic_HardwareModel_SENSELORA_RP2040 = 27,
    /* Makerfabs SenseLoRA Industrial Monitor (ESP32-S3 + RFM96) */
    meshtastic_HardwareModel_SENSELORA_S3 = 28,
    /* Canary Radio Company - CanaryOne: https://canaryradio.io/products/canaryone */
    meshtastic_HardwareModel_CANARYONE = 29,
    /* Waveshare RP2040 LoRa - https://www.waveshare.com/rp2040-lora.htm */
    meshtastic_HardwareModel_RP2040_LORA = 30,
    /* B&Q Consulting Station G2: https://wiki.uniteng.com/en/meshtastic/station-g2 */
    meshtastic_HardwareModel_STATION_G2 = 31,
    /* ---------------------------------------------------------------------------
 Less common/prototype boards listed here (needs one more byte over the air)
 --------------------------------------------------------------------------- */
    meshtastic_HardwareModel_LORA_RELAY_V1 = 32,
    /* TODO: REPLACE */
    meshtastic_HardwareModel_NRF52840DK = 33,
    /* TODO: REPLACE */
    meshtastic_HardwareModel_PPR = 34,
    /* TODO: REPLACE */
    meshtastic_HardwareModel_GENIEBLOCKS = 35,
    /* TODO: REPLACE */
    meshtastic_HardwareModel_NRF52_UNKNOWN = 36,
    /* TODO: REPLACE */
    meshtastic_HardwareModel_PORTDUINO = 37,
    /* The simulator built into the android app */
    meshtastic_HardwareModel_ANDROID_SIM = 38,
    /* Custom DIY device based on @NanoVHF schematics: https://github.com/NanoVHF/Meshtastic-DIY/tree/main/Schematics */
    meshtastic_HardwareModel_DIY_V1 = 39,
    /* nRF52840 Dongle : https://www.nordicsemi.com/Products/Development-hardware/nrf52840-dongle/ */
    meshtastic_HardwareModel_NRF52840_PCA10059 = 40,
    /* Custom Disaster Radio esp32 v3 device https://github.com/sudomesh/disaster-radio/tree/master/hardware/board_esp32_v3 */
    meshtastic_HardwareModel_DR_DEV = 41,
    /* M5 esp32 based MCU modules with enclosure, TFT and LORA Shields. All Variants (Basic, Core, Fire, Core2, CoreS3, Paper) https://m5stack.com/ */
    meshtastic_HardwareModel_M5STACK = 42,
    /* New Heltec LoRA32 with ESP32-S3 CPU */
    meshtastic_HardwareModel_HELTEC_V3 = 43,
    /* New Heltec Wireless Stick Lite with ESP32-S3 CPU */
    meshtastic_HardwareModel_HELTEC_WSL_V3 = 44,
    /* New BETAFPV ELRS Micro TX Module 2.4G with ESP32 CPU */
    meshtastic_HardwareModel_BETAFPV_2400_TX = 45,
    /* BetaFPV ExpressLRS "Nano" TX Module 900MHz with ESP32 CPU */
    meshtastic_HardwareModel_BETAFPV_900_NANO_TX = 46,
    /* Raspberry Pi Pico (W) with Waveshare SX1262 LoRa Node Module */
    meshtastic_HardwareModel_RPI_PICO = 47,
    /* Heltec Wireless Tracker with ESP32-S3 CPU, built-in GPS, and TFT
 Newer V1.1, version is written on the PCB near the display. */
    meshtastic_HardwareModel_HELTEC_WIRELESS_TRACKER = 48,
    /* Heltec Wireless Paper with ESP32-S3 CPU and E-Ink display */
    meshtastic_HardwareModel_HELTEC_WIRELESS_PAPER = 49,
    /* LilyGo T-Deck with ESP32-S3 CPU, Keyboard and IPS display */
    meshtastic_HardwareModel_T_DECK = 50,
    /* LilyGo T-Watch S3 with ESP32-S3 CPU and IPS display */
    meshtastic_HardwareModel_T_WATCH_S3 = 51,
    /* Bobricius Picomputer with ESP32-S3 CPU, Keyboard and IPS display */
    meshtastic_HardwareModel_PICOMPUTER_S3 = 52,
    /* Heltec HT-CT62 with ESP32-C3 CPU and SX1262 LoRa */
    meshtastic_HardwareModel_HELTEC_HT62 = 53,
    /* EBYTE SPI LoRa module and ESP32-S3 */
    meshtastic_HardwareModel_EBYTE_ESP32_S3 = 54,
    /* Waveshare ESP32-S3-PICO with PICO LoRa HAT and 2.9inch e-Ink */
    meshtastic_HardwareModel_ESP32_S3_PICO = 55,
    /* CircuitMess Chatter 2 LLCC68 Lora Module and ESP32 Wroom
 Lora module can be swapped out for a Heltec RA-62 which is "almost" pin compatible
 with one cut and one jumper Meshtastic works */
    meshtastic_HardwareModel_CHATTER_2 = 56,
    /* Heltec Wireless Paper, With ESP32-S3 CPU and E-Ink display
 Older "V1.0" Variant, has no "version sticker"
 E-Ink model is DEPG0213BNS800
 Tab on the screen protector is RED
 Flex connector marking is FPC-7528B */
    meshtastic_HardwareModel_HELTEC_WIRELESS_PAPER_V1_0 = 57,
    /* Heltec Wireless Tracker with ESP32-S3 CPU, built-in GPS, and TFT
 Older "V1.0" Variant */
    meshtastic_HardwareModel_HELTEC_WIRELESS_TRACKER_V1_0 = 58,
    /* unPhone with ESP32-S3, TFT touchscreen,  LSM6DS3TR-C accelerometer and gyroscope */
    meshtastic_HardwareModel_UNPHONE = 59,
    /* Teledatics TD-LORAC NRF52840 based M.2 LoRA module
 Compatible with the TD-WRLS development board */
    meshtastic_HardwareModel_TD_LORAC = 60,
    /* CDEBYTE EoRa-S3 board using their own MM modules, clone of LILYGO T3S3 */
    meshtastic_HardwareModel_CDEBYTE_EORA_S3 = 61,
    /* TWC_MESH_V4 
 Adafruit NRF52840 feather express with SX1262, SSD1306 OLED and NEO6M GPS */
    meshtastic_HardwareModel_TWC_MESH_V4 = 62,
    /* NRF52_PROMICRO_DIY
 Promicro NRF52840 with SX1262/LLCC68, SSD1306 OLED and NEO6M GPS */
    meshtastic_HardwareModel_NRF52_PROMICRO_DIY = 63,
    /* RadioMaster 900 Bandit Nano, https://www.radiomasterrc.com/products/bandit-nano-expresslrs-rf-module
 ESP32-D0WDQ6 With SX1276/SKY66122, SSD1306 OLED and No GPS */
    meshtastic_HardwareModel_RADIOMASTER_900_BANDIT_NANO = 64,
    /* Heltec Capsule Sensor V3 with ESP32-S3 CPU, Portable LoRa device that can replace GNSS modules or sensors */
    meshtastic_HardwareModel_HELTEC_CAPSULE_SENSOR_V3 = 65,
    /* Heltec Vision Master T190 with ESP32-S3 CPU, and a 1.90 inch TFT display */
    meshtastic_HardwareModel_HELTEC_VISION_MASTER_T190 = 66,
    /* Heltec Vision Master E213 with ESP32-S3 CPU, and a 2.13 inch E-Ink display */
    meshtastic_HardwareModel_HELTEC_VISION_MASTER_E213 = 67,
    /* Heltec Vision Master E290 with ESP32-S3 CPU, and a 2.9 inch E-Ink display */
    meshtastic_HardwareModel_HELTEC_VISION_MASTER_E290 = 68,
    /* Heltec Mesh Node T114 board with nRF52840 CPU, and a 1.14 inch TFT display, Ultimate low-power design,
 specifically adapted for the Meshtatic project */
    meshtastic_HardwareModel_HELTEC_MESH_NODE_T114 = 69,
    /* Sensecap Indicator from Seeed Studio. ESP32-S3 device with TFT and RP2040 coprocessor */
    meshtastic_HardwareModel_SENSECAP_INDICATOR = 70,
    /* Seeed studio T1000-E tracker card. NRF52840 w/ LR1110 radio, GPS, button, buzzer, and sensors. */
    meshtastic_HardwareModel_TRACKER_T1000_E = 71,
    /* RAK3172 STM32WLE5 Module (https://store.rakwireless.com/products/wisduo-lpwan-module-rak3172) */
    meshtastic_HardwareModel_RAK3172 = 72,
    /* Seeed Studio Wio-E5 (either mini or Dev kit) using STM32WL chip. */
    meshtastic_HardwareModel_WIO_E5 = 73,
    /* RadioMaster 900 Bandit, https://www.radiomasterrc.com/products/bandit-expresslrs-rf-module
 SSD1306 OLED and No GPS */
    meshtastic_HardwareModel_RADIOMASTER_900_BANDIT = 74,
    /* Minewsemi ME25LS01 (ME25LE01_V1.0). NRF52840 w/ LR1110 radio, buttons and leds and pins. */
    meshtastic_HardwareModel_ME25LS01_4Y10TD = 75,
    /* RP2040_FEATHER_RFM95
 Adafruit Feather RP2040 with RFM95 LoRa Radio RFM95 with SX1272, SSD1306 OLED
 https://www.adafruit.com/product/5714
 https://www.adafruit.com/product/326
 https://www.adafruit.com/product/938
  ^^^ short A0 to switch to I2C address 0x3C */
    meshtastic_HardwareModel_RP2040_FEATHER_RFM95 = 76,
    /* M5 esp32 based MCU modules with enclosure, TFT and LORA Shields. All Variants (Basic, Core, Fire, Core2, CoreS3, Paper) https://m5stack.com/ */
    meshtastic_HardwareModel_M5STACK_COREBASIC = 77,
    meshtastic_HardwareModel_M5STACK_CORE2 = 78,
    /* Pico2 with Waveshare Hat, same as Pico */
    meshtastic_HardwareModel_RPI_PICO2 = 79,
    /* M5 esp32 based MCU modules with enclosure, TFT and LORA Shields. All Variants (Basic, Core, Fire, Core2, CoreS3, Paper) https://m5stack.com/ */
    meshtastic_HardwareModel_M5STACK_CORES3 = 80,
    /* Seeed XIAO S3 DK */
    meshtastic_HardwareModel_SEEED_XIAO_S3 = 81,
    /* Nordic nRF52840+Semtech SX1262 LoRa BLE Combo Module. nRF52840+SX1262 MS24SF1 */
    meshtastic_HardwareModel_MS24SF1 = 82,
    /* Lilygo TLora-C6 with the new ESP32-C6 MCU */
    meshtastic_HardwareModel_TLORA_C6 = 83,
    /* ------------------------------------------------------------------------------------------------------------------------------------------
 Reserved ID For developing private Ports. These will show up in live traffic sparsely, so we can use a high number. Keep it within 8 bits.
 ------------------------------------------------------------------------------------------------------------------------------------------ */
    meshtastic_HardwareModel_PRIVATE_HW = 255
} meshtastic_HardwareModel;

/* Shared constants between device and phone */
typedef enum _meshtastic_Constants {
    /* First enum must be zero, and we are just using this enum to
 pass int constants between two very different environments */
    meshtastic_Constants_ZERO = 0,
    /* From mesh.options
 note: this payload length is ONLY the bytes that are sent inside of the Data protobuf (excluding protobuf overhead). The 16 byte header is
 outside of this envelope */
    meshtastic_Constants_DATA_PAYLOAD_LEN = 237
} meshtastic_Constants;

/* Error codes for critical errors
 The device might report these fault codes on the screen.
 If you encounter a fault code, please post on the meshtastic.discourse.group
 and we'll try to help. */
typedef enum _meshtastic_CriticalErrorCode {
    /* TODO: REPLACE */
    meshtastic_CriticalErrorCode_NONE = 0,
    /* A software bug was detected while trying to send lora */
    meshtastic_CriticalErrorCode_TX_WATCHDOG = 1,
    /* A software bug was detected on entry to sleep */
    meshtastic_CriticalErrorCode_SLEEP_ENTER_WAIT = 2,
    /* No Lora radio hardware could be found */
    meshtastic_CriticalErrorCode_NO_RADIO = 3,
    /* Not normally used */
    meshtastic_CriticalErrorCode_UNSPECIFIED = 4,
    /* We failed while configuring a UBlox GPS */
    meshtastic_CriticalErrorCode_UBLOX_UNIT_FAILED = 5,
    /* This board was expected to have a power management chip and it is missing or broken */
    meshtastic_CriticalErrorCode_NO_AXP192 = 6,
    /* The channel tried to set a radio setting which is not supported by this chipset,
 radio comms settings are now undefined. */
    meshtastic_CriticalErrorCode_INVALID_RADIO_SETTING = 7,
    /* Radio transmit hardware failure. We sent data to the radio chip, but it didn't
 reply with an interrupt. */
    meshtastic_CriticalErrorCode_TRANSMIT_FAILED = 8,
    /* We detected that the main CPU voltage dropped below the minimum acceptable value */
    meshtastic_CriticalErrorCode_BROWNOUT = 9,
    /* Selftest of SX1262 radio chip failed */
    meshtastic_CriticalErrorCode_SX1262_FAILURE = 10,
    /* A (likely software but possibly hardware) failure was detected while trying to send packets.
 If this occurs on your board, please post in the forum so that we can ask you to collect some information to allow fixing this bug */
    meshtastic_CriticalErrorCode_RADIO_SPI_BUG = 11,
    /* Corruption was detected on the flash filesystem but we were able to repair things.
 If you see this failure in the field please post in the forum because we are interested in seeing if this is occurring in the field. */
    meshtastic_CriticalErrorCode_FLASH_CORRUPTION_RECOVERABLE = 12,
    /* Corruption was detected on the flash filesystem but we were unable to repair things.
 NOTE: Your node will probably need to be reconfigured the next time it reboots (it will lose the region code etc...)
 If you see this failure in the field please post in the forum because we are interested in seeing if this is occurring in the field. */
    meshtastic_CriticalErrorCode_FLASH_CORRUPTION_UNRECOVERABLE = 13
} meshtastic_CriticalErrorCode;

/* Enum for modules excluded from a device's configuration.
 Each value represents a ModuleConfigType that can be toggled as excluded
 by setting its corresponding bit in the `excluded_modules` bitmask field. */
typedef enum _meshtastic_ExcludedModules {
    /* Default value of 0 indicates no modules are excluded. */
    meshtastic_ExcludedModules_EXCLUDED_NONE = 0,
    /* MQTT module */
    meshtastic_ExcludedModules_MQTT_CONFIG = 1,
    /* Serial module */
    meshtastic_ExcludedModules_SERIAL_CONFIG = 2,
    /* External Notification module */
    meshtastic_ExcludedModules_EXTNOTIF_CONFIG = 4,
    /* Store and Forward module */
    meshtastic_ExcludedModules_STOREFORWARD_CONFIG = 8,
    /* Range Test module */
    meshtastic_ExcludedModules_RANGETEST_CONFIG = 16,
    /* Telemetry module */
    meshtastic_ExcludedModules_TELEMETRY_CONFIG = 32,
    /* Canned Message module */
    meshtastic_ExcludedModules_CANNEDMSG_CONFIG = 64,
    /* Audio module */
    meshtastic_ExcludedModules_AUDIO_CONFIG = 128,
    /* Remote Hardware module */
    meshtastic_ExcludedModules_REMOTEHARDWARE_CONFIG = 256,
    /* Neighbor Info module */
    meshtastic_ExcludedModules_NEIGHBORINFO_CONFIG = 512,
    /* Ambient Lighting module */
    meshtastic_ExcludedModules_AMBIENTLIGHTING_CONFIG = 1024,
    /* Detection Sensor module */
    meshtastic_ExcludedModules_DETECTIONSENSOR_CONFIG = 2048,
    /* Paxcounter module */
    meshtastic_ExcludedModules_PAXCOUNTER_CONFIG = 4096
} meshtastic_ExcludedModules;

/* How the location was acquired: manual, onboard GPS, external (EUD) GPS */
typedef enum _meshtastic_Position_LocSource {
    /* TODO: REPLACE */
    meshtastic_Position_LocSource_LOC_UNSET = 0,
    /* TODO: REPLACE */
    meshtastic_Position_LocSource_LOC_MANUAL = 1,
    /* TODO: REPLACE */
    meshtastic_Position_LocSource_LOC_INTERNAL = 2,
    /* TODO: REPLACE */
    meshtastic_Position_LocSource_LOC_EXTERNAL = 3
} meshtastic_Position_LocSource;

/* How the altitude was acquired: manual, GPS int/ext, etc
 Default: same as location_source if present */
typedef enum _meshtastic_Position_AltSource {
    /* TODO: REPLACE */
    meshtastic_Position_AltSource_ALT_UNSET = 0,
    /* TODO: REPLACE */
    meshtastic_Position_AltSource_ALT_MANUAL = 1,
    /* TODO: REPLACE */
    meshtastic_Position_AltSource_ALT_INTERNAL = 2,
    /* TODO: REPLACE */
    meshtastic_Position_AltSource_ALT_EXTERNAL = 3,
    /* TODO: REPLACE */
    meshtastic_Position_AltSource_ALT_BAROMETRIC = 4
} meshtastic_Position_AltSource;

/* A failure in delivering a message (usually used for routing control messages, but might be provided in addition to ack.fail_id to provide
 details on the type of failure). */
typedef enum _meshtastic_Routing_Error {
    /* This message is not a failure */
    meshtastic_Routing_Error_NONE = 0,
    /* Our node doesn't have a route to the requested destination anymore. */
    meshtastic_Routing_Error_NO_ROUTE = 1,
    /* We received a nak while trying to forward on your behalf */
    meshtastic_Routing_Error_GOT_NAK = 2,
    /* TODO: REPLACE */
    meshtastic_Routing_Error_TIMEOUT = 3,
    /* No suitable interface could be found for delivering this packet */
    meshtastic_Routing_Error_NO_INTERFACE = 4,
    /* We reached the max retransmission count (typically for naive flood routing) */
    meshtastic_Routing_Error_MAX_RETRANSMIT = 5,
    /* No suitable channel was found for sending this packet (i.e. was requested channel index disabled?) */
    meshtastic_Routing_Error_NO_CHANNEL = 6,
    /* The packet was too big for sending (exceeds interface MTU after encoding) */
    meshtastic_Routing_Error_TOO_LARGE = 7,
    /* The request had want_response set, the request reached the destination node, but no service on that node wants to send a response
 (possibly due to bad channel permissions) */
    meshtastic_Routing_Error_NO_RESPONSE = 8,
    /* Cannot send currently because duty cycle regulations will be violated. */
    meshtastic_Routing_Error_DUTY_CYCLE_LIMIT = 9,
    /* The application layer service on the remote node received your request, but considered your request somehow invalid */
    meshtastic_Routing_Error_BAD_REQUEST = 32,
    /* The application layer service on the remote node received your request, but considered your request not authorized
 (i.e you did not send the request on the required bound channel) */
    meshtastic_Routing_Error_NOT_AUTHORIZED = 33,
    /* The client specified a PKI transport, but the node was unable to send the packet using PKI (and did not send the message at all) */
    meshtastic_Routing_Error_PKI_FAILED = 34,
    /* The receiving node does not have a Public Key to decode with */
    meshtastic_Routing_Error_PKI_UNKNOWN_PUBKEY = 35,
    /* Admin packet otherwise checks out, but uses a bogus or expired session key */
    meshtastic_Routing_Error_ADMIN_BAD_SESSION_KEY = 36,
    /* Admin packet sent using PKC, but not from a public key on the admin key list */
    meshtastic_Routing_Error_ADMIN_PUBLIC_KEY_UNAUTHORIZED = 37
} meshtastic_Routing_Error;

/* The priority of this message for sending.
 Higher priorities are sent first (when managing the transmit queue).
 This field is never sent over the air, it is only used internally inside of a local device node.
 API clients (either on the local node or connected directly to the node)
 can set this parameter if necessary.
 (values must be <= 127 to keep protobuf field to one byte in size.
 Detailed background on this field:
 I noticed a funny side effect of lora being so slow: Usually when making
 a protocol there isn’t much need to use message priority to change the order
 of transmission (because interfaces are fairly fast).
 But for lora where packets can take a few seconds each, it is very important
 to make sure that critical packets are sent ASAP.
 In the case of meshtastic that means we want to send protocol acks as soon as possible
 (to prevent unneeded retransmissions), we want routing messages to be sent next,
 then messages marked as reliable and finally 'background' packets like periodic position updates.
 So I bit the bullet and implemented a new (internal - not sent over the air)
 field in MeshPacket called 'priority'.
 And the transmission queue in the router object is now a priority queue. */
typedef enum _meshtastic_MeshPacket_Priority {
    /* Treated as Priority.DEFAULT */
    meshtastic_MeshPacket_Priority_UNSET = 0,
    /* TODO: REPLACE */
    meshtastic_MeshPacket_Priority_MIN = 1,
    /* Background position updates are sent with very low priority -
 if the link is super congested they might not go out at all */
    meshtastic_MeshPacket_Priority_BACKGROUND = 10,
    /* This priority is used for most messages that don't have a priority set */
    meshtastic_MeshPacket_Priority_DEFAULT = 64,
    /* If priority is unset but the message is marked as want_ack,
 assume it is important and use a slightly higher priority */
    meshtastic_MeshPacket_Priority_RELIABLE = 70,
    /* If priority is unset but the packet is a response to a request, we want it to get there relatively quickly.
 Furthermore, responses stop relaying packets directed to a node early. */
    meshtastic_MeshPacket_Priority_RESPONSE = 80,
    /* Higher priority for specific message types (portnums) to distinguish between other reliable packets. */
    meshtastic_MeshPacket_Priority_HIGH = 100,
    /* Ack/naks are sent with very high priority to ensure that retransmission
 stops as soon as possible */
    meshtastic_MeshPacket_Priority_ACK = 120,
    /* TODO: REPLACE */
    meshtastic_MeshPacket_Priority_MAX = 127
} meshtastic_MeshPacket_Priority;

/* Identify if this is a delayed packet */
typedef enum _meshtastic_MeshPacket_Delayed {
    /* If unset, the message is being sent in real time. */
    meshtastic_MeshPacket_Delayed_NO_DELAY = 0,
    /* The message is delayed and was originally a broadcast */
    meshtastic_MeshPacket_Delayed_DELAYED_BROADCAST = 1,
    /* The message is delayed and was originally a direct message */
    meshtastic_MeshPacket_Delayed_DELAYED_DIRECT = 2
} meshtastic_MeshPacket_Delayed;

/* Log levels, chosen to match python logging conventions. */
typedef enum _meshtastic_LogRecord_Level {
    /* Log levels, chosen to match python logging conventions. */
    meshtastic_LogRecord_Level_UNSET = 0,
    /* Log levels, chosen to match python logging conventions. */
    meshtastic_LogRecord_Level_CRITICAL = 50,
    /* Log levels, chosen to match python logging conventions. */
    meshtastic_LogRecord_Level_ERROR = 40,
    /* Log levels, chosen to match python logging conventions. */
    meshtastic_LogRecord_Level_WARNING = 30,
    /* Log levels, chosen to match python logging conventions. */
    meshtastic_LogRecord_Level_INFO = 20,
    /* Log levels, chosen to match python logging conventions. */
    meshtastic_LogRecord_Level_DEBUG = 10,
    /* Log levels, chosen to match python logging conventions. */
    meshtastic_LogRecord_Level_TRACE = 5
} meshtastic_LogRecord_Level;

/* Struct definitions */
/* A GPS Position */
typedef struct _meshtastic_Position {
    /* The new preferred location encoding, multiply by 1e-7 to get degrees
 in floating point */
    bool has_latitude_i;
    int32_t latitude_i;
    /* TODO: REPLACE */
    bool has_longitude_i;
    int32_t longitude_i;
    /* In meters above MSL (but see issue #359) */
    bool has_altitude;
    int32_t altitude;
    /* This is usually not sent over the mesh (to save space), but it is sent
 from the phone so that the local device can set its time if it is sent over
 the mesh (because there are devices on the mesh without GPS or RTC).
 seconds since 1970 */
    uint32_t time;
    /* TODO: REPLACE */
    meshtastic_Position_LocSource location_source;
    /* TODO: REPLACE */
    meshtastic_Position_AltSource altitude_source;
    /* Positional timestamp (actual timestamp of GPS solution) in integer epoch seconds */
    uint32_t timestamp;
    /* Pos. timestamp milliseconds adjustment (rarely available or required) */
    int32_t timestamp_millis_adjust;
    /* HAE altitude in meters - can be used instead of MSL altitude */
    bool has_altitude_hae;
    int32_t altitude_hae;
    /* Geoidal separation in meters */
    bool has_altitude_geoidal_separation;
    int32_t altitude_geoidal_separation;
    /* Horizontal, Vertical and Position Dilution of Precision, in 1/100 units
 - PDOP is sufficient for most cases
 - for higher precision scenarios, HDOP and VDOP can be used instead,
   in which case PDOP becomes redundant (PDOP=sqrt(HDOP^2 + VDOP^2))
 TODO: REMOVE/INTEGRATE */
    uint32_t PDOP;
    /* TODO: REPLACE */
    uint32_t HDOP;
    /* TODO: REPLACE */
    uint32_t VDOP;
    /* GPS accuracy (a hardware specific constant) in mm
   multiplied with DOP to calculate positional accuracy
 Default: "'bout three meters-ish" :) */
    uint32_t gps_accuracy;
    /* Ground speed in m/s and True North TRACK in 1/100 degrees
 Clarification of terms:
 - "track" is the direction of motion (measured in horizontal plane)
 - "heading" is where the fuselage points (measured in horizontal plane)
 - "yaw" indicates a relative rotation about the vertical axis
 TODO: REMOVE/INTEGRATE */
    bool has_ground_speed;
    uint32_t ground_speed;
    /* TODO: REPLACE */
    bool has_ground_track;
    uint32_t ground_track;
    /* GPS fix quality (from NMEA GxGGA statement or similar) */
    uint32_t fix_quality;
    /* GPS fix type 2D/3D (from NMEA GxGSA statement) */
    uint32_t fix_type;
    /* GPS "Satellites in View" number */
    uint32_t sats_in_view;
    /* Sensor ID - in case multiple positioning sensors are being used */
    uint32_t sensor_id;
    /* Estimated/expected time (in seconds) until next update:
 - if we update at fixed intervals of X seconds, use X
 - if we update at dynamic intervals (based on relative movement etc),
   but "AT LEAST every Y seconds", use Y */
    uint32_t next_update;
    /* A sequence number, incremented with each Position message to help
   detect lost updates if needed */
    uint32_t seq_number;
    /* Indicates the bits of precision set by the sending node */
    uint32_t precision_bits;
} meshtastic_Position;

typedef PB_BYTES_ARRAY_T(32) meshtastic_User_public_key_t;
/* Broadcast when a newly powered mesh node wants to find a node num it can use
 Sent from the phone over bluetooth to set the user id for the owner of this node.
 Also sent from nodes to each other when a new node signs on (so all clients can have this info)
 The algorithm is as follows:
 when a node starts up, it broadcasts their user and the normal flow is for all
 other nodes to reply with their User as well (so the new node can build its nodedb)
 If a node ever receives a User (not just the first broadcast) message where
 the sender node number equals our node number, that indicates a collision has
 occurred and the following steps should happen:
 If the receiving node (that was already in the mesh)'s macaddr is LOWER than the
 new User who just tried to sign in: it gets to keep its nodenum.
 We send a broadcast message of OUR User (we use a broadcast so that the other node can
 receive our message, considering we have the same id - it also serves to let
 observers correct their nodedb) - this case is rare so it should be okay.
 If any node receives a User where the macaddr is GTE than their local macaddr,
 they have been vetoed and should pick a new random nodenum (filtering against
 whatever it knows about the nodedb) and rebroadcast their User.
 A few nodenums are reserved and will never be requested:
 0xff - broadcast
 0 through 3 - for future use */
typedef struct _meshtastic_User {
    /* A globally unique ID string for this user.
 In the case of Signal that would mean +16504442323, for the default macaddr derived id it would be !<8 hexidecimal bytes>.
 Note: app developers are encouraged to also use the following standard
 node IDs "^all" (for broadcast), "^local" (for the locally connected node) */
    char id[16];
    /* A full name for this user, i.e. "Kevin Hester" */
    char long_name[40];
    /* A VERY short name, ideally two characters.
 Suitable for a tiny OLED screen */
    char short_name[5];
    /* Deprecated in Meshtastic 2.1.x
 This is the addr of the radio.
 Not populated by the phone, but added by the esp32 when broadcasting */
    pb_byte_t macaddr[6];
    /* TBEAM, HELTEC, etc...
 Starting in 1.2.11 moved to hw_model enum in the NodeInfo object.
 Apps will still need the string here for older builds
 (so OTA update can find the right image), but if the enum is available it will be used instead. */
    meshtastic_HardwareModel hw_model;
    /* In some regions Ham radio operators have different bandwidth limitations than others.
 If this user is a licensed operator, set this flag.
 Also, "long_name" should be their licence number. */
    bool is_licensed;
    /* Indicates that the user's role in the mesh */
    meshtastic_Config_DeviceConfig_Role role;
    /* The public key of the user's device.
 This is sent out to other nodes on the mesh to allow them to compute a shared secret key. */
    meshtastic_User_public_key_t public_key;
} meshtastic_User;

/* A message used in a traceroute */
typedef struct _meshtastic_RouteDiscovery {
    /* The list of nodenums this packet has visited so far to the destination. */
    pb_size_t route_count;
    uint32_t route[8];
    /* The list of SNRs (in dB, scaled by 4) in the route towards the destination. */
    pb_size_t snr_towards_count;
    int8_t snr_towards[8];
    /* The list of nodenums the packet has visited on the way back from the destination. */
    pb_size_t route_back_count;
    uint32_t route_back[8];
    /* The list of SNRs (in dB, scaled by 4) in the route back from the destination. */
    pb_size_t snr_back_count;
    int8_t snr_back[8];
} meshtastic_RouteDiscovery;

/* A Routing control Data packet handled by the routing module */
typedef struct _meshtastic_Routing {
    pb_size_t which_variant;
    union {
        /* A route request going from the requester */
        meshtastic_RouteDiscovery route_request;
        /* A route reply */
        meshtastic_RouteDiscovery route_reply;
        /* A failure in delivering a message (usually used for routing control messages, but might be provided
     in addition to ack.fail_id to provide details on the type of failure). */
        meshtastic_Routing_Error error_reason;
    };
} meshtastic_Routing;

typedef PB_BYTES_ARRAY_T(237) meshtastic_Data_payload_t;
/* (Formerly called SubPacket)
 The payload portion fo a packet, this is the actual bytes that are sent
 inside a radio packet (because from/to are broken out by the comms library) */
typedef struct _meshtastic_Data {
    /* Formerly named typ and of type Type */
    meshtastic_PortNum portnum;
    /* TODO: REPLACE */
    meshtastic_Data_payload_t payload;
    /* Not normally used, but for testing a sender can request that recipient
 responds in kind (i.e. if it received a position, it should unicast back it's position).
 Note: that if you set this on a broadcast you will receive many replies. */
    bool want_response;
    /* The address of the destination node.
 This field is is filled in by the mesh radio device software, application
 layer software should never need it.
 RouteDiscovery messages _must_ populate this.
 Other message types might need to if they are doing multihop routing. */
    uint32_t dest;
    /* The address of the original sender for this message.
 This field should _only_ be populated for reliable multihop packets (to keep
 packets small). */
    uint32_t source;
    /* Only used in routing or response messages.
 Indicates the original message ID that this message is reporting failure on. (formerly called original_id) */
    uint32_t request_id;
    /* If set, this message is intened to be a reply to a previously sent message with the defined id. */
    uint32_t reply_id;
    /* Defaults to false. If true, then what is in the payload should be treated as an emoji like giving
 a message a heart or poop emoji. */
    uint32_t emoji;
    /* Bitfield for extra flags. First use is to indicate that user approves the packet being uploaded to MQTT. */
    bool has_bitfield;
    uint8_t bitfield;
} meshtastic_Data;

/* Waypoint message, used to share arbitrary locations across the mesh */
typedef struct _meshtastic_Waypoint {
    /* Id of the waypoint */
    uint32_t id;
    /* latitude_i */
    bool has_latitude_i;
    int32_t latitude_i;
    /* longitude_i */
    bool has_longitude_i;
    int32_t longitude_i;
    /* Time the waypoint is to expire (epoch) */
    uint32_t expire;
    /* If greater than zero, treat the value as a nodenum only allowing them to update the waypoint.
 If zero, the waypoint is open to be edited by any member of the mesh. */
    uint32_t locked_to;
    /* Name of the waypoint - max 30 chars */
    char name[30];
    /* Description of the waypoint - max 100 chars */
    char description[100];
    /* Designator icon for the waypoint in the form of a unicode emoji */
    uint32_t icon;
} meshtastic_Waypoint;

typedef PB_BYTES_ARRAY_T(435) meshtastic_MqttClientProxyMessage_data_t;
/* This message will be proxied over the PhoneAPI for the client to deliver to the MQTT server */
typedef struct _meshtastic_MqttClientProxyMessage {
    /* The MQTT topic this message will be sent /received on */
    char topic[60];
    pb_size_t which_payload_variant;
    union {
        /* Bytes */
        meshtastic_MqttClientProxyMessage_data_t data;
        /* Text */
        char text[435];
    } payload_variant;
    /* Whether the message should be retained (or not) */
    bool retained;
} meshtastic_MqttClientProxyMessage;

typedef PB_BYTES_ARRAY_T(256) meshtastic_MeshPacket_encrypted_t;
typedef PB_BYTES_ARRAY_T(32) meshtastic_MeshPacket_public_key_t;
/* A packet envelope sent/received over the mesh
 only payload_variant is sent in the payload portion of the LORA packet.
 The other fields are either not sent at all, or sent in the special 16 byte LORA header. */
typedef struct _meshtastic_MeshPacket {
    /* The sending node number.
 Note: Our crypto implementation uses this field as well.
 See [crypto](/docs/overview/encryption) for details. */
    uint32_t from;
    /* The (immediate) destination for this packet */
    uint32_t to;
    /* (Usually) If set, this indicates the index in the secondary_channels table that this packet was sent/received on.
 If unset, packet was on the primary channel.
 A particular node might know only a subset of channels in use on the mesh.
 Therefore channel_index is inherently a local concept and meaningless to send between nodes.
 Very briefly, while sending and receiving deep inside the device Router code, this field instead
 contains the 'channel hash' instead of the index.
 This 'trick' is only used while the payload_variant is an 'encrypted'. */
    uint8_t channel;
    pb_size_t which_payload_variant;
    union {
        /* TODO: REPLACE */
        meshtastic_Data decoded;
        /* TODO: REPLACE */
        meshtastic_MeshPacket_encrypted_t encrypted;
    };
    /* A unique ID for this packet.
 Always 0 for no-ack packets or non broadcast packets (and therefore take zero bytes of space).
 Otherwise a unique ID for this packet, useful for flooding algorithms.
 ID only needs to be unique on a _per sender_ basis, and it only
 needs to be unique for a few minutes (long enough to last for the length of
 any ACK or the completion of a mesh broadcast flood).
 Note: Our crypto implementation uses this id as well.
 See [crypto](/docs/overview/encryption) for details. */
    uint32_t id;
    /* The time this message was received by the esp32 (secs since 1970).
 Note: this field is _never_ sent on the radio link itself (to save space) Times
 are typically not sent over the mesh, but they will be added to any Packet
 (chain of SubPacket) sent to the phone (so the phone can know exact time of reception) */
    uint32_t rx_time;
    /* *Never* sent over the radio links.
 Set during reception to indicate the SNR of this packet.
 Used to collect statistics on current link quality. */
    float rx_snr;
    /* If unset treated as zero (no forwarding, send to direct neighbor nodes only)
 if 1, allow hopping through one node, etc...
 For our usecase real world topologies probably have a max of about 3.
 This field is normally placed into a few of bits in the header. */
    uint8_t hop_limit;
    /* This packet is being sent as a reliable message, we would prefer it to arrive at the destination.
 We would like to receive a ack packet in response.
 Broadcasts messages treat this flag specially: Since acks for broadcasts would
 rapidly flood the channel, the normal ack behavior is suppressed.
 Instead, the original sender listens to see if at least one node is rebroadcasting this packet (because naive flooding algorithm).
 If it hears that the odds (given typical LoRa topologies) the odds are very high that every node should eventually receive the message.
 So FloodingRouter.cpp generates an implicit ack which is delivered to the original sender.
 If after some time we don't hear anyone rebroadcast our packet, we will timeout and retransmit, using the regular resend logic.
 Note: This flag is normally sent in a flag bit in the header when sent over the wire */
    bool want_ack;
    /* The priority of this message for sending.
 See MeshPacket.Priority description for more details. */
    meshtastic_MeshPacket_Priority priority;
    /* rssi of received packet. Only sent to phone for dispay purposes. */
    int32_t rx_rssi;
    /* Describe if this message is delayed */
    meshtastic_MeshPacket_Delayed delayed;
    /* Describes whether this packet passed via MQTT somewhere along the path it currently took. */
    bool via_mqtt;
    /* Hop limit with which the original packet started. Sent via LoRa using three bits in the unencrypted header.
 When receiving a packet, the difference between hop_start and hop_limit gives how many hops it traveled. */
    uint8_t hop_start;
    /* Records the public key the packet was encrypted with, if applicable. */
    meshtastic_MeshPacket_public_key_t public_key;
    /* Indicates whether the packet was en/decrypted using PKI */
    bool pki_encrypted;
} meshtastic_MeshPacket;

/* The bluetooth to device link:
 Old BTLE protocol docs from TODO, merge in above and make real docs...
 use protocol buffers, and NanoPB
 messages from device to phone:
 POSITION_UPDATE (..., time)
 TEXT_RECEIVED(from, text, time)
 OPAQUE_RECEIVED(from, payload, time) (for signal messages or other applications)
 messages from phone to device:
 SET_MYID(id, human readable long, human readable short) (send down the unique ID
 string used for this node, a human readable string shown for that id, and a very
 short human readable string suitable for oled screen) SEND_OPAQUE(dest, payload)
 (for signal messages or other applications) SEND_TEXT(dest, text) Get all
 nodes() (returns list of nodes, with full info, last time seen, loc, battery
 level etc) SET_CONFIG (switches device to a new set of radio params and
 preshared key, drops all existing nodes, force our node to rejoin this new group)
 Full information about a node on the mesh */
typedef struct _meshtastic_NodeInfo {
    /* The node number */
    uint32_t num;
    /* The user info for this node */
    bool has_user;
    meshtastic_User user;
    /* This position data. Note: before 1.2.14 we would also store the last time we've heard from this node in position.time, that is no longer true.
 Position.time now indicates the last time we received a POSITION from that node. */
    bool has_position;
    meshtastic_Position position;
    /* Returns the Signal-to-noise ratio (SNR) of the last received message,
 as measured by the receiver. Return SNR of the last received message in dB */
    float snr;
    /* Set to indicate the last time we received a packet from this node */
    uint32_t last_heard;
    /* The latest device metrics for the node. */
    bool has_device_metrics;
    meshtastic_DeviceMetrics device_metrics;
    /* local channel index we heard that node on. Only populated if its not the default channel. */
    uint8_t channel;
    /* True if we witnessed the node over MQTT instead of LoRA transport */
    bool via_mqtt;
    /* Number of hops away from us this node is (0 if direct neighbor) */
    bool has_hops_away;
    uint8_t hops_away;
    /* True if node is in our favorites list
 Persists between NodeDB internal clean ups */
    bool is_favorite;
    /* True if node is in our ignored list
 Persists between NodeDB internal clean ups */
    bool is_ignored;
} meshtastic_NodeInfo;

typedef PB_BYTES_ARRAY_T(16) meshtastic_MyNodeInfo_device_id_t;
/* Unique local debugging info for this node
 Note: we don't include position or the user info, because that will come in the
 Sent to the phone in response to WantNodes. */
typedef struct _meshtastic_MyNodeInfo {
    /* Tells the phone what our node number is, default starting value is
 lowbyte of macaddr, but it will be fixed if that is already in use */
    uint32_t my_node_num;
    /* The total number of reboots this node has ever encountered
 (well - since the last time we discarded preferences) */
    uint32_t reboot_count;
    /* The minimum app version that can talk to this device.
 Phone/PC apps should compare this to their build number and if too low tell the user they must update their app */
    uint32_t min_app_version;
    /* Unique hardware identifier for this device */
    meshtastic_MyNodeInfo_device_id_t device_id;
    /* The PlatformIO environment used to build this firmware */
    char pio_env[40];
} meshtastic_MyNodeInfo;

/* Debug output from the device.
 To minimize the size of records inside the device code, if a time/source/level is not set
 on the message it is assumed to be a continuation of the previously sent message.
 This allows the device code to use fixed maxlen 64 byte strings for messages,
 and then extend as needed by emitting multiple records. */
typedef struct _meshtastic_LogRecord {
    /* Log levels, chosen to match python logging conventions. */
    char message[384];
    /* Seconds since 1970 - or 0 for unknown/unset */
    uint32_t time;
    /* Usually based on thread name - if known */
    char source[32];
    /* Not yet set */
    meshtastic_LogRecord_Level level;
} meshtastic_LogRecord;

typedef struct _meshtastic_QueueStatus {
    /* Last attempt to queue status, ErrorCode */
    int8_t res;
    /* Free entries in the outgoing queue */
    uint8_t free;
    /* Maximum entries in the outgoing queue */
    uint8_t maxlen;
    /* What was mesh packet id that generated this response? */
    uint32_t mesh_packet_id;
} meshtastic_QueueStatus;

/* A notification message from the device to the client
 To be used for important messages that should to be displayed to the user
 in the form of push notifications or validation messages when saving
 invalid configuration. */
typedef struct _meshtastic_ClientNotification {
    /* The id of the packet we're notifying in response to */
    bool has_reply_id;
    uint32_t reply_id;
    /* Seconds since 1970 - or 0 for unknown/unset */
    uint32_t time;
    /* The level type of notification */
    meshtastic_LogRecord_Level level;
    /* The message body of the notification */
    char message[400];
} meshtastic_ClientNotification;

/* Individual File info for the device */
typedef struct _meshtastic_FileInfo {
    /* The fully qualified path of the file */
    char file_name[228];
    /* The size of the file in bytes */
    uint32_t size_bytes;
} meshtastic_FileInfo;

typedef PB_BYTES_ARRAY_T(237) meshtastic_Compressed_data_t;
/* Compressed message payload */
typedef struct _meshtastic_Compressed {
    /* PortNum to determine the how to handle the compressed payload. */
    meshtastic_PortNum portnum;
    /* Compressed data. */
    meshtastic_Compressed_data_t data;
} meshtastic_Compressed;

/* A single edge in the mesh */
typedef struct _meshtastic_Neighbor {
    /* Node ID of neighbor */
    uint32_t node_id;
    /* SNR of last heard message */
    float snr;
    /* Reception time (in secs since 1970) of last message that was last sent by this ID.
 Note: this is for local storage only and will not be sent out over the mesh. */
    uint32_t last_rx_time;
    /* Broadcast interval of this neighbor (in seconds).
 Note: this is for local storage only and will not be sent out over the mesh. */
    uint32_t node_broadcast_interval_secs;
} meshtastic_Neighbor;

/* Full info on edges for a single node */
typedef struct _meshtastic_NeighborInfo {
    /* The node ID of the node sending info on its neighbors */
    uint32_t node_id;
    /* Field to pass neighbor info for the next sending cycle */
    uint32_t last_sent_by_id;
    /* Broadcast interval of the represented node (in seconds) */
    uint32_t node_broadcast_interval_secs;
    /* The list of out edges from this node */
    pb_size_t neighbors_count;
    meshtastic_Neighbor neighbors[10];
} meshtastic_NeighborInfo;

/* Device metadata response */
typedef struct _meshtastic_DeviceMetadata {
    /* Device firmware version string */
    char firmware_version[18];
    /* Device state version */
    uint32_t device_state_version;
    /* Indicates whether the device can shutdown CPU natively or via power management chip */
    bool canShutdown;
    /* Indicates that the device has native wifi capability */
    bool hasWifi;
    /* Indicates that the device has native bluetooth capability */
    bool hasBluetooth;
    /* Indicates that the device has an ethernet peripheral */
    bool hasEthernet;
    /* Indicates that the device's role in the mesh */
    meshtastic_Config_DeviceConfig_Role role;
    /* Indicates the device's current enabled position flags */
    uint32_t position_flags;
    /* Device hardware model */
    meshtastic_HardwareModel hw_model;
    /* Has Remote Hardware enabled */
    bool hasRemoteHardware;
    /* Has PKC capabilities */
    bool hasPKC;
    /* Bit field of boolean for excluded modules
 (bitwise OR of ExcludedModules) */
    uint32_t excluded_modules;
} meshtastic_DeviceMetadata;

/* Packets from the radio to the phone will appear on the fromRadio characteristic.
 It will support READ and NOTIFY. When a new packet arrives the device will BLE notify?
 It will sit in that descriptor until consumed by the phone,
 at which point the next item in the FIFO will be populated. */
typedef struct _meshtastic_FromRadio {
    /* The packet id, used to allow the phone to request missing read packets from the FIFO,
 see our bluetooth docs */
    uint32_t id;
    pb_size_t which_payload_variant;
    union {
        /* Log levels, chosen to match python logging conventions. */
        meshtastic_MeshPacket packet;
        /* Tells the phone what our node number is, can be -1 if we've not yet joined a mesh.
     NOTE: This ID must not change - to keep (minimal) compatibility with <1.2 version of android apps. */
        meshtastic_MyNodeInfo my_info;
        /* One packet is sent for each node in the on radio DB
     starts over with the first node in our DB */
        meshtastic_NodeInfo node_info;
        /* Include a part of the config (was: RadioConfig radio) */
        meshtastic_Config config;
        /* Set to send debug console output over our protobuf stream */
        meshtastic_LogRecord log_record;
        /* Sent as true once the device has finished sending all of the responses to want_config
     recipient should check if this ID matches our original request nonce, if
     not, it means your config responses haven't started yet.
     NOTE: This ID must not change - to keep (minimal) compatibility with <1.2 version of android apps. */
        uint32_t config_complete_id;
        /* Sent to tell clients the radio has just rebooted.
     Set to true if present.
     Not used on all transports, currently just used for the serial console.
     NOTE: This ID must not change - to keep (minimal) compatibility with <1.2 version of android apps. */
        bool rebooted;
        /* Include module config */
        meshtastic_ModuleConfig moduleConfig;
        /* One packet is sent for each channel */
        meshtastic_Channel channel;
        /* Queue status info */
        meshtastic_QueueStatus queueStatus;
        /* File Transfer Chunk */
        meshtastic_XModem xmodemPacket;
        /* Device metadata message */
        meshtastic_DeviceMetadata metadata;
        /* MQTT Client Proxy Message (device sending to client / phone for publishing to MQTT) */
        meshtastic_MqttClientProxyMessage mqttClientProxyMessage;
        /* File system manifest messages */
        meshtastic_FileInfo fileInfo;
        /* Notification message to the client */
        meshtastic_ClientNotification clientNotification;
        /* Persistent data for device-ui */
        meshtastic_DeviceUIConfig deviceuiConfig;
    };
} meshtastic_FromRadio;

/* A heartbeat message is sent to the node from the client to keep the connection alive.
 This is currently only needed to keep serial connections alive, but can be used by any PhoneAPI. */
typedef struct _meshtastic_Heartbeat {
    char dummy_field;
} meshtastic_Heartbeat;

/* Packets/commands to the radio will be written (reliably) to the toRadio characteristic.
 Once the write completes the phone can assume it is handled. */
typedef struct _meshtastic_ToRadio {
    pb_size_t which_payload_variant;
    union {
        /* Send this packet on the mesh */
        meshtastic_MeshPacket packet;
        /* Phone wants radio to send full node db to the phone, This is
     typically the first packet sent to the radio when the phone gets a
     bluetooth connection. The radio will respond by sending back a
     MyNodeInfo, a owner, a radio config and a series of
     FromRadio.node_infos, and config_complete
     the integer you write into this field will be reported back in the
     config_complete_id response this allows clients to never be confused by
     a stale old partially sent config. */
        uint32_t want_config_id;
        /* Tell API server we are disconnecting now.
     This is useful for serial links where there is no hardware/protocol based notification that the client has dropped the link.
     (Sending this message is optional for clients) */
        bool disconnect;
        meshtastic_XModem xmodemPacket;
        /* MQTT Client Proxy Message (for client / phone subscribed to MQTT sending to device) */
        meshtastic_MqttClientProxyMessage mqttClientProxyMessage;
        /* Heartbeat message (used to keep the device connection awake on serial) */
        meshtastic_Heartbeat heartbeat;
    };
} meshtastic_ToRadio;

/* RemoteHardwarePins associated with a node */
typedef struct _meshtastic_NodeRemoteHardwarePin {
    /* The node_num exposing the available gpio pin */
    uint32_t node_num;
    /* The the available gpio pin for usage with RemoteHardware module */
    bool has_pin;
    meshtastic_RemoteHardwarePin pin;
} meshtastic_NodeRemoteHardwarePin;

typedef PB_BYTES_ARRAY_T(228) meshtastic_ChunkedPayload_payload_chunk_t;
typedef struct _meshtastic_ChunkedPayload {
    /* The ID of the entire payload */
    uint32_t payload_id;
    /* The total number of chunks in the payload */
    uint16_t chunk_count;
    /* The current chunk index in the total */
    uint16_t chunk_index;
    /* The binary data of the current chunk */
    meshtastic_ChunkedPayload_payload_chunk_t payload_chunk;
} meshtastic_ChunkedPayload;

/* Wrapper message for broken repeated oneof support */
typedef struct _meshtastic_resend_chunks {
    pb_callback_t chunks;
} meshtastic_resend_chunks;

/* Responses to a ChunkedPayload request */
typedef struct _meshtastic_ChunkedPayloadResponse {
    /* The ID of the entire payload */
    uint32_t payload_id;
    pb_size_t which_payload_variant;
    union {
        /* Request to transfer chunked payload */
        bool request_transfer;
        /* Accept the transfer chunked payload */
        bool accept_transfer;
        /* Request missing indexes in the chunked payload */
        meshtastic_resend_chunks resend_chunks;
    } payload_variant;
} meshtastic_ChunkedPayloadResponse;


#ifdef __cplusplus
extern "C" {
#endif

/* Helper constants for enums */
#define _meshtastic_HardwareModel_MIN meshtastic_HardwareModel_UNSET
#define _meshtastic_HardwareModel_MAX meshtastic_HardwareModel_PRIVATE_HW
#define _meshtastic_HardwareModel_ARRAYSIZE ((meshtastic_HardwareModel)(meshtastic_HardwareModel_PRIVATE_HW+1))

#define _meshtastic_Constants_MIN meshtastic_Constants_ZERO
#define _meshtastic_Constants_MAX meshtastic_Constants_DATA_PAYLOAD_LEN
#define _meshtastic_Constants_ARRAYSIZE ((meshtastic_Constants)(meshtastic_Constants_DATA_PAYLOAD_LEN+1))

#define _meshtastic_CriticalErrorCode_MIN meshtastic_CriticalErrorCode_NONE
#define _meshtastic_CriticalErrorCode_MAX meshtastic_CriticalErrorCode_FLASH_CORRUPTION_UNRECOVERABLE
#define _meshtastic_CriticalErrorCode_ARRAYSIZE ((meshtastic_CriticalErrorCode)(meshtastic_CriticalErrorCode_FLASH_CORRUPTION_UNRECOVERABLE+1))

#define _meshtastic_ExcludedModules_MIN meshtastic_ExcludedModules_EXCLUDED_NONE
#define _meshtastic_ExcludedModules_MAX meshtastic_ExcludedModules_PAXCOUNTER_CONFIG
#define _meshtastic_ExcludedModules_ARRAYSIZE ((meshtastic_ExcludedModules)(meshtastic_ExcludedModules_PAXCOUNTER_CONFIG+1))

#define _meshtastic_Position_LocSource_MIN meshtastic_Position_LocSource_LOC_UNSET
#define _meshtastic_Position_LocSource_MAX meshtastic_Position_LocSource_LOC_EXTERNAL
#define _meshtastic_Position_LocSource_ARRAYSIZE ((meshtastic_Position_LocSource)(meshtastic_Position_LocSource_LOC_EXTERNAL+1))

#define _meshtastic_Position_AltSource_MIN meshtastic_Position_AltSource_ALT_UNSET
#define _meshtastic_Position_AltSource_MAX meshtastic_Position_AltSource_ALT_BAROMETRIC
#define _meshtastic_Position_AltSource_ARRAYSIZE ((meshtastic_Position_AltSource)(meshtastic_Position_AltSource_ALT_BAROMETRIC+1))

#define _meshtastic_Routing_Error_MIN meshtastic_Routing_Error_NONE
#define _meshtastic_Routing_Error_MAX meshtastic_Routing_Error_ADMIN_PUBLIC_KEY_UNAUTHORIZED
#define _meshtastic_Routing_Error_ARRAYSIZE ((meshtastic_Routing_Error)(meshtastic_Routing_Error_ADMIN_PUBLIC_KEY_UNAUTHORIZED+1))

#define _meshtastic_MeshPacket_Priority_MIN meshtastic_MeshPacket_Priority_UNSET
#define _meshtastic_MeshPacket_Priority_MAX meshtastic_MeshPacket_Priority_MAX
#define _meshtastic_MeshPacket_Priority_ARRAYSIZE ((meshtastic_MeshPacket_Priority)(meshtastic_MeshPacket_Priority_MAX+1))

#define _meshtastic_MeshPacket_Delayed_MIN meshtastic_MeshPacket_Delayed_NO_DELAY
#define _meshtastic_MeshPacket_Delayed_MAX meshtastic_MeshPacket_Delayed_DELAYED_DIRECT
#define _meshtastic_MeshPacket_Delayed_ARRAYSIZE ((meshtastic_MeshPacket_Delayed)(meshtastic_MeshPacket_Delayed_DELAYED_DIRECT+1))

#define _meshtastic_LogRecord_Level_MIN meshtastic_LogRecord_Level_UNSET
#define _meshtastic_LogRecord_Level_MAX meshtastic_LogRecord_Level_CRITICAL
#define _meshtastic_LogRecord_Level_ARRAYSIZE ((meshtastic_LogRecord_Level)(meshtastic_LogRecord_Level_CRITICAL+1))

#define meshtastic_Position_location_source_ENUMTYPE meshtastic_Position_LocSource
#define meshtastic_Position_altitude_source_ENUMTYPE meshtastic_Position_AltSource

#define meshtastic_User_hw_model_ENUMTYPE meshtastic_HardwareModel
#define meshtastic_User_role_ENUMTYPE meshtastic_Config_DeviceConfig_Role


#define meshtastic_Routing_variant_error_reason_ENUMTYPE meshtastic_Routing_Error

#define meshtastic_Data_portnum_ENUMTYPE meshtastic_PortNum



#define meshtastic_MeshPacket_priority_ENUMTYPE meshtastic_MeshPacket_Priority
#define meshtastic_MeshPacket_delayed_ENUMTYPE meshtastic_MeshPacket_Delayed



#define meshtastic_LogRecord_level_ENUMTYPE meshtastic_LogRecord_Level



#define meshtastic_ClientNotification_level_ENUMTYPE meshtastic_LogRecord_Level



#define meshtastic_Compressed_portnum_ENUMTYPE meshtastic_PortNum



#define meshtastic_DeviceMetadata_role_ENUMTYPE meshtastic_Config_DeviceConfig_Role
#define meshtastic_DeviceMetadata_hw_model_ENUMTYPE meshtastic_HardwareModel







/* Initializer values for message structs */
#define meshtastic_Position_init_default         {false, 0, false, 0, false, 0, 0, _meshtastic_Position_LocSource_MIN, _meshtastic_Position_AltSource_MIN, 0, 0, false, 0, false, 0, 0, 0, 0, 0, false, 0, false, 0, 0, 0, 0, 0, 0, 0, 0}
#define meshtastic_User_init_default             {"", "", "", {0}, _meshtastic_HardwareModel_MIN, 0, _meshtastic_Config_DeviceConfig_Role_MIN, {0, {0}}}
#define meshtastic_RouteDiscovery_init_default   {0, {0, 0, 0, 0, 0, 0, 0, 0}, 0, {0, 0, 0, 0, 0, 0, 0, 0}, 0, {0, 0, 0, 0, 0, 0, 0, 0}, 0, {0, 0, 0, 0, 0, 0, 0, 0}}
#define meshtastic_Routing_init_default          {0, {meshtastic_RouteDiscovery_init_default}}
#define meshtastic_Data_init_default             {_meshtastic_PortNum_MIN, {0, {0}}, 0, 0, 0, 0, 0, 0, false, 0}
#define meshtastic_Waypoint_init_default         {0, false, 0, false, 0, 0, 0, "", "", 0}
#define meshtastic_MqttClientProxyMessage_init_default {"", 0, {{0, {0}}}, 0}
#define meshtastic_MeshPacket_init_default       {0, 0, 0, 0, {meshtastic_Data_init_default}, 0, 0, 0, 0, 0, _meshtastic_MeshPacket_Priority_MIN, 0, _meshtastic_MeshPacket_Delayed_MIN, 0, 0, {0, {0}}, 0}
#define meshtastic_NodeInfo_init_default         {0, false, meshtastic_User_init_default, false, meshtastic_Position_init_default, 0, 0, false, meshtastic_DeviceMetrics_init_default, 0, 0, false, 0, 0, 0}
#define meshtastic_MyNodeInfo_init_default       {0, 0, 0, {0, {0}}, ""}
#define meshtastic_LogRecord_init_default        {"", 0, "", _meshtastic_LogRecord_Level_MIN}
#define meshtastic_QueueStatus_init_default      {0, 0, 0, 0}
#define meshtastic_FromRadio_init_default        {0, 0, {meshtastic_MeshPacket_init_default}}
#define meshtastic_ClientNotification_init_default {false, 0, 0, _meshtastic_LogRecord_Level_MIN, ""}
#define meshtastic_FileInfo_init_default         {"", 0}
#define meshtastic_ToRadio_init_default          {0, {meshtastic_MeshPacket_init_default}}
#define meshtastic_Compressed_init_default       {_meshtastic_PortNum_MIN, {0, {0}}}
#define meshtastic_NeighborInfo_init_default     {0, 0, 0, 0, {meshtastic_Neighbor_init_default, meshtastic_Neighbor_init_default, meshtastic_Neighbor_init_default, meshtastic_Neighbor_init_default, meshtastic_Neighbor_init_default, meshtastic_Neighbor_init_default, meshtastic_Neighbor_init_default, meshtastic_Neighbor_init_default, meshtastic_Neighbor_init_default, meshtastic_Neighbor_init_default}}
#define meshtastic_Neighbor_init_default         {0, 0, 0, 0}
#define meshtastic_DeviceMetadata_init_default   {"", 0, 0, 0, 0, 0, _meshtastic_Config_DeviceConfig_Role_MIN, 0, _meshtastic_HardwareModel_MIN, 0, 0, 0}
#define meshtastic_Heartbeat_init_default        {0}
#define meshtastic_NodeRemoteHardwarePin_init_default {0, false, meshtastic_RemoteHardwarePin_init_default}
#define meshtastic_ChunkedPayload_init_default   {0, 0, 0, {0, {0}}}
#define meshtastic_resend_chunks_init_default    {{{NULL}, NULL}}
#define meshtastic_ChunkedPayloadResponse_init_default {0, 0, {0}}
#define meshtastic_Position_init_zero            {false, 0, false, 0, false, 0, 0, _meshtastic_Position_LocSource_MIN, _meshtastic_Position_AltSource_MIN, 0, 0, false, 0, false, 0, 0, 0, 0, 0, false, 0, false, 0, 0, 0, 0, 0, 0, 0, 0}
#define meshtastic_User_init_zero                {"", "", "", {0}, _meshtastic_HardwareModel_MIN, 0, _meshtastic_Config_DeviceConfig_Role_MIN, {0, {0}}}
#define meshtastic_RouteDiscovery_init_zero      {0, {0, 0, 0, 0, 0, 0, 0, 0}, 0, {0, 0, 0, 0, 0, 0, 0, 0}, 0, {0, 0, 0, 0, 0, 0, 0, 0}, 0, {0, 0, 0, 0, 0, 0, 0, 0}}
#define meshtastic_Routing_init_zero             {0, {meshtastic_RouteDiscovery_init_zero}}
#define meshtastic_Data_init_zero                {_meshtastic_PortNum_MIN, {0, {0}}, 0, 0, 0, 0, 0, 0, false, 0}
#define meshtastic_Waypoint_init_zero            {0, false, 0, false, 0, 0, 0, "", "", 0}
#define meshtastic_MqttClientProxyMessage_init_zero {"", 0, {{0, {0}}}, 0}
#define meshtastic_MeshPacket_init_zero          {0, 0, 0, 0, {meshtastic_Data_init_zero}, 0, 0, 0, 0, 0, _meshtastic_MeshPacket_Priority_MIN, 0, _meshtastic_MeshPacket_Delayed_MIN, 0, 0, {0, {0}}, 0}
#define meshtastic_NodeInfo_init_zero            {0, false, meshtastic_User_init_zero, false, meshtastic_Position_init_zero, 0, 0, false, meshtastic_DeviceMetrics_init_zero, 0, 0, false, 0, 0, 0}
#define meshtastic_MyNodeInfo_init_zero          {0, 0, 0, {0, {0}}, ""}
#define meshtastic_LogRecord_init_zero           {"", 0, "", _meshtastic_LogRecord_Level_MIN}
#define meshtastic_QueueStatus_init_zero         {0, 0, 0, 0}
#define meshtastic_FromRadio_init_zero           {0, 0, {meshtastic_MeshPacket_init_zero}}
#define meshtastic_ClientNotification_init_zero  {false, 0, 0, _meshtastic_LogRecord_Level_MIN, ""}
#define meshtastic_FileInfo_init_zero            {"", 0}
#define meshtastic_ToRadio_init_zero             {0, {meshtastic_MeshPacket_init_zero}}
#define meshtastic_Compressed_init_zero          {_meshtastic_PortNum_MIN, {0, {0}}}
#define meshtastic_NeighborInfo_init_zero        {0, 0, 0, 0, {meshtastic_Neighbor_init_zero, meshtastic_Neighbor_init_zero, meshtastic_Neighbor_init_zero, meshtastic_Neighbor_init_zero, meshtastic_Neighbor_init_zero, meshtastic_Neighbor_init_zero, meshtastic_Neighbor_init_zero, meshtastic_Neighbor_init_zero, meshtastic_Neighbor_init_zero, meshtastic_Neighbor_init_zero}}
#define meshtastic_Neighbor_init_zero            {0, 0, 0, 0}
#define meshtastic_DeviceMetadata_init_zero      {"", 0, 0, 0, 0, 0, _meshtastic_Config_DeviceConfig_Role_MIN, 0, _meshtastic_HardwareModel_MIN, 0, 0, 0}
#define meshtastic_Heartbeat_init_zero           {0}
#define meshtastic_NodeRemoteHardwarePin_init_zero {0, false, meshtastic_RemoteHardwarePin_init_zero}
#define meshtastic_ChunkedPayload_init_zero      {0, 0, 0, {0, {0}}}
#define meshtastic_resend_chunks_init_zero       {{{NULL}, NULL}}
#define meshtastic_ChunkedPayloadResponse_init_zero {0, 0, {0}}

/* Field tags (for use in manual encoding/decoding) */
#define meshtastic_Position_latitude_i_tag       1
#define meshtastic_Position_longitude_i_tag      2
#define meshtastic_Position_altitude_tag         3
#define meshtastic_Position_time_tag             4
#define meshtastic_Position_location_source_tag  5
#define meshtastic_Position_altitude_source_tag  6
#define meshtastic_Position_timestamp_tag        7
#define meshtastic_Position_timestamp_millis_adjust_tag 8
#define meshtastic_Position_altitude_hae_tag     9
#define meshtastic_Position_altitude_geoidal_separation_tag 10
#define meshtastic_Position_PDOP_tag             11
#define meshtastic_Position_HDOP_tag             12
#define meshtastic_Position_VDOP_tag             13
#define meshtastic_Position_gps_accuracy_tag     14
#define meshtastic_Position_ground_speed_tag     15
#define meshtastic_Position_ground_track_tag     16
#define meshtastic_Position_fix_quality_tag      17
#define meshtastic_Position_fix_type_tag         18
#define meshtastic_Position_sats_in_view_tag     19
#define meshtastic_Position_sensor_id_tag        20
#define meshtastic_Position_next_update_tag      21
#define meshtastic_Position_seq_number_tag       22
#define meshtastic_Position_precision_bits_tag   23
#define meshtastic_User_id_tag                   1
#define meshtastic_User_long_name_tag            2
#define meshtastic_User_short_name_tag           3
#define meshtastic_User_macaddr_tag              4
#define meshtastic_User_hw_model_tag             5
#define meshtastic_User_is_licensed_tag          6
#define meshtastic_User_role_tag                 7
#define meshtastic_User_public_key_tag           8
#define meshtastic_RouteDiscovery_route_tag      1
#define meshtastic_RouteDiscovery_snr_towards_tag 2
#define meshtastic_RouteDiscovery_route_back_tag 3
#define meshtastic_RouteDiscovery_snr_back_tag   4
#define meshtastic_Routing_route_request_tag     1
#define meshtastic_Routing_route_reply_tag       2
#define meshtastic_Routing_error_reason_tag      3
#define meshtastic_Data_portnum_tag              1
#define meshtastic_Data_payload_tag              2
#define meshtastic_Data_want_response_tag        3
#define meshtastic_Data_dest_tag                 4
#define meshtastic_Data_source_tag               5
#define meshtastic_Data_request_id_tag           6
#define meshtastic_Data_reply_id_tag             7
#define meshtastic_Data_emoji_tag                8
#define meshtastic_Data_bitfield_tag             9
#define meshtastic_Waypoint_id_tag               1
#define meshtastic_Waypoint_latitude_i_tag       2
#define meshtastic_Waypoint_longitude_i_tag      3
#define meshtastic_Waypoint_expire_tag           4
#define meshtastic_Waypoint_locked_to_tag        5
#define meshtastic_Waypoint_name_tag             6
#define meshtastic_Waypoint_description_tag      7
#define meshtastic_Waypoint_icon_tag             8
#define meshtastic_MqttClientProxyMessage_topic_tag 1
#define meshtastic_MqttClientProxyMessage_data_tag 2
#define meshtastic_MqttClientProxyMessage_text_tag 3
#define meshtastic_MqttClientProxyMessage_retained_tag 4
#define meshtastic_MeshPacket_from_tag           1
#define meshtastic_MeshPacket_to_tag             2
#define meshtastic_MeshPacket_channel_tag        3
#define meshtastic_MeshPacket_decoded_tag        4
#define meshtastic_MeshPacket_encrypted_tag      5
#define meshtastic_MeshPacket_id_tag             6
#define meshtastic_MeshPacket_rx_time_tag        7
#define meshtastic_MeshPacket_rx_snr_tag         8
#define meshtastic_MeshPacket_hop_limit_tag      9
#define meshtastic_MeshPacket_want_ack_tag       10
#define meshtastic_MeshPacket_priority_tag       11
#define meshtastic_MeshPacket_rx_rssi_tag        12
#define meshtastic_MeshPacket_delayed_tag        13
#define meshtastic_MeshPacket_via_mqtt_tag       14
#define meshtastic_MeshPacket_hop_start_tag      15
#define meshtastic_MeshPacket_public_key_tag     16
#define meshtastic_MeshPacket_pki_encrypted_tag  17
#define meshtastic_NodeInfo_num_tag              1
#define meshtastic_NodeInfo_user_tag             2
#define meshtastic_NodeInfo_position_tag         3
#define meshtastic_NodeInfo_snr_tag              4
#define meshtastic_NodeInfo_last_heard_tag       5
#define meshtastic_NodeInfo_device_metrics_tag   6
#define meshtastic_NodeInfo_channel_tag          7
#define meshtastic_NodeInfo_via_mqtt_tag         8
#define meshtastic_NodeInfo_hops_away_tag        9
#define meshtastic_NodeInfo_is_favorite_tag      10
#define meshtastic_NodeInfo_is_ignored_tag       11
#define meshtastic_MyNodeInfo_my_node_num_tag    1
#define meshtastic_MyNodeInfo_reboot_count_tag   8
#define meshtastic_MyNodeInfo_min_app_version_tag 11
#define meshtastic_MyNodeInfo_device_id_tag      12
#define meshtastic_MyNodeInfo_pio_env_tag        13
#define meshtastic_LogRecord_message_tag         1
#define meshtastic_LogRecord_time_tag            2
#define meshtastic_LogRecord_source_tag          3
#define meshtastic_LogRecord_level_tag           4
#define meshtastic_QueueStatus_res_tag           1
#define meshtastic_QueueStatus_free_tag          2
#define meshtastic_QueueStatus_maxlen_tag        3
#define meshtastic_QueueStatus_mesh_packet_id_tag 4
#define meshtastic_ClientNotification_reply_id_tag 1
#define meshtastic_ClientNotification_time_tag   2
#define meshtastic_ClientNotification_level_tag  3
#define meshtastic_ClientNotification_message_tag 4
#define meshtastic_FileInfo_file_name_tag        1
#define meshtastic_FileInfo_size_bytes_tag       2
#define meshtastic_Compressed_portnum_tag        1
#define meshtastic_Compressed_data_tag           2
#define meshtastic_Neighbor_node_id_tag          1
#define meshtastic_Neighbor_snr_tag              2
#define meshtastic_Neighbor_last_rx_time_tag     3
#define meshtastic_Neighbor_node_broadcast_interval_secs_tag 4
#define meshtastic_NeighborInfo_node_id_tag      1
#define meshtastic_NeighborInfo_last_sent_by_id_tag 2
#define meshtastic_NeighborInfo_node_broadcast_interval_secs_tag 3
#define meshtastic_NeighborInfo_neighbors_tag    4
#define meshtastic_DeviceMetadata_firmware_version_tag 1
#define meshtastic_DeviceMetadata_device_state_version_tag 2
#define meshtastic_DeviceMetadata_canShutdown_tag 3
#define meshtastic_DeviceMetadata_hasWifi_tag    4
#define meshtastic_DeviceMetadata_hasBluetooth_tag 5
#define meshtastic_DeviceMetadata_hasEthernet_tag 6
#define meshtastic_DeviceMetadata_role_tag       7
#define meshtastic_DeviceMetadata_position_flags_tag 8
#define meshtastic_DeviceMetadata_hw_model_tag   9
#define meshtastic_DeviceMetadata_hasRemoteHardware_tag 10
#define meshtastic_DeviceMetadata_hasPKC_tag     11
#define meshtastic_DeviceMetadata_excluded_modules_tag 12
#define meshtastic_FromRadio_id_tag              1
#define meshtastic_FromRadio_packet_tag          2
#define meshtastic_FromRadio_my_info_tag         3
#define meshtastic_FromRadio_node_info_tag       4
#define meshtastic_FromRadio_config_tag          5
#define meshtastic_FromRadio_log_record_tag      6
#define meshtastic_FromRadio_config_complete_id_tag 7
#define meshtastic_FromRadio_rebooted_tag        8
#define meshtastic_FromRadio_moduleConfig_tag    9
#define meshtastic_FromRadio_channel_tag         10
#define meshtastic_FromRadio_queueStatus_tag     11
#define meshtastic_FromRadio_xmodemPacket_tag    12
#define meshtastic_FromRadio_metadata_tag        13
#define meshtastic_FromRadio_mqttClientProxyMessage_tag 14
#define meshtastic_FromRadio_fileInfo_tag        15
#define meshtastic_FromRadio_clientNotification_tag 16
#define meshtastic_FromRadio_deviceuiConfig_tag  17
#define meshtastic_ToRadio_packet_tag            1
#define meshtastic_ToRadio_want_config_id_tag    3
#define meshtastic_ToRadio_disconnect_tag        4
#define meshtastic_ToRadio_xmodemPacket_tag      5
#define meshtastic_ToRadio_mqttClientProxyMessage_tag 6
#define meshtastic_ToRadio_heartbeat_tag         7
#define meshtastic_NodeRemoteHardwarePin_node_num_tag 1
#define meshtastic_NodeRemoteHardwarePin_pin_tag 2
#define meshtastic_ChunkedPayload_payload_id_tag 1
#define meshtastic_ChunkedPayload_chunk_count_tag 2
#define meshtastic_ChunkedPayload_chunk_index_tag 3
#define meshtastic_ChunkedPayload_payload_chunk_tag 4
#define meshtastic_resend_chunks_chunks_tag      1
#define meshtastic_ChunkedPayloadResponse_payload_id_tag 1
#define meshtastic_ChunkedPayloadResponse_request_transfer_tag 2
#define meshtastic_ChunkedPayloadResponse_accept_transfer_tag 3
#define meshtastic_ChunkedPayloadResponse_resend_chunks_tag 4

/* Struct field encoding specification for nanopb */
#define meshtastic_Position_FIELDLIST(X, a) \
X(a, STATIC,   OPTIONAL, SFIXED32, latitude_i,        1) \
X(a, STATIC,   OPTIONAL, SFIXED32, longitude_i,       2) \
X(a, STATIC,   OPTIONAL, INT32,    altitude,          3) \
X(a, STATIC,   SINGULAR, FIXED32,  time,              4) \
X(a, STATIC,   SINGULAR, UENUM,    location_source,   5) \
X(a, STATIC,   SINGULAR, UENUM,    altitude_source,   6) \
X(a, STATIC,   SINGULAR, FIXED32,  timestamp,         7) \
X(a, STATIC,   SINGULAR, INT32,    timestamp_millis_adjust,   8) \
X(a, STATIC,   OPTIONAL, SINT32,   altitude_hae,      9) \
X(a, STATIC,   OPTIONAL, SINT32,   altitude_geoidal_separation,  10) \
X(a, STATIC,   SINGULAR, UINT32,   PDOP,             11) \
X(a, STATIC,   SINGULAR, UINT32,   HDOP,             12) \
X(a, STATIC,   SINGULAR, UINT32,   VDOP,             13) \
X(a, STATIC,   SINGULAR, UINT32,   gps_accuracy,     14) \
X(a, STATIC,   OPTIONAL, UINT32,   ground_speed,     15) \
X(a, STATIC,   OPTIONAL, UINT32,   ground_track,     16) \
X(a, STATIC,   SINGULAR, UINT32,   fix_quality,      17) \
X(a, STATIC,   SINGULAR, UINT32,   fix_type,         18) \
X(a, STATIC,   SINGULAR, UINT32,   sats_in_view,     19) \
X(a, STATIC,   SINGULAR, UINT32,   sensor_id,        20) \
X(a, STATIC,   SINGULAR, UINT32,   next_update,      21) \
X(a, STATIC,   SINGULAR, UINT32,   seq_number,       22) \
X(a, STATIC,   SINGULAR, UINT32,   precision_bits,   23)
#define meshtastic_Position_CALLBACK NULL
#define meshtastic_Position_DEFAULT NULL

#define meshtastic_User_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, STRING,   id,                1) \
X(a, STATIC,   SINGULAR, STRING,   long_name,         2) \
X(a, STATIC,   SINGULAR, STRING,   short_name,        3) \
X(a, STATIC,   SINGULAR, FIXED_LENGTH_BYTES, macaddr,           4) \
X(a, STATIC,   SINGULAR, UENUM,    hw_model,          5) \
X(a, STATIC,   SINGULAR, BOOL,     is_licensed,       6) \
X(a, STATIC,   SINGULAR, UENUM,    role,              7) \
X(a, STATIC,   SINGULAR, BYTES,    public_key,        8)
#define meshtastic_User_CALLBACK NULL
#define meshtastic_User_DEFAULT NULL

#define meshtastic_RouteDiscovery_FIELDLIST(X, a) \
X(a, STATIC,   REPEATED, FIXED32,  route,             1) \
X(a, STATIC,   REPEATED, INT32,    snr_towards,       2) \
X(a, STATIC,   REPEATED, FIXED32,  route_back,        3) \
X(a, STATIC,   REPEATED, INT32,    snr_back,          4)
#define meshtastic_RouteDiscovery_CALLBACK NULL
#define meshtastic_RouteDiscovery_DEFAULT NULL

#define meshtastic_Routing_FIELDLIST(X, a) \
X(a, STATIC,   ONEOF,    MESSAGE,  (variant,route_request,route_request),   1) \
X(a, STATIC,   ONEOF,    MESSAGE,  (variant,route_reply,route_reply),   2) \
X(a, STATIC,   ONEOF,    UENUM,    (variant,error_reason,error_reason),   3)
#define meshtastic_Routing_CALLBACK NULL
#define meshtastic_Routing_DEFAULT NULL
#define meshtastic_Routing_variant_route_request_MSGTYPE meshtastic_RouteDiscovery
#define meshtastic_Routing_variant_route_reply_MSGTYPE meshtastic_RouteDiscovery

#define meshtastic_Data_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UENUM,    portnum,           1) \
X(a, STATIC,   SINGULAR, BYTES,    payload,           2) \
X(a, STATIC,   SINGULAR, BOOL,     want_response,     3) \
X(a, STATIC,   SINGULAR, FIXED32,  dest,              4) \
X(a, STATIC,   SINGULAR, FIXED32,  source,            5) \
X(a, STATIC,   SINGULAR, FIXED32,  request_id,        6) \
X(a, STATIC,   SINGULAR, FIXED32,  reply_id,          7) \
X(a, STATIC,   SINGULAR, FIXED32,  emoji,             8) \
X(a, STATIC,   OPTIONAL, UINT32,   bitfield,          9)
#define meshtastic_Data_CALLBACK NULL
#define meshtastic_Data_DEFAULT NULL

#define meshtastic_Waypoint_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   id,                1) \
X(a, STATIC,   OPTIONAL, SFIXED32, latitude_i,        2) \
X(a, STATIC,   OPTIONAL, SFIXED32, longitude_i,       3) \
X(a, STATIC,   SINGULAR, UINT32,   expire,            4) \
X(a, STATIC,   SINGULAR, UINT32,   locked_to,         5) \
X(a, STATIC,   SINGULAR, STRING,   name,              6) \
X(a, STATIC,   SINGULAR, STRING,   description,       7) \
X(a, STATIC,   SINGULAR, FIXED32,  icon,              8)
#define meshtastic_Waypoint_CALLBACK NULL
#define meshtastic_Waypoint_DEFAULT NULL

#define meshtastic_MqttClientProxyMessage_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, STRING,   topic,             1) \
X(a, STATIC,   ONEOF,    BYTES,    (payload_variant,data,payload_variant.data),   2) \
X(a, STATIC,   ONEOF,    STRING,   (payload_variant,text,payload_variant.text),   3) \
X(a, STATIC,   SINGULAR, BOOL,     retained,          4)
#define meshtastic_MqttClientProxyMessage_CALLBACK NULL
#define meshtastic_MqttClientProxyMessage_DEFAULT NULL

#define meshtastic_MeshPacket_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, FIXED32,  from,              1) \
X(a, STATIC,   SINGULAR, FIXED32,  to,                2) \
X(a, STATIC,   SINGULAR, UINT32,   channel,           3) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,decoded,decoded),   4) \
X(a, STATIC,   ONEOF,    BYTES,    (payload_variant,encrypted,encrypted),   5) \
X(a, STATIC,   SINGULAR, FIXED32,  id,                6) \
X(a, STATIC,   SINGULAR, FIXED32,  rx_time,           7) \
X(a, STATIC,   SINGULAR, FLOAT,    rx_snr,            8) \
X(a, STATIC,   SINGULAR, UINT32,   hop_limit,         9) \
X(a, STATIC,   SINGULAR, BOOL,     want_ack,         10) \
X(a, STATIC,   SINGULAR, UENUM,    priority,         11) \
X(a, STATIC,   SINGULAR, INT32,    rx_rssi,          12) \
X(a, STATIC,   SINGULAR, UENUM,    delayed,          13) \
X(a, STATIC,   SINGULAR, BOOL,     via_mqtt,         14) \
X(a, STATIC,   SINGULAR, UINT32,   hop_start,        15) \
X(a, STATIC,   SINGULAR, BYTES,    public_key,       16) \
X(a, STATIC,   SINGULAR, BOOL,     pki_encrypted,    17)
#define meshtastic_MeshPacket_CALLBACK NULL
#define meshtastic_MeshPacket_DEFAULT NULL
#define meshtastic_MeshPacket_payload_variant_decoded_MSGTYPE meshtastic_Data

#define meshtastic_NodeInfo_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   num,               1) \
X(a, STATIC,   OPTIONAL, MESSAGE,  user,              2) \
X(a, STATIC,   OPTIONAL, MESSAGE,  position,          3) \
X(a, STATIC,   SINGULAR, FLOAT,    snr,               4) \
X(a, STATIC,   SINGULAR, FIXED32,  last_heard,        5) \
X(a, STATIC,   OPTIONAL, MESSAGE,  device_metrics,    6) \
X(a, STATIC,   SINGULAR, UINT32,   channel,           7) \
X(a, STATIC,   SINGULAR, BOOL,     via_mqtt,          8) \
X(a, STATIC,   OPTIONAL, UINT32,   hops_away,         9) \
X(a, STATIC,   SINGULAR, BOOL,     is_favorite,      10) \
X(a, STATIC,   SINGULAR, BOOL,     is_ignored,       11)
#define meshtastic_NodeInfo_CALLBACK NULL
#define meshtastic_NodeInfo_DEFAULT NULL
#define meshtastic_NodeInfo_user_MSGTYPE meshtastic_User
#define meshtastic_NodeInfo_position_MSGTYPE meshtastic_Position
#define meshtastic_NodeInfo_device_metrics_MSGTYPE meshtastic_DeviceMetrics

#define meshtastic_MyNodeInfo_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   my_node_num,       1) \
X(a, STATIC,   SINGULAR, UINT32,   reboot_count,      8) \
X(a, STATIC,   SINGULAR, UINT32,   min_app_version,  11) \
X(a, STATIC,   SINGULAR, BYTES,    device_id,        12) \
X(a, STATIC,   SINGULAR, STRING,   pio_env,          13)
#define meshtastic_MyNodeInfo_CALLBACK NULL
#define meshtastic_MyNodeInfo_DEFAULT NULL

#define meshtastic_LogRecord_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, STRING,   message,           1) \
X(a, STATIC,   SINGULAR, FIXED32,  time,              2) \
X(a, STATIC,   SINGULAR, STRING,   source,            3) \
X(a, STATIC,   SINGULAR, UENUM,    level,             4)
#define meshtastic_LogRecord_CALLBACK NULL
#define meshtastic_LogRecord_DEFAULT NULL

#define meshtastic_QueueStatus_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, INT32,    res,               1) \
X(a, STATIC,   SINGULAR, UINT32,   free,              2) \
X(a, STATIC,   SINGULAR, UINT32,   maxlen,            3) \
X(a, STATIC,   SINGULAR, UINT32,   mesh_packet_id,    4)
#define meshtastic_QueueStatus_CALLBACK NULL
#define meshtastic_QueueStatus_DEFAULT NULL

#define meshtastic_FromRadio_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   id,                1) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,packet,packet),   2) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,my_info,my_info),   3) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,node_info,node_info),   4) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,config,config),   5) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,log_record,log_record),   6) \
X(a, STATIC,   ONEOF,    UINT32,   (payload_variant,config_complete_id,config_complete_id),   7) \
X(a, STATIC,   ONEOF,    BOOL,     (payload_variant,rebooted,rebooted),   8) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,moduleConfig,moduleConfig),   9) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,channel,channel),  10) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,queueStatus,queueStatus),  11) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,xmodemPacket,xmodemPacket),  12) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,metadata,metadata),  13) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,mqttClientProxyMessage,mqttClientProxyMessage),  14) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,fileInfo,fileInfo),  15) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,clientNotification,clientNotification),  16) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,deviceuiConfig,deviceuiConfig),  17)
#define meshtastic_FromRadio_CALLBACK NULL
#define meshtastic_FromRadio_DEFAULT NULL
#define meshtastic_FromRadio_payload_variant_packet_MSGTYPE meshtastic_MeshPacket
#define meshtastic_FromRadio_payload_variant_my_info_MSGTYPE meshtastic_MyNodeInfo
#define meshtastic_FromRadio_payload_variant_node_info_MSGTYPE meshtastic_NodeInfo
#define meshtastic_FromRadio_payload_variant_config_MSGTYPE meshtastic_Config
#define meshtastic_FromRadio_payload_variant_log_record_MSGTYPE meshtastic_LogRecord
#define meshtastic_FromRadio_payload_variant_moduleConfig_MSGTYPE meshtastic_ModuleConfig
#define meshtastic_FromRadio_payload_variant_channel_MSGTYPE meshtastic_Channel
#define meshtastic_FromRadio_payload_variant_queueStatus_MSGTYPE meshtastic_QueueStatus
#define meshtastic_FromRadio_payload_variant_xmodemPacket_MSGTYPE meshtastic_XModem
#define meshtastic_FromRadio_payload_variant_metadata_MSGTYPE meshtastic_DeviceMetadata
#define meshtastic_FromRadio_payload_variant_mqttClientProxyMessage_MSGTYPE meshtastic_MqttClientProxyMessage
#define meshtastic_FromRadio_payload_variant_fileInfo_MSGTYPE meshtastic_FileInfo
#define meshtastic_FromRadio_payload_variant_clientNotification_MSGTYPE meshtastic_ClientNotification
#define meshtastic_FromRadio_payload_variant_deviceuiConfig_MSGTYPE meshtastic_DeviceUIConfig

#define meshtastic_ClientNotification_FIELDLIST(X, a) \
X(a, STATIC,   OPTIONAL, UINT32,   reply_id,          1) \
X(a, STATIC,   SINGULAR, FIXED32,  time,              2) \
X(a, STATIC,   SINGULAR, UENUM,    level,             3) \
X(a, STATIC,   SINGULAR, STRING,   message,           4)
#define meshtastic_ClientNotification_CALLBACK NULL
#define meshtastic_ClientNotification_DEFAULT NULL

#define meshtastic_FileInfo_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, STRING,   file_name,         1) \
X(a, STATIC,   SINGULAR, UINT32,   size_bytes,        2)
#define meshtastic_FileInfo_CALLBACK NULL
#define meshtastic_FileInfo_DEFAULT NULL

#define meshtastic_ToRadio_FIELDLIST(X, a) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,packet,packet),   1) \
X(a, STATIC,   ONEOF,    UINT32,   (payload_variant,want_config_id,want_config_id),   3) \
X(a, STATIC,   ONEOF,    BOOL,     (payload_variant,disconnect,disconnect),   4) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,xmodemPacket,xmodemPacket),   5) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,mqttClientProxyMessage,mqttClientProxyMessage),   6) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,heartbeat,heartbeat),   7)
#define meshtastic_ToRadio_CALLBACK NULL
#define meshtastic_ToRadio_DEFAULT NULL
#define meshtastic_ToRadio_payload_variant_packet_MSGTYPE meshtastic_MeshPacket
#define meshtastic_ToRadio_payload_variant_xmodemPacket_MSGTYPE meshtastic_XModem
#define meshtastic_ToRadio_payload_variant_mqttClientProxyMessage_MSGTYPE meshtastic_MqttClientProxyMessage
#define meshtastic_ToRadio_payload_variant_heartbeat_MSGTYPE meshtastic_Heartbeat

#define meshtastic_Compressed_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UENUM,    portnum,           1) \
X(a, STATIC,   SINGULAR, BYTES,    data,              2)
#define meshtastic_Compressed_CALLBACK NULL
#define meshtastic_Compressed_DEFAULT NULL

#define meshtastic_NeighborInfo_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   node_id,           1) \
X(a, STATIC,   SINGULAR, UINT32,   last_sent_by_id,   2) \
X(a, STATIC,   SINGULAR, UINT32,   node_broadcast_interval_secs,   3) \
X(a, STATIC,   REPEATED, MESSAGE,  neighbors,         4)
#define meshtastic_NeighborInfo_CALLBACK NULL
#define meshtastic_NeighborInfo_DEFAULT NULL
#define meshtastic_NeighborInfo_neighbors_MSGTYPE meshtastic_Neighbor

#define meshtastic_Neighbor_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   node_id,           1) \
X(a, STATIC,   SINGULAR, FLOAT,    snr,               2) \
X(a, STATIC,   SINGULAR, FIXED32,  last_rx_time,      3) \
X(a, STATIC,   SINGULAR, UINT32,   node_broadcast_interval_secs,   4)
#define meshtastic_Neighbor_CALLBACK NULL
#define meshtastic_Neighbor_DEFAULT NULL

#define meshtastic_DeviceMetadata_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, STRING,   firmware_version,   1) \
X(a, STATIC,   SINGULAR, UINT32,   device_state_version,   2) \
X(a, STATIC,   SINGULAR, BOOL,     canShutdown,       3) \
X(a, STATIC,   SINGULAR, BOOL,     hasWifi,           4) \
X(a, STATIC,   SINGULAR, BOOL,     hasBluetooth,      5) \
X(a, STATIC,   SINGULAR, BOOL,     hasEthernet,       6) \
X(a, STATIC,   SINGULAR, UENUM,    role,              7) \
X(a, STATIC,   SINGULAR, UINT32,   position_flags,    8) \
X(a, STATIC,   SINGULAR, UENUM,    hw_model,          9) \
X(a, STATIC,   SINGULAR, BOOL,     hasRemoteHardware,  10) \
X(a, STATIC,   SINGULAR, BOOL,     hasPKC,           11) \
X(a, STATIC,   SINGULAR, UINT32,   excluded_modules,  12)
#define meshtastic_DeviceMetadata_CALLBACK NULL
#define meshtastic_DeviceMetadata_DEFAULT NULL

#define meshtastic_Heartbeat_FIELDLIST(X, a) \

#define meshtastic_Heartbeat_CALLBACK NULL
#define meshtastic_Heartbeat_DEFAULT NULL

#define meshtastic_NodeRemoteHardwarePin_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   node_num,          1) \
X(a, STATIC,   OPTIONAL, MESSAGE,  pin,               2)
#define meshtastic_NodeRemoteHardwarePin_CALLBACK NULL
#define meshtastic_NodeRemoteHardwarePin_DEFAULT NULL
#define meshtastic_NodeRemoteHardwarePin_pin_MSGTYPE meshtastic_RemoteHardwarePin

#define meshtastic_ChunkedPayload_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   payload_id,        1) \
X(a, STATIC,   SINGULAR, UINT32,   chunk_count,       2) \
X(a, STATIC,   SINGULAR, UINT32,   chunk_index,       3) \
X(a, STATIC,   SINGULAR, BYTES,    payload_chunk,     4)
#define meshtastic_ChunkedPayload_CALLBACK NULL
#define meshtastic_ChunkedPayload_DEFAULT NULL

#define meshtastic_resend_chunks_FIELDLIST(X, a) \
X(a, CALLBACK, REPEATED, UINT32,   chunks,            1)
#define meshtastic_resend_chunks_CALLBACK pb_default_field_callback
#define meshtastic_resend_chunks_DEFAULT NULL

#define meshtastic_ChunkedPayloadResponse_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   payload_id,        1) \
X(a, STATIC,   ONEOF,    BOOL,     (payload_variant,request_transfer,payload_variant.request_transfer),   2) \
X(a, STATIC,   ONEOF,    BOOL,     (payload_variant,accept_transfer,payload_variant.accept_transfer),   3) \
X(a, STATIC,   ONEOF,    MESSAGE,  (payload_variant,resend_chunks,payload_variant.resend_chunks),   4)
#define meshtastic_ChunkedPayloadResponse_CALLBACK NULL
#define meshtastic_ChunkedPayloadResponse_DEFAULT NULL
#define meshtastic_ChunkedPayloadResponse_payload_variant_resend_chunks_MSGTYPE meshtastic_resend_chunks

extern const pb_msgdesc_t meshtastic_Position_msg;
extern const pb_msgdesc_t meshtastic_User_msg;
extern const pb_msgdesc_t meshtastic_RouteDiscovery_msg;
extern const pb_msgdesc_t meshtastic_Routing_msg;
extern const pb_msgdesc_t meshtastic_Data_msg;
extern const pb_msgdesc_t meshtastic_Waypoint_msg;
extern const pb_msgdesc_t meshtastic_MqttClientProxyMessage_msg;
extern const pb_msgdesc_t meshtastic_MeshPacket_msg;
extern const pb_msgdesc_t meshtastic_NodeInfo_msg;
extern const pb_msgdesc_t meshtastic_MyNodeInfo_msg;
extern const pb_msgdesc_t meshtastic_LogRecord_msg;
extern const pb_msgdesc_t meshtastic_QueueStatus_msg;
extern const pb_msgdesc_t meshtastic_FromRadio_msg;
extern const pb_msgdesc_t meshtastic_ClientNotification_msg;
extern const pb_msgdesc_t meshtastic_FileInfo_msg;
extern const pb_msgdesc_t meshtastic_ToRadio_msg;
extern const pb_msgdesc_t meshtastic_Compressed_msg;
extern const pb_msgdesc_t meshtastic_NeighborInfo_msg;
extern const pb_msgdesc_t meshtastic_Neighbor_msg;
extern const pb_msgdesc_t meshtastic_DeviceMetadata_msg;
extern const pb_msgdesc_t meshtastic_Heartbeat_msg;
extern const pb_msgdesc_t meshtastic_NodeRemoteHardwarePin_msg;
extern const pb_msgdesc_t meshtastic_ChunkedPayload_msg;
extern const pb_msgdesc_t meshtastic_resend_chunks_msg;
extern const pb_msgdesc_t meshtastic_ChunkedPayloadResponse_msg;

/* Defines for backwards compatibility with code written before nanopb-0.4.0 */
#define meshtastic_Position_fields &meshtastic_Position_msg
#define meshtastic_User_fields &meshtastic_User_msg
#define meshtastic_RouteDiscovery_fields &meshtastic_RouteDiscovery_msg
#define meshtastic_Routing_fields &meshtastic_Routing_msg
#define meshtastic_Data_fields &meshtastic_Data_msg
#define meshtastic_Waypoint_fields &meshtastic_Waypoint_msg
#define meshtastic_MqttClientProxyMessage_fields &meshtastic_MqttClientProxyMessage_msg
#define meshtastic_MeshPacket_fields &meshtastic_MeshPacket_msg
#define meshtastic_NodeInfo_fields &meshtastic_NodeInfo_msg
#define meshtastic_MyNodeInfo_fields &meshtastic_MyNodeInfo_msg
#define meshtastic_LogRecord_fields &meshtastic_LogRecord_msg
#define meshtastic_QueueStatus_fields &meshtastic_QueueStatus_msg
#define meshtastic_FromRadio_fields &meshtastic_FromRadio_msg
#define meshtastic_ClientNotification_fields &meshtastic_ClientNotification_msg
#define meshtastic_FileInfo_fields &meshtastic_FileInfo_msg
#define meshtastic_ToRadio_fields &meshtastic_ToRadio_msg
#define meshtastic_Compressed_fields &meshtastic_Compressed_msg
#define meshtastic_NeighborInfo_fields &meshtastic_NeighborInfo_msg
#define meshtastic_Neighbor_fields &meshtastic_Neighbor_msg
#define meshtastic_DeviceMetadata_fields &meshtastic_DeviceMetadata_msg
#define meshtastic_Heartbeat_fields &meshtastic_Heartbeat_msg
#define meshtastic_NodeRemoteHardwarePin_fields &meshtastic_NodeRemoteHardwarePin_msg
#define meshtastic_ChunkedPayload_fields &meshtastic_ChunkedPayload_msg
#define meshtastic_resend_chunks_fields &meshtastic_resend_chunks_msg
#define meshtastic_ChunkedPayloadResponse_fields &meshtastic_ChunkedPayloadResponse_msg

/* Maximum encoded size of messages (where known) */
/* meshtastic_resend_chunks_size depends on runtime parameters */
/* meshtastic_ChunkedPayloadResponse_size depends on runtime parameters */
#define MESHTASTIC_MESHTASTIC_MESH_PB_H_MAX_SIZE meshtastic_FromRadio_size
#define meshtastic_ChunkedPayload_size           245
#define meshtastic_ClientNotification_size       415
#define meshtastic_Compressed_size               243
#define meshtastic_Data_size                     273
#define meshtastic_DeviceMetadata_size           54
#define meshtastic_FileInfo_size                 236
#define meshtastic_FromRadio_size                510
#define meshtastic_Heartbeat_size                0
#define meshtastic_LogRecord_size                426
#define meshtastic_MeshPacket_size               367
#define meshtastic_MqttClientProxyMessage_size   501
#define meshtastic_MyNodeInfo_size               77
#define meshtastic_NeighborInfo_size             258
#define meshtastic_Neighbor_size                 22
#define meshtastic_NodeInfo_size                 319
#define meshtastic_NodeRemoteHardwarePin_size    29
#define meshtastic_Position_size                 144
#define meshtastic_QueueStatus_size              23
#define meshtastic_RouteDiscovery_size           256
#define meshtastic_Routing_size                  259
#define meshtastic_ToRadio_size                  504
#define meshtastic_User_size                     113
#define meshtastic_Waypoint_size                 165

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
