# MCM ATM90E32 Library for Arduino

The MCM_ATM90E32 Library simplifies the integration of the ATM90E32AS Energy Meter IC. It provides an easy-to-use interface and API to monitor 3-Phase or Split-Phase electrical systems with Arduino boards.

The library was designed to power the **[MCM Split-Phase Energy Monitor](https://www.elecrow.com/mcm-split-phase-energy-monitor.html)**, a customizable electricity usage tracker that can be monitored in real time and lets you save energy on the go. You can adapt the system to your needs by using different current sensors that fit your grid characteristics and work with different standardize voltages. 

📖 For more information about this library, please read the documentation [here](https://github.com/mcmchris/mcm-atm90e32-lib/tree/main/docs)

## Hardware Compatibility

This library is compatible with all Arduino boards that features an SPI interface. Although the MCM Split-Phase Energy Monitor is designed for the **Nano** form factor.

Perfect match for my MCM Split-Phase Energy Monitor.

![MCM Split-Phase Energy Monitor](/docs/assets/Demo-no-back-no-letter.png)


## Support and Contributions

If you find this library helpful, consider supporting my work through donations or buying my [hardware](https://www.elecrow.com/mcm-split-phase-energy-monitor.html).
