// SPDX-License-Identifier: MIT
/*
 * Copyright (C) 2023-2024 Mathieu Carbou
 */
#pragma once

// related projects:
// - https://github.com/rzeldent/micro-timezonedb
// - https://en.wikipedia.org/wiki/List_of_tz_database_time_zones
static const char* MYCILA_NTP_SPEC = {
  "Africa/Abidjan=GMT0\n"
  "Africa/Accra=GMT0\n"
  "Africa/Addis_Ababa=EAT-3\n"
  "Africa/Algiers=CET-1\n"
  "Africa/Asmara=EAT-3\n"
  "Africa/Bamako=GMT0\n"
  "Africa/Bangui=WAT-1\n"
  "Africa/Banjul=GMT0\n"
  "Africa/Bissau=GMT0\n"
  "Africa/Blantyre=CAT-2\n"
  "Africa/Brazzaville=WAT-1\n"
  "Africa/Bujumbura=CAT-2\n"
  "Africa/Cairo=EET-2EEST,M4.5.5/0,M10.5.4/24\n"
  "Africa/Casablanca=<+01>-1\n"
  "Africa/Ceuta=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Africa/Conakry=GMT0\n"
  "Africa/Dakar=GMT0\n"
  "Africa/Dar_es_Salaam=EAT-3\n"
  "Africa/Djibouti=EAT-3\n"
  "Africa/Douala=WAT-1\n"
  "Africa/El_Aaiun=<+01>-1\n"
  "Africa/Freetown=GMT0\n"
  "Africa/Gaborone=CAT-2\n"
  "Africa/Harare=CAT-2\n"
  "Africa/Johannesburg=SAST-2\n"
  "Africa/Juba=CAT-2\n"
  "Africa/Kampala=EAT-3\n"
  "Africa/Khartoum=CAT-2\n"
  "Africa/Kigali=CAT-2\n"
  "Africa/Kinshasa=WAT-1\n"
  "Africa/Lagos=WAT-1\n"
  "Africa/Libreville=WAT-1\n"
  "Africa/Lome=GMT0\n"
  "Africa/Luanda=WAT-1\n"
  "Africa/Lubumbashi=CAT-2\n"
  "Africa/Lusaka=CAT-2\n"
  "Africa/Malabo=WAT-1\n"
  "Africa/Maputo=CAT-2\n"
  "Africa/Maseru=SAST-2\n"
  "Africa/Mbabane=SAST-2\n"
  "Africa/Mogadishu=EAT-3\n"
  "Africa/Monrovia=GMT0\n"
  "Africa/Nairobi=EAT-3\n"
  "Africa/Ndjamena=WAT-1\n"
  "Africa/Niamey=WAT-1\n"
  "Africa/Nouakchott=GMT0\n"
  "Africa/Ouagadougou=GMT0\n"
  "Africa/Porto-Novo=WAT-1\n"
  "Africa/Sao_Tome=GMT0\n"
  "Africa/Tripoli=EET-2\n"
  "Africa/Tunis=CET-1\n"
  "Africa/Windhoek=CAT-2\n"
  "America/Adak=HST10HDT,M3.2.0,M11.1.0\n"
  "America/Anchorage=AKST9AKDT,M3.2.0,M11.1.0\n"
  "America/Anguilla=AST4\n"
  "America/Antigua=AST4\n"
  "America/Araguaina=<-03>3\n"
  "America/Argentina/Buenos_Aires=<-03>3\n"
  "America/Argentina/Catamarca=<-03>3\n"
  "America/Argentina/Cordoba=<-03>3\n"
  "America/Argentina/Jujuy=<-03>3\n"
  "America/Argentina/La_Rioja=<-03>3\n"
  "America/Argentina/Mendoza=<-03>3\n"
  "America/Argentina/Rio_Gallegos=<-03>3\n"
  "America/Argentina/Salta=<-03>3\n"
  "America/Argentina/San_Juan=<-03>3\n"
  "America/Argentina/San_Luis=<-03>3\n"
  "America/Argentina/Tucuman=<-03>3\n"
  "America/Argentina/Ushuaia=<-03>3\n"
  "America/Aruba=AST4\n"
  "America/Asuncion=<-04>4<-03>,M10.1.0/0,M3.4.0/0\n"
  "America/Atikokan=EST5\n"
  "America/Bahia=<-03>3\n"
  "America/Bahia_Banderas=CST6\n"
  "America/Barbados=AST4\n"
  "America/Belem=<-03>3\n"
  "America/Belize=CST6\n"
  "America/Blanc-Sablon=AST4\n"
  "America/Boa_Vista=<-04>4\n"
  "America/Bogota=<-05>5\n"
  "America/Boise=MST7MDT,M3.2.0,M11.1.0\n"
  "America/Cambridge_Bay=MST7MDT,M3.2.0,M11.1.0\n"
  "America/Campo_Grande=<-04>4\n"
  "America/Cancun=EST5\n"
  "America/Caracas=<-04>4\n"
  "America/Cayenne=<-03>3\n"
  "America/Cayman=EST5\n"
  "America/Chicago=CST6CDT,M3.2.0,M11.1.0\n"
  "America/Chihuahua=CST6\n"
  "America/Costa_Rica=CST6\n"
  "America/Creston=MST7\n"
  "America/Cuiaba=<-04>4\n"
  "America/Curacao=AST4\n"
  "America/Danmarkshavn=GMT0\n"
  "America/Dawson=MST7\n"
  "America/Dawson_Creek=MST7\n"
  "America/Denver=MST7MDT,M3.2.0,M11.1.0\n"
  "America/Detroit=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Dominica=AST4\n"
  "America/Edmonton=MST7MDT,M3.2.0,M11.1.0\n"
  "America/Eirunepe=<-05>5\n"
  "America/El_Salvador=CST6\n"
  "America/Fort_Nelson=MST7\n"
  "America/Fortaleza=<-03>3\n"
  "America/Glace_Bay=AST4ADT,M3.2.0,M11.1.0\n"
  "America/Godthab=<-02>2<-01>,M3.5.0/-1,M10.5.0/0\n"
  "America/Goose_Bay=AST4ADT,M3.2.0,M11.1.0\n"
  "America/Grand_Turk=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Grenada=AST4\n"
  "America/Guadeloupe=AST4\n"
  "America/Guatemala=CST6\n"
  "America/Guayaquil=<-05>5\n"
  "America/Guyana=<-04>4\n"
  "America/Halifax=AST4ADT,M3.2.0,M11.1.0\n"
  "America/Havana=CST5CDT,M3.2.0/0,M11.1.0/1\n"
  "America/Hermosillo=MST7\n"
  "America/Indiana/Indianapolis=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Indiana/Knox=CST6CDT,M3.2.0,M11.1.0\n"
  "America/Indiana/Marengo=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Indiana/Petersburg=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Indiana/Tell_City=CST6CDT,M3.2.0,M11.1.0\n"
  "America/Indiana/Vevay=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Indiana/Vincennes=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Indiana/Winamac=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Inuvik=MST7MDT,M3.2.0,M11.1.0\n"
  "America/Iqaluit=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Jamaica=EST5\n"
  "America/Juneau=AKST9AKDT,M3.2.0,M11.1.0\n"
  "America/Kentucky/Louisville=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Kentucky/Monticello=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Kralendijk=AST4\n"
  "America/La_Paz=<-04>4\n"
  "America/Lima=<-05>5\n"
  "America/Los_Angeles=PST8PDT,M3.2.0,M11.1.0\n"
  "America/Lower_Princes=AST4\n"
  "America/Maceio=<-03>3\n"
  "America/Managua=CST6\n"
  "America/Manaus=<-04>4\n"
  "America/Marigot=AST4\n"
  "America/Martinique=AST4\n"
  "America/Matamoros=CST6CDT,M3.2.0,M11.1.0\n"
  "America/Mazatlan=MST7\n"
  "America/Menominee=CST6CDT,M3.2.0,M11.1.0\n"
  "America/Merida=CST6\n"
  "America/Metlakatla=AKST9AKDT,M3.2.0,M11.1.0\n"
  "America/Mexico_City=CST6\n"
  "America/Miquelon=<-03>3<-02>,M3.2.0,M11.1.0\n"
  "America/Moncton=AST4ADT,M3.2.0,M11.1.0\n"
  "America/Monterrey=CST6\n"
  "America/Montevideo=<-03>3\n"
  "America/Montreal=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Montserrat=AST4\n"
  "America/Nassau=EST5EDT,M3.2.0,M11.1.0\n"
  "America/New_York=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Nipigon=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Nome=AKST9AKDT,M3.2.0,M11.1.0\n"
  "America/Noronha=<-02>2\n"
  "America/North_Dakota/Beulah=CST6CDT,M3.2.0,M11.1.0\n"
  "America/North_Dakota/Center=CST6CDT,M3.2.0,M11.1.0\n"
  "America/North_Dakota/New_Salem=CST6CDT,M3.2.0,M11.1.0\n"
  "America/Nuuk=<-02>2<-01>,M3.5.0/-1,M10.5.0/0\n"
  "America/Ojinaga=CST6CDT,M3.2.0,M11.1.0\n"
  "America/Panama=EST5\n"
  "America/Pangnirtung=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Paramaribo=<-03>3\n"
  "America/Phoenix=MST7\n"
  "America/Port-au-Prince=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Port_of_Spain=AST4\n"
  "America/Porto_Velho=<-04>4\n"
  "America/Puerto_Rico=AST4\n"
  "America/Punta_Arenas=<-03>3\n"
  "America/Rainy_River=CST6CDT,M3.2.0,M11.1.0\n"
  "America/Rankin_Inlet=CST6CDT,M3.2.0,M11.1.0\n"
  "America/Recife=<-03>3\n"
  "America/Regina=CST6\n"
  "America/Resolute=CST6CDT,M3.2.0,M11.1.0\n"
  "America/Rio_Branco=<-05>5\n"
  "America/Santarem=<-03>3\n"
  "America/Santiago=<-04>4<-03>,M9.1.6/24,M4.1.6/24\n"
  "America/Santo_Domingo=AST4\n"
  "America/Sao_Paulo=<-03>3\n"
  "America/Scoresbysund=<-01>1<+00>,M3.5.0/0,M10.5.0/1\n"
  "America/Sitka=AKST9AKDT,M3.2.0,M11.1.0\n"
  "America/St_Barthelemy=AST4\n"
  "America/St_Johns=NST3:30NDT,M3.2.0,M11.1.0\n"
  "America/St_Kitts=AST4\n"
  "America/St_Lucia=AST4\n"
  "America/St_Thomas=AST4\n"
  "America/St_Vincent=AST4\n"
  "America/Swift_Current=CST6\n"
  "America/Tegucigalpa=CST6\n"
  "America/Thule=AST4ADT,M3.2.0,M11.1.0\n"
  "America/Thunder_Bay=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Tijuana=PST8PDT,M3.2.0,M11.1.0\n"
  "America/Toronto=EST5EDT,M3.2.0,M11.1.0\n"
  "America/Tortola=AST4\n"
  "America/Vancouver=PST8PDT,M3.2.0,M11.1.0\n"
  "America/Whitehorse=MST7\n"
  "America/Winnipeg=CST6CDT,M3.2.0,M11.1.0\n"
  "America/Yakutat=AKST9AKDT,M3.2.0,M11.1.0\n"
  "America/Yellowknife=MST7MDT,M3.2.0,M11.1.0\n"
  "Antarctica/Casey=<+11>-11\n"
  "Antarctica/Davis=<+07>-7\n"
  "Antarctica/DumontDUrville=<+10>-10\n"
  "Antarctica/Macquarie=AEST-10AEDT,M10.1.0,M4.1.0/3\n"
  "Antarctica/Mawson=<+05>-5\n"
  "Antarctica/McMurdo=NZST-12NZDT,M9.5.0,M4.1.0/3\n"
  "Antarctica/Palmer=<-03>3\n"
  "Antarctica/Rothera=<-03>3\n"
  "Antarctica/Syowa=<+03>-3\n"
  "Antarctica/Troll=<+00>0<+02>-2,M3.5.0/1,M10.5.0/3\n"
  "Antarctica/Vostok=<+06>-6\n"
  "Arctic/Longyearbyen=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Asia/Aden=<+03>-3\n"
  "Asia/Almaty=<+06>-6\n"
  "Asia/Amman=<+03>-3\n"
  "Asia/Anadyr=<+12>-12\n"
  "Asia/Aqtau=<+05>-5\n"
  "Asia/Aqtobe=<+05>-5\n"
  "Asia/Ashgabat=<+05>-5\n"
  "Asia/Atyrau=<+05>-5\n"
  "Asia/Baghdad=<+03>-3\n"
  "Asia/Bahrain=<+03>-3\n"
  "Asia/Baku=<+04>-4\n"
  "Asia/Bangkok=<+07>-7\n"
  "Asia/Barnaul=<+07>-7\n"
  "Asia/Beirut=EET-2EEST,M3.5.0/0,M10.5.0/0\n"
  "Asia/Bishkek=<+06>-6\n"
  "Asia/Brunei=<+08>-8\n"
  "Asia/Chita=<+09>-9\n"
  "Asia/Choibalsan=<+08>-8\n"
  "Asia/Colombo=<+0530>-5:30\n"
  "Asia/Damascus=<+03>-3\n"
  "Asia/Dhaka=<+06>-6\n"
  "Asia/Dili=<+09>-9\n"
  "Asia/Dubai=<+04>-4\n"
  "Asia/Dushanbe=<+05>-5\n"
  "Asia/Famagusta=EET-2EEST,M3.5.0/3,M10.5.0/4\n"
  "Asia/Gaza=EET-2EEST,M3.4.4/50,M10.4.4/50\n"
  "Asia/Hebron=EET-2EEST,M3.4.4/50,M10.4.4/50\n"
  "Asia/Ho_Chi_Minh=<+07>-7\n"
  "Asia/Hong_Kong=HKT-8\n"
  "Asia/Hovd=<+07>-7\n"
  "Asia/Irkutsk=<+08>-8\n"
  "Asia/Jakarta=WIB-7\n"
  "Asia/Jayapura=WIT-9\n"
  "Asia/Jerusalem=IST-2IDT,M3.4.4/26,M10.5.0\n"
  "Asia/Kabul=<+0430>-4:30\n"
  "Asia/Kamchatka=<+12>-12\n"
  "Asia/Karachi=PKT-5\n"
  "Asia/Kathmandu=<+0545>-5:45\n"
  "Asia/Khandyga=<+09>-9\n"
  "Asia/Kolkata=IST-5:30\n"
  "Asia/Krasnoyarsk=<+07>-7\n"
  "Asia/Kuala_Lumpur=<+08>-8\n"
  "Asia/Kuching=<+08>-8\n"
  "Asia/Kuwait=<+03>-3\n"
  "Asia/Macau=CST-8\n"
  "Asia/Magadan=<+11>-11\n"
  "Asia/Makassar=WITA-8\n"
  "Asia/Manila=PST-8\n"
  "Asia/Muscat=<+04>-4\n"
  "Asia/Nicosia=EET-2EEST,M3.5.0/3,M10.5.0/4\n"
  "Asia/Novokuznetsk=<+07>-7\n"
  "Asia/Novosibirsk=<+07>-7\n"
  "Asia/Omsk=<+06>-6\n"
  "Asia/Oral=<+05>-5\n"
  "Asia/Phnom_Penh=<+07>-7\n"
  "Asia/Pontianak=WIB-7\n"
  "Asia/Pyongyang=KST-9\n"
  "Asia/Qatar=<+03>-3\n"
  "Asia/Qyzylorda=<+05>-5\n"
  "Asia/Riyadh=<+03>-3\n"
  "Asia/Sakhalin=<+11>-11\n"
  "Asia/Samarkand=<+05>-5\n"
  "Asia/Seoul=KST-9\n"
  "Asia/Shanghai=CST-8\n"
  "Asia/Singapore=<+08>-8\n"
  "Asia/Srednekolymsk=<+11>-11\n"
  "Asia/Taipei=CST-8\n"
  "Asia/Tashkent=<+05>-5\n"
  "Asia/Tbilisi=<+04>-4\n"
  "Asia/Tehran=<+0330>-3:30\n"
  "Asia/Thimphu=<+06>-6\n"
  "Asia/Tokyo=JST-9\n"
  "Asia/Tomsk=<+07>-7\n"
  "Asia/Ulaanbaatar=<+08>-8\n"
  "Asia/Urumqi=<+06>-6\n"
  "Asia/Ust-Nera=<+10>-10\n"
  "Asia/Vientiane=<+07>-7\n"
  "Asia/Vladivostok=<+10>-10\n"
  "Asia/Yakutsk=<+09>-9\n"
  "Asia/Yangon=<+0630>-6:30\n"
  "Asia/Yekaterinburg=<+05>-5\n"
  "Asia/Yerevan=<+04>-4\n"
  "Atlantic/Azores=<-01>1<+00>,M3.5.0/0,M10.5.0/1\n"
  "Atlantic/Bermuda=AST4ADT,M3.2.0,M11.1.0\n"
  "Atlantic/Canary=WET0WEST,M3.5.0/1,M10.5.0\n"
  "Atlantic/Cape_Verde=<-01>1\n"
  "Atlantic/Faroe=WET0WEST,M3.5.0/1,M10.5.0\n"
  "Atlantic/Madeira=WET0WEST,M3.5.0/1,M10.5.0\n"
  "Atlantic/Reykjavik=GMT0\n"
  "Atlantic/South_Georgia=<-02>2\n"
  "Atlantic/St_Helena=GMT0\n"
  "Atlantic/Stanley=<-03>3\n"
  "Australia/Adelaide=ACST-9:30ACDT,M10.1.0,M4.1.0/3\n"
  "Australia/Brisbane=AEST-10\n"
  "Australia/Broken_Hill=ACST-9:30ACDT,M10.1.0,M4.1.0/3\n"
  "Australia/Currie=AEST-10AEDT,M10.1.0,M4.1.0/3\n"
  "Australia/Darwin=ACST-9:30\n"
  "Australia/Eucla=<+0845>-8:45\n"
  "Australia/Hobart=AEST-10AEDT,M10.1.0,M4.1.0/3\n"
  "Australia/Lindeman=AEST-10\n"
  "Australia/Lord_Howe=<+1030>-10:30<+11>-11,M10.1.0,M4.1.0\n"
  "Australia/Melbourne=AEST-10AEDT,M10.1.0,M4.1.0/3\n"
  "Australia/Perth=AWST-8\n"
  "Australia/Sydney=AEST-10AEDT,M10.1.0,M4.1.0/3\n"
  "Etc/GMT=GMT0\n"
  "Etc/GMT+0=GMT0\n"
  "Etc/GMT+1=<-01>1\n"
  "Etc/GMT+10=<-10>10\n"
  "Etc/GMT+11=<-11>11\n"
  "Etc/GMT+12=<-12>12\n"
  "Etc/GMT+2=<-02>2\n"
  "Etc/GMT+3=<-03>3\n"
  "Etc/GMT+4=<-04>4\n"
  "Etc/GMT+5=<-05>5\n"
  "Etc/GMT+6=<-06>6\n"
  "Etc/GMT+7=<-07>7\n"
  "Etc/GMT+8=<-08>8\n"
  "Etc/GMT+9=<-09>9\n"
  "Etc/GMT-0=GMT0\n"
  "Etc/GMT-1=<+01>-1\n"
  "Etc/GMT-10=<+10>-10\n"
  "Etc/GMT-11=<+11>-11\n"
  "Etc/GMT-12=<+12>-12\n"
  "Etc/GMT-13=<+13>-13\n"
  "Etc/GMT-14=<+14>-14\n"
  "Etc/GMT-2=<+02>-2\n"
  "Etc/GMT-3=<+03>-3\n"
  "Etc/GMT-4=<+04>-4\n"
  "Etc/GMT-5=<+05>-5\n"
  "Etc/GMT-6=<+06>-6\n"
  "Etc/GMT-7=<+07>-7\n"
  "Etc/GMT-8=<+08>-8\n"
  "Etc/GMT-9=<+09>-9\n"
  "Etc/GMT0=GMT0\n"
  "Etc/Greenwich=GMT0\n"
  "Etc/UCT=UTC0\n"
  "Etc/UTC=UTC0\n"
  "Etc/Universal=UTC0\n"
  "Etc/Zulu=UTC0\n"
  "Europe/Amsterdam=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Andorra=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Astrakhan=<+04>-4\n"
  "Europe/Athens=EET-2EEST,M3.5.0/3,M10.5.0/4\n"
  "Europe/Belgrade=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Berlin=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Bratislava=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Brussels=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Bucharest=EET-2EEST,M3.5.0/3,M10.5.0/4\n"
  "Europe/Budapest=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Busingen=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Chisinau=EET-2EEST,M3.5.0,M10.5.0/3\n"
  "Europe/Copenhagen=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Dublin=IST-1GMT0,M10.5.0,M3.5.0/1\n"
  "Europe/Gibraltar=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Guernsey=GMT0BST,M3.5.0/1,M10.5.0\n"
  "Europe/Helsinki=EET-2EEST,M3.5.0/3,M10.5.0/4\n"
  "Europe/Isle_of_Man=GMT0BST,M3.5.0/1,M10.5.0\n"
  "Europe/Istanbul=<+03>-3\n"
  "Europe/Jersey=GMT0BST,M3.5.0/1,M10.5.0\n"
  "Europe/Kaliningrad=EET-2\n"
  "Europe/Kiev=EET-2EEST,M3.5.0/3,M10.5.0/4\n"
  "Europe/Kirov=MSK-3\n"
  "Europe/Lisbon=WET0WEST,M3.5.0/1,M10.5.0\n"
  "Europe/Ljubljana=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/London=GMT0BST,M3.5.0/1,M10.5.0\n"
  "Europe/Luxembourg=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Madrid=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Malta=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Mariehamn=EET-2EEST,M3.5.0/3,M10.5.0/4\n"
  "Europe/Minsk=<+03>-3\n"
  "Europe/Monaco=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Moscow=MSK-3\n"
  "Europe/Oslo=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Paris=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Podgorica=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Prague=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Riga=EET-2EEST,M3.5.0/3,M10.5.0/4\n"
  "Europe/Rome=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Samara=<+04>-4\n"
  "Europe/San_Marino=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Sarajevo=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Saratov=<+04>-4\n"
  "Europe/Simferopol=MSK-3\n"
  "Europe/Skopje=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Sofia=EET-2EEST,M3.5.0/3,M10.5.0/4\n"
  "Europe/Stockholm=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Tallinn=EET-2EEST,M3.5.0/3,M10.5.0/4\n"
  "Europe/Tirane=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Ulyanovsk=<+04>-4\n"
  "Europe/Uzhgorod=EET-2EEST,M3.5.0/3,M10.5.0/4\n"
  "Europe/Vaduz=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Vatican=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Vienna=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Vilnius=EET-2EEST,M3.5.0/3,M10.5.0/4\n"
  "Europe/Volgograd=MSK-3\n"
  "Europe/Warsaw=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Zagreb=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Europe/Zaporozhye=EET-2EEST,M3.5.0/3,M10.5.0/4\n"
  "Europe/Zurich=CET-1CEST,M3.5.0,M10.5.0/3\n"
  "Indian/Antananarivo=EAT-3\n"
  "Indian/Chagos=<+06>-6\n"
  "Indian/Christmas=<+07>-7\n"
  "Indian/Cocos=<+0630>-6:30\n"
  "Indian/Comoro=EAT-3\n"
  "Indian/Kerguelen=<+05>-5\n"
  "Indian/Mahe=<+04>-4\n"
  "Indian/Maldives=<+05>-5\n"
  "Indian/Mauritius=<+04>-4\n"
  "Indian/Mayotte=EAT-3\n"
  "Indian/Reunion=<+04>-4\n"
  "Pacific/Apia=<+13>-13\n"
  "Pacific/Auckland=NZST-12NZDT,M9.5.0,M4.1.0/3\n"
  "Pacific/Bougainville=<+11>-11\n"
  "Pacific/Chatham=<+1245>-12:45<+1345>,M9.5.0/2:45,M4.1.0/3:45\n"
  "Pacific/Chuuk=<+10>-10\n"
  "Pacific/Easter=<-06>6<-05>,M9.1.6/22,M4.1.6/22\n"
  "Pacific/Efate=<+11>-11\n"
  "Pacific/Enderbury=<+13>-13\n"
  "Pacific/Fakaofo=<+13>-13\n"
  "Pacific/Fiji=<+12>-12\n"
  "Pacific/Funafuti=<+12>-12\n"
  "Pacific/Galapagos=<-06>6\n"
  "Pacific/Gambier=<-09>9\n"
  "Pacific/Guadalcanal=<+11>-11\n"
  "Pacific/Guam=ChST-10\n"
  "Pacific/Honolulu=HST10\n"
  "Pacific/Kiritimati=<+14>-14\n"
  "Pacific/Kosrae=<+11>-11\n"
  "Pacific/Kwajalein=<+12>-12\n"
  "Pacific/Majuro=<+12>-12\n"
  "Pacific/Marquesas=<-0930>9:30\n"
  "Pacific/Midway=SST11\n"
  "Pacific/Nauru=<+12>-12\n"
  "Pacific/Niue=<-11>11\n"
  "Pacific/Norfolk=<+11>-11<+12>,M10.1.0,M4.1.0/3\n"
  "Pacific/Noumea=<+11>-11\n"
  "Pacific/Pago_Pago=SST11\n"
  "Pacific/Palau=<+09>-9\n"
  "Pacific/Pitcairn=<-08>8\n"
  "Pacific/Pohnpei=<+11>-11\n"
  "Pacific/Port_Moresby=<+10>-10\n"
  "Pacific/Rarotonga=<-10>10\n"
  "Pacific/Saipan=ChST-10\n"
  "Pacific/Tahiti=<-10>10\n"
  "Pacific/Tarawa=<+12>-12\n"
  "Pacific/Tongatapu=<+13>-13\n"
  "Pacific/Wake=<+12>-12\n"
  "Pacific/Wallis=<+12>-12\n"};
