/*----------------------------------------------------------------------------/
  Lovyan GFX - Graphics library for embedded devices.

Original Source:
 https://github.com/lovyan03/LovyanGFX/

Licence:
 [FreeBSD](https://github.com/lovyan03/LovyanGFX/blob/master/license.txt)

Author:
 [lovyan03](https://twitter.com/lovyan03)

Contributors:
 [ciniml](https://github.com/ciniml)
 [mongonta0716](https://github.com/mongonta0716)
 [tobozo](https://github.com/tobozo)
/----------------------------------------------------------------------------*/
#pragma once

#include "Panel_DSI.hpp"
#if SOC_MIPI_DSI_SUPPORTED

namespace lgfx
{
 inline namespace v1
 {
//----------------------------------------------------------------------------

  struct Panel_ST7123 : public Panel_DSI
  {
  public:
  protected:

    const uint8_t* getInitParams(size_t listno) const override
    {
      static constexpr uint8_t list0[] =
      {//len(cmd+params), cmd, params

        4,  0x60,  0x71, 0x23, 0xa2,
        4,  0x60,  0x71, 0x23, 0xa3,
        4,  0x60,  0x71, 0x23, 0xa4,
        2,  0xA4,  0x31,

        7,  0xD7,  0x10, 0x0A, 0x10, 0x2A, 0x80,  0x80,
        8,  0x90,  0x71, 0x23, 0x5A, 0x20, 0x24,  0x09, 0x09,

// TODO:Check Params
        40, 0xA3,  0x80, 0x01, 0x88, 0x30, 0x05,  0x00, 0x00, 0x00, 0x00, 0x00,
                   0x46, 0x00, 0x00, 0x1E, 0x5C,  0x1E, 0x80, 0x00, 0x4F, 0x05,
                   0x00, 0x00, 0x00, 0x00, 0x00,  0x46, 0x00, 0x00, 0x1E, 0x5C,
                   0x1E, 0x80, 0x00, 0x6F, 0x58,  0x00, 0x00, 0x00, 0xFF,

        56, 0xA6,  0x03, 0x00, 0x24, 0x55, 0x36,  0x00, 0x39, 0x00, 0x6E, 0x6E,
                   0x91, 0xFF, 0x00, 0x24, 0x55,  0x38, 0x00, 0x37, 0x00, 0x6E,
                   0x6E, 0x91, 0xFF, 0x00, 0x24,  0x11, 0x00, 0x00, 0x00, 0x00,
                   0x6E, 0x6E, 0x91, 0xFF, 0x00,  0xEC, 0x11, 0x00, 0x03, 0x00,
                   0x03, 0x6E, 0x6E, 0xFF, 0xFF,  0x00, 0x08, 0x80, 0x08, 0x80,
                   0x06, 0x00, 0x00, 0x00, 0x00,

        61, 0xA7,  0x19, 0x19, 0x80, 0x64, 0x40,  0x07, 0x16, 0x40, 0x00, 0x44,
                   0x03, 0x6E, 0x6E, 0x91, 0xFF,  0x08, 0x80, 0x64, 0x40, 0x25,
                   0x34, 0x40, 0x00, 0x02, 0x01,  0x6E, 0x6E, 0x91, 0xFF, 0x08,
                   0x80, 0x64, 0x40, 0x00, 0x00,  0x40, 0x00, 0x00, 0x00, 0x6E,
                   0x6E, 0x91, 0xFF, 0x08, 0x80,  0x64, 0x40, 0x00, 0x00, 0x00,
                   0x00, 0x20, 0x00, 0x6E, 0x6E,  0x84, 0xFF, 0x08, 0x80, 0x44,

        45, 0xAC,  0x03, 0x19, 0x19, 0x18, 0x18,  0x06, 0x13, 0x13, 0x11, 0x11,
                   0x08, 0x08, 0x0A, 0x0A, 0x1C,  0x1C, 0x07, 0x07, 0x00, 0x00,
                   0x02, 0x02, 0x01, 0x19, 0x19,  0x18, 0x18, 0x06, 0x12, 0x12,
                   0x10, 0x10, 0x09, 0x09, 0x0B,  0x0B, 0x1C, 0x1C, 0x07, 0x07,
                   0x03, 0x03, 0x01, 0x01,

        26, 0xAD,  0xF0, 0x00, 0x46, 0x00, 0x03,  0x50, 0x50, 0xFF, 0xFF, 0xF0,
                   0x40, 0x06, 0x01, 0x07, 0x42,  0x42, 0xFF, 0xFF, 0x01, 0x00,
                   0x00, 0xFF, 0xFF, 0xFF, 0xFF,

         8, 0xAE,  0xFE, 0x3F, 0x3F, 0xFE, 0x3F, 0x3F, 0x00,
        18, 0xB2,  0x15, 0x19, 0x05, 0x23, 0x49,  0xAF, 0x03, 0x2E, 0x5C, 0xD2,
                   0xFF, 0x10, 0x20, 0xFD, 0x20,  0xC0, 0x00,

// TODO:Check Params
        15, 0xE8,  0x20, 0x6F, 0x04, 0x97, 0x97,  0x3E, 0x04, 0xDC, 0xDC, 0x3E,
                   0x06, 0xFA, 0x26, 0x3E,

         3, 0x75,  0x03, 0x04,
        37, 0xE7,  0x3B, 0x00, 0x00, 0x7C, 0xA1,  0x8C, 0x20, 0x1A, 0xF0, 0xB1,
                   0x50, 0x00, 0x50, 0xB1, 0x50,  0xB1, 0x50, 0xD8, 0x00, 0x55,
                   0x00, 0xB1, 0x00, 0x45, 0xC9,  0x6A, 0xFF, 0x5A, 0xD8, 0x18,
                   0x88, 0x15, 0xB1, 0x01, 0x01,  0x77,

         9, 0xEA,  0x13, 0x00, 0x04, 0x00, 0x00,  0x00, 0x00, 0x2C,
         8, 0xB0,  0x22, 0x43, 0x11, 0x61, 0x25,  0x43, 0x43,
         5, 0xb7,  0x00, 0x00, 0x73, 0x73,
         3, 0xBF,  0xA6, 0XAA,
        11, 0xA9,  0x00, 0x00, 0x73, 0xFF, 0x00,  0x00, 0x03, 0x00, 0x00, 0x03,
        38, 0xC8,  0x00, 0x00, 0x10, 0x1F, 0x36,  0x00, 0x5D, 0x04, 0x9D, 0x05,
                   0x10, 0xF2, 0x06, 0x60, 0x03,  0x11, 0xAD, 0x00, 0xEF, 0x01,
                   0x22, 0x2E, 0x0E, 0x74, 0x08,  0x32, 0xDC, 0x09, 0x33, 0x0F,
                   0xF3, 0x77, 0x0D, 0xB0, 0xDC,  0x03, 0xFF,
        38, 0xC9,  0x00, 0x00, 0x10, 0x1F, 0x36,  0x00, 0x5D, 0x04, 0x9D, 0x05,
                   0x10, 0xF2, 0x06, 0x60, 0x03,  0x11, 0xAD, 0x00, 0xEF, 0x01,
                   0x22, 0x2E, 0x0E, 0x74, 0x08,  0x32, 0xDC, 0x09, 0x33, 0x0F,
                   0xF3, 0x77, 0x0D, 0xB0, 0xDC,  0x03, 0xFF,
         0, // end
      };

      static constexpr uint8_t list1[] =
      {//len(cmd+params), cmd, params
        //  2, 0x36,  0x00,
         1,  CMD_DISPON,
         2, 0x35,  0x00,
         1,  CMD_SLPOUT, // SLPOUT
         0, // end
      };

      switch (listno)
      {
      case 0: return list0;
      case 1: return list1;
      default: return nullptr;
      }
    }

    size_t getInitDelay(size_t listno) const override
    {
      switch (listno)
      {
      case 1: return 120; // after SLPOUT
      default: return 0;
      }
    }
  };

//----------------------------------------------------------------------------
 }
}

#endif
