/*
 * SPDX-FileCopyrightText: 2024 M5Stack Technology CO LTD
 *
 * SPDX-License-Identifier: MIT
 */

/*
 * @file camera.ino
 * @author SeanKwok (shaoxiang@m5stack.com)
 * @brief M5CoreS3 Camera Test
 * @version 0.1
 * @date 2023-12-25
 *
 *
 * @Hardwares: M5CoreS3
 * @Platform Version: Arduino M5Stack Board Manager v2.0.9
 * @Dependent Library:
 * M5GFX: https://github.com/m5stack/M5GFX
 * M5Unified: https://github.com/m5stack/M5Unified
 * M5CoreS3: https://github.com/m5stack/M5CoreS3
 */
#include "M5CoreS3.h"

#include "esp_camera.h"

// #define CONVERT_TO_JPEG

void setup()
{
    auto cfg = M5.config();
    CoreS3.begin(cfg);
    CoreS3.Display.setTextColor(GREEN);
    CoreS3.Display.setTextDatum(middle_center);
    CoreS3.Display.setFont(&fonts::Orbitron_Light_24);
    CoreS3.Display.setTextSize(1);

    if (!CoreS3.Camera.begin()) {
        CoreS3.Display.drawString("Camera Init Fail", CoreS3.Display.width() / 2, CoreS3.Display.height() / 2);
    }
    CoreS3.Display.drawString("Camera Init Success", CoreS3.Display.width() / 2, CoreS3.Display.height() / 2);
}

void loop()
{
    if (CoreS3.Camera.get()) {
#ifdef CONVERT_TO_JPEG
        uint8_t *out_jpg   = NULL;
        size_t out_jpg_len = 0;
        frame2jpg(CoreS3.Camera.fb, 255, &out_jpg, &out_jpg_len);
        CoreS3.Display.drawJpg(out_jpg, out_jpg_len, 0, 0, CoreS3.Display.width(), CoreS3.Display.height());
        free(out_jpg);
#else
        CoreS3.Display.pushImage(0, 0, CoreS3.Display.width(), CoreS3.Display.height(),
                                 (uint16_t *)CoreS3.Camera.fb->buf);
#endif

        CoreS3.Camera.free();
    }
}
