# M5Core2 Library

[![Arduino Compile](https://github.com/m5stack/M5Core2/actions/workflows/arduino-action-compile.yml/badge.svg)](https://github.com/m5stack/M5Core2/actions/workflows/arduino-action-compile.yml)
[![Arduino Lint](https://github.com/m5stack/M5Core2/actions/workflows/Arduino-Lint-Check.yml/badge.svg)](https://github.com/m5stack/M5Core2/actions/workflows/Arduino-Lint-Check.yml)
[![Clang Format](https://github.com/m5stack/M5Core2/actions/workflows/clang-format-check.yml/badge.svg)](https://github.com/m5stack/M5Core2/actions/workflows/clang-format-check.yml)

中文 | [English](README_cn.md)

<img src="https://static-cdn.m5stack.com/resource/docs/static/assets/img/product_pics/core/core2/core2_01.webp" alt="M5Core2_P1" width="350" height="350">

* **如果查看 M5Core2 的详细介绍文档，[点击这里](https://docs.m5stack.com/zh_CN/core/core2)**

* **如果想要购买 M5Core2 的话，[点击这里](https://item.taobao.com/item.htm?spm=a1z10.5-c-s.w4002-22404213529.31.5ada1d91KUL15v&id=625561056791)**

## 描述

**M5Core2** 是M5Stack开发套件系列中第二代主机，在原有一代主机基础上对功能进一步加强，硬件功能更加齐全。主控ESP32型号为D0WDQ6-V3，具有两个可以单独控制的 Xtensa® 32-bit LX6 处理器，主频高达240Mhz，支持WiFi与蓝牙功能，板载16MB Flash与8MB PSRAM，可通过TYPE-C接口下载程序，强劲的配置满足复杂应用的资源开销。正面搭载一块2.0寸一体化电容式触摸屏，为用户带来更流畅的人机交互体验。机身内置震动马达，可提供触觉回馈和震动提醒功能。内建的RTC模块可提供精准计时功能。电源部分搭载AXP192电源管理芯片可有效控制机身功耗，内置绿色电源指示灯，配备390mAh电池，续航时间更持久。同时机身内配备了SD卡槽与扬声器，为了保证获得更高质量的声音效果，采用I2S数字音频接口的功放芯片，能有效防止信号失真。在机身的左侧和底部配有独立的电源按键与重启(RST)按键，屏幕正面的3个圆点属于触摸屏的一部分，可通过编写程序设置热区映射为3个虚拟按键。机身背部有一块扩展小板，板上带有6轴IMU传感器与麦克风。

## M5Core2 M-BUS示意图

<img src="https://static-cdn.m5stack.com/resource/docs/static/assets/img/product_pics/core/core2/core2_mbus.webp" width = "50%">


## 更多信息

**UIFlow 快速上手**: [点击这里](https://docs.m5stack.com/zh_CN/quick_start/core2/uiflow)

**MicroPython API**: [点击这里](https://docs.m5stack.com/zh_CN/quick_start/core2/mpy)

**Arduino IDE 环境搭建**: [点击这里](https://docs.m5stack.com/zh_CN/quick_start/core2/arduino)

**M5Core2 Arduino API**: [点击这里](https://docs.m5stack.com/zh_CN/api/core2/axp192_core2)

**引脚地图**: [点击这里](https://docs.m5stack.com/zh_CN/core/core2)
