# Chain Joystick

## Overview
Chain Joystick is a high‑precision Hall‑effect joystick input node in the M5Stack Chain series.
It supports three‑axis control signal input, including analog inputs for the X and Y axes and a digital button input for the Z axis.
The device adopts a Hall‑effect joystick, which achieves high‑precision control by detecting changes in the magnetic field.
It features a contactless design, high durability, excellent precision, and strong anti‑interference capability, ensuring product stability and long service life.
An integrated programmable RGB LED is included for status indication and interactive display.
It is suitable for applications such as human‑machine interaction and robot control.

### SKU: U205

## Related Link
https://docs.m5stack.com/en/products/sku/U205

# Chain Key

## Overview
Chain Key is a single‑button input node in the M5Stack Chain series.
The button adopts a hot‑swappable mechanical keyboard switch design, featuring a tactile Blue switch with a distinct click feel, and also integrates a programmable RGB LED.
It is suitable for applications such as human‑machine interaction and smart home control.

### SKU: U206

## Related Link
https://docs.m5stack.com/en/products/sku/U206

## License
- [MIT](https://github.com/m5stack/M5Chain/blob/main/LICENSE)

# Chain Encoder

## Overview
Chain Encoder is a rotary encoder input node in the M5Stack Chain series. It integrates an AB rotary encoder internally, supporting rotation direction detection and pulse counting, and the center of the knob supports button input. It also integrates a programmable RGB LED for status indication and interactive display. The encoder cap features LEGO-compatible mounting holes, enabling more creative structural connections. It is suitable for applications such as human–machine interaction and smart home control.

Chain Encoder integrates the STM32G031G8U6 core controller and adopts a UART serial daisy-chain communication protocol. Through two HY2.0-4P expansion interfaces, it can expand additional Chain series devices to build richer interactive applications.

### SKU: U207

## Related Link
https://docs.m5stack.com/en/products/sku/U207

## License
- [MIT](https://github.com/m5stack/M5Chain/blob/main/LICENSE)

# Chain Angle

## Overview
Chain Angle is a potentiometer knob input node in the M5Stack Chain series. As the potentiometer knob rotates, the voltage value at the sampling terminal varies within a fixed range. After ADC conversion by the built-in MCU, a signal value with up to 12-bit resolution is output. It also integrates a programmable RGB LED for status indication and interactive display. It is suitable for applications such as human-machine interfaces, smart home systems, and motor speed control.

Chain Angle integrates an STM32G031G8U6 core MCU and uses a UART serial cascade communication protocol. Through two HY2.0-4P expansion interfaces, more Chain series devices can be connected to build richer interactive applications.

### SKU: U208

## Related Link
https://docs.m5stack.com/en/products/sku/U208

## License
- [MIT](https://github.com/m5stack/M5Chain/blob/main/LICENSE)

# Chain ToF

## Overview
Chain ToF is a laser ranging sensor node in the M5Stack Chain series. The device integrates a VL53L0C laser ranging module, supporting a distance measurement range of 3 ~ 200cm with an accuracy of ±3%. It is suitable for short-range non-contact distance measurement and object proximity detection applications. Chain ToF integrates an STM32G031G8U6 core MCU and adopts a UART daisy-chain communication protocol. With two HY2.0-4P expansion interfaces, it can be extended with additional Chain series devices to build richer interactive applications.

### SKU: U209

## Related Link
https://docs.m5stack.com/en/products/sku/U209

## License
- [MIT](https://github.com/m5stack/M5Chain/blob/main/LICENSE)

# Unit ChainBus

## Overview
Unit ChainBus is a Chain series communication protocol conversion unit. It integrates an STM32G031G8U6 chip and uses a UART daisy-chain communication protocol to enable chained connections of multiple devices. It supports multiple protocol interface conversions, allowing various peripherals to be expanded on the same bus, and integrates hardware control and data interaction capabilities.

The UART interfaces on the left and right sides are used to connect Chain series devices, supporting device UID query, version query, link device enumeration, heartbeat communication, and more. The top multifunction expansion interface can be used to extend Unit series devices, supporting I2C communication control, GPIO management (input and output), ADC sampling, and NVIC interrupt management. It is suitable for industrial control, IoT, smart home, and other application scenarios, providing an effective solution for unified control and data interaction of multiple devices.

### SKU: U212

## Related Link
https://docs.m5stack.com/en/products/sku/U212

## License
- [MIT](https://github.com/m5stack/M5Chain/blob/main/LICENSE)