# Chain Joystick

## Overview
Chain Joystick is a high‑precision Hall‑effect joystick input node in the M5Stack Chain series.
It supports three‑axis control signal input, including analog inputs for the X and Y axes and a digital button input for the Z axis.
The device adopts a Hall‑effect joystick, which achieves high‑precision control by detecting changes in the magnetic field.
It features a contactless design, high durability, excellent precision, and strong anti‑interference capability, ensuring product stability and long service life.
An integrated programmable RGB LED is included for status indication and interactive display.
It is suitable for applications such as human‑machine interaction and robot control.

### SKU: U205

## Related Link
https://docs.m5stack.com/en/products/sku/U205

# Chain Key

## Overview
Chain Key is a single‑button input node in the M5Stack Chain series.
The button adopts a hot‑swappable mechanical keyboard switch design, featuring a tactile Blue switch with a distinct click feel, and also integrates a programmable RGB LED.
It is suitable for applications such as human‑machine interaction and smart home control.

### SKU: U206

## Related Link
https://docs.m5stack.com/en/products/sku/U206

## License
- [MIT](https://github.com/m5stack/M5Chain/blob/main/LICENSE)

# Chain Encoder

## Overview
Chain Encoder is a rotary encoder input node in the M5Stack Chain series. It integrates an AB rotary encoder internally, supporting rotation direction detection and pulse counting, and the center of the knob supports button input. It also integrates a programmable RGB LED for status indication and interactive display. The encoder cap features LEGO-compatible mounting holes, enabling more creative structural connections. It is suitable for applications such as human–machine interaction and smart home control.

Chain Encoder integrates the STM32G031G8U6 core controller and adopts a UART serial daisy-chain communication protocol. Through two HY2.0-4P expansion interfaces, it can expand additional Chain series devices to build richer interactive applications.

### SKU: U207

## Related Link
https://docs.m5stack.com/en/products/sku/U207

## License
- [MIT](https://github.com/m5stack/M5Chain/blob/main/LICENSE)

# Chain Angle

## Overview
Chain Angle is a potentiometer knob input node in the M5Stack Chain series. As the potentiometer knob rotates, the voltage value at the sampling terminal varies within a fixed range. After ADC conversion by the built-in MCU, a signal value with up to 12-bit resolution is output. It also integrates a programmable RGB LED for status indication and interactive display. It is suitable for applications such as human-machine interfaces, smart home systems, and motor speed control.

Chain Angle integrates an STM32G031G8U6 core MCU and uses a UART serial cascade communication protocol. Through two HY2.0-4P expansion interfaces, more Chain series devices can be connected to build richer interactive applications.

### SKU: U208

## Related Link
https://docs.m5stack.com/en/products/sku/U208

## License
- [MIT](https://github.com/m5stack/M5Chain/blob/main/LICENSE)