# AtomS3 Library

[![Arduino Compile](https://github.com/m5stack/M5AtomS3/actions/workflows/arduino-action-compile.yml/badge.svg)](https://github.com/m5stack/M5AtomS3/actions/workflows/arduino-action-compile.yml)
[![Arduino Lint](https://github.com/m5stack/M5AtomS3/actions/workflows/Arduino-Lint-Check.yml/badge.svg)](https://github.com/m5stack/M5AtomS3/actions/workflows/Arduino-Lint-Check.yml)
[![Clang Format](https://github.com/m5stack/M5AtomS3/actions/workflows/clang-format-check.yml/badge.svg)](https://github.com/m5stack/M5AtomS3/actions/workflows/clang-format-check.yml)

English | [中文](README_cn.md)

<img src="https://static-cdn.m5stack.com/resource/docs/products/core/AtomS3/img-91894638-80df-4827-892e-cb8f50cf1041.jpg" alt="M5Atom Lite" width="350" height="350">

* **For the Detailed documentation of AtomS3, please [Click here](https://docs.m5stack.com/en/core/AtomS3)**

## Description

`AtomS3` is a highly integrated programmable controller based on `ESP32-S3` main control, which integrates ESP32-S3 main control, integrated `WiFi` function, and `8M` on-chip FLASH; `0.85` inch `IPS screen`; `Programmable button function` at the bottom of the screen; Built-in 5V to 3.3V circuit, 6-axis gyro sensor `MPU6886`, on-board `Type-C` interface, power supply and firmware download, one `HY2.0-4P` expansion port, `6 GPIOs and power pins` reserved at the bottom to facilitate expansion applications. The product size is only `24*24mm`, which is suitable for various `embedded smart device applications`.

- `Reminder: If you need to burn the firmware, please press and hold the reset button (about 2 seconds) until the internal green LED lights up, then you can release it, at this time the device has entered download mode and waited for burning.`

## Applications

- Internet of things terminal controller
- IoT node
- Wearable peripherals

## PlatformIO Compilation

[Compilation File](https://github.com/m5stack/M5AtomS3/blob/main/platformio.ini)

## Schematic

<img alt="schematics" src="https://static-cdn.m5stack.com/resource/docs/products/core/AtomS3/img-b85e925c-adff-445d-994c-45987dc97a44.jpg" width="100%" />

## Module Size

<img alt="module size" src="https://static-cdn.m5stack.com/resource/docs/products/core/AtomS3/img-abe8d8b0-3d8c-4f42-a84a-093bfed0aa38.png" width="100%" />

## More Information

**Arduino IDE Development**: [Click Here](https://docs.m5stack.com/en/quick_start/atoms3/arduino)