# ATOM_DTU_LoRaWAN

## Overview

### Compatible Products: 

| SKU  | Name                |
|------|---------------------|
| K061 | Atom DTU LoRaWAN915 |
| K062 | Atom DTU LoRaWAN470 |
| K063 | Atom DTU LoRaWAN868 |

Please note that all products above (compatible with this library) are EOL. For new LoRaWAN products like Atom DTU LoRaWAN-US915 (A152-US915), please use [M5-LoRaWAN-RAK](https://github.com/m5stack/M5-LoRaWAN-RAK) library instead. 

Contains M5Stack-**Atom DTU LoRaWAN** series related case programs. The hardware is based on the ASR6501 series of modules to realize the LoRaWAN communication function. 

## Libraries

- [ArduinoModbus](https://github.com/m5stack/ArduinoModbus)
- [Arduino485](https://github.com/m5stack/ArduinoRS485)
- [M5-LoRaWAN](https://github.com/m5stack/M5-LoRaWAN) (Previously named `UNIT_LoRaWAN`)
- [M5Atom](https://github.com/m5stack/M5Atom)
- [FastLED](https://github.com/FastLED/FastLED)

## Related Link

[Document & AT Command Atom DTU LoRaWAN470](https://docs.m5stack.com/en/atom/atom_dtu_lorawan470)

[Document & AT Command Atom DTU LoRaWAN868](https://docs.m5stack.com/en/atom/atom_dtu_lorawan868)

[Document & AT Command Atom DTU LoRaWAN915](https://docs.m5stack.com/en/atom/atom_dtu_lorawan915)

## License

[ATOM DTU LoRaWAN - MIT](LICENSE)