LVGL uses the following third-party libraries.
For the licenses, see the corresponding `LICENSE.txt` file in each library’s folder.

**Barcode (Barcode generator)**
- Path: src/libs/barcode
- Source: https://github.com/fhunleth/code128

**Expat (XML parser)**
- Path: src/libs/expat
- Source: https://github.com/libexpat/libexpat

**FreeType (Font rendering library)**
- Path: src/libs/freetype
- Source: https://github.com/freetype/freetype
- Note: Only the interfaces are used; FreeType itself is not part of LVGL.

**LodePNG (PNG decoder)**
- Path: src/libs/lodepng
- Source: https://github.com/lvandeve/lodepng

**LZ4 (Compression/Decompression)**
- Path: src/libs/lz4
- Source: https://github.com/lz4/lz4

**QR Code (QR code generator)**
- Path: src/libs/qrcode
- Source: https://github.com/nayuki/QR-Code-generator

**ThorVG (Vector graphics rendering)**
- Path: src/libs/thorvg
- Source: https://github.com/thorvg/thorvg

**TinyTTF**
- Path: src/libs/tiny_ttf
- Source:
  - https://github.com/nothings/stb (*Only parts are integrated*)
  - https://github.com/codewitch-honey-crisis/tiny_ttf (*Modified version of the original STB library*)

**TJPGD (JPEG decoder)**
- Path: src/libs/tjpgd
- Source: http://elm-chan.org/fsw/tjpgd/00index.html

**TLSF (Two-Level Segregate Fit memory allocator)**
- Path: src/stdlib/builtin
- Source: https://github.com/mattconte/tlsf

**Printf (Printf formatting library)**
- Path: src/stdlib/builtin
- Source: https://github.com/mpaland/printf

**LVGL's XML format**
- Path:
    - docs/src/details/auxiliary-modules/xml
    - src/others/xml
    - xmls

**FT800-FT813 (EVE GPU driver)**
- Path src/libs/FT800-FT813
- Source: https://github.com/RudolphRiedel/FT800-FT813

**AnimatedGIF (GIF decoder library)**
- Path: src/libs/gif/AnimatedGIF
- Source: https://github.com/bitbank2/AnimatedGIF

**FrogFS (read-only filesystem)**
- Path: src/libs/frogfs
- Source: https://github.com/jkent/frogfs
