/*
 * This example sends back every buffer received over UART.
 *
 * !README!
 * The sketch is developed to perform UART tests between Arduino
 * and PC.
 * 1. Burn this program to Arduino
 * 2. Compile tiny_loopback tool (see tools folder) for your system
 * 3. Connect Arduino TX and RX lines to your PC com port
 * 4. Run tiny_loopback on the PC (use correct port name on your system)
 * 5. tiny_loopback will print the test speed results
 *
 * Also, this example demonstrates how to pass data between 2 systems
 * By default the sketch and tiny_loopback works as 115200 speed.
 */
#include <TinyProtocol.h>
// We need this hack for very small controllers.
#include <proto/fd/tiny_fd_int.h>

/* Creating protocol object is simple. Lets define 64 bytes as maximum. *
 * size for the packet and use 4 packets in outgoing queue.             */
tinyproto::Fd<FD_MIN_BUF_SIZE(64,4)>  proto;

void onReceive(void *udata, uint8_t addr, tinyproto::IPacket &pkt)
{
    if ( proto.write(pkt) == TINY_ERR_TIMEOUT )
    {
        // Do what you need to do if there is no place to put new frame to.
        // But never use blocking operations inside callback
    }
}

void setup()
{
    /* No timeout, since we want non-blocking UART operations. */
    Serial.setTimeout(0);
    /* Initialize serial protocol for test purposes */
    Serial.begin(115200);
    /* Lets use 8-bit checksum, available on all platforms */
    proto.enableCheckSum();
    /* Lets process all incoming frames */
    proto.setReceiveCallback( onReceive );
    /* Redirect all protocol communication to Serial0 UART */
    proto.begin();
}

void loop()
{
    if (Serial.available())
    {
        proto.run_rx([](void *p, void *b, int s)->int { return Serial.readBytes((uint8_t *)b, s); });
    }
    proto.run_tx([](void *p, const void *b, int s)->int { return Serial.write((const uint8_t *)b, s); });
}
