/*
  Copyright (c) 2025 Kay Kasper
  under the MIT License (MIT)
*/

#include <GeneralBuffer.h>
#include <GeneralBufferExtensions.h>

/*
  Simple example that puts values into the buffer
  in the setup and writes the content in the loop.
*/

#define CAPACITY 27
GeneralBuffer<byte> testBuffer(CAPACITY);
bool printed = false;


// the setup function is called once for initialization
void setup() {
  Serial.begin(9600);

  Serial.print("\r\nFilling the buffer with ");
  Serial.print(CAPACITY);
  Serial.println(" characters including '\\n':");

  for(byte i = 0 ; i < CAPACITY - 1 ; i++){
    testBuffer.putLastValue('A' + i, true);
  }
  testBuffer.putLastValue('\n', true);
}


// the loop function runs over and over again forever
void loop() {
  if(!printed){
    Serial.println("Printing buffer content:");
    printed = true;
  }

  if(testBuffer.hasValue()){
    Serial.print((char)testBuffer.getFirstValue());
  }
}


