# KK-Buffer
## Introduction
A library for a general buffer implementation, that is based on a template class and supports various value types. A second template type enables 2 maximum capacities for optimized performance.

The GeneralBuffer class is a feature rich implementation of a general usable buffer. For queues and stacks are the subclasses FIFO and LIFO with reduced functionality available.

The general buffer is implemented as a ring buffer, that supports the putting of values by one thread like an interrupt routine and the getting and handling of values by another thread like the loop without real conflicts.

Advantages

    • general use for temporary storage
    • value manipulation in order or out of order
    • access to all values at any time by direct addressing
    • template based for various storage types
    • template based for 2 different optimized maximum sizes
    • best performance up to 250 values capacity (type IND = uint8_t)
    • up to 16000 values capacity passible (type IND = uint16_t or int)
    • very high performance for most used functions
    • small footprint (RAM usage, minimum 8 bytes with IND = uint8_t) for each buffer instance
    • works with externaly defined or internally allocated storage
    • supports queues (FIFO) and stacks (LIFO)
    • supports up to 2 parallel threads (one putting and one getting values)
    • inserting, deleting and overwriting of values at any position in the buffer

## Installation
The library can be installed via Arduino Library Manager or by downloading the [archive](library/KK-Buffer.zip) from directory „library“ and unpacking the archive in IDEs libraries directory.

## Getting Started
Only a few lines of code are necessary to understand the logic behind:
```
#include <GeneralBuffer.h>
#include <GeneralBufferExtensions.h>

#define CAPACITY 27
GeneralBuffer<byte> testBuffer(CAPACITY);

void setup() {
  Serial.begin(9600);

  // fill the buffer with characters that shall be printed
  for(byte i=0 ; i<CAPACITY-1 ; i++){
    testBuffer.putLastValue('A' + i, true);
  }
  testBuffer.putLastValue('\n', true);
}

void loop() {
  // do what you want in the loop
  // and write one (the next) character at a loop() call

  if(testBuffer.hasValue()){
    Serial.print((char)testBuffer.getFirstValue());
  }
}
```

See the complete list of examples in the examples folder and in the [documentation](doc/KK-Buffer.pdf).
