#ifndef MAX7SegmentDisplay_h
#define MAX7SegmentDisplay_h

#if (defined(__AVR__))
#include <avr/pgmspace.h>
#else
#include <pgmspace.h>
#endif

#if (ARDUINO >= 100)
#include <Arduino.h>
#else
#include <WProgram.h>
#endif

const static byte charTable [] PROGMEM = {
    B01111110,B00110000,B01101101,B01111001,B00110011,B01011011,B01011111,B01110000,B01111111,B01111011
};

class MAX7SegmentDisplay
{
    private:
        int DIN_PIN;
        int CS_PIN;
        int CLK_PIN;
        int _digitLimit;
        bool reverseDirection;
        void table(byte address, int val);
    public:
        MAX7SegmentDisplay(int dinPin, int csPin, int clkPin);
        void setReverseDirection(bool rev);
        void setBright(int brightness);
        void setDigitLimit(int limit);
        void printDigit(long number, byte startDigit = 0);
        void write(byte address, byte data);
        void ReverseDirection();
        void clear();
        void on();
        void off();
};

#endif // MAX7SegmentDisplay_h
