# MCP4132 Arduino Library

This library provides a convenient interface to control the MCP4132 digital potentiometer using an Arduino or compatible microcontroller. The MCP4132 is a single-channel reostat with SPI communication, allowing for digital control of resistance values.

## Features
- SPI communication support
- Configurable resistance values (5kΩ, 10kΩ, 50kΩ, 100kΩ models)
- Control wiper position to adjust resistance
- Enable/disable wiper and terminal connections for power saving
- Reset functionality to restore default settings
- Get the current resistance or wiper position
- Set the desired resistance value in ohms
- Fully compatible with the Arduino ecosystem

## Requirements
- Arduino IDE version 1.8+ or PlatformIO
- Supported microcontrollers: Any with SPI capability (e.g., AVR, ESP32, STM32)

## Installation
1. Download the library.
2. Open the Arduino IDE.
3. Select the library in library manager.

