# Dallas DS3231

Senses

- [temperature](../parameters/temperature.md)

The DS3231 is a temperature-compensated real-time clock. As such it
provides a temperaure reading.

This chip is controlled via an I2C bus.


## Resources

- [Datasheet](https://www.analog.com/media/en/technical-documentation/data-sheets/ds3231.pdf)


## ESensors Software

The [TemperatureDS3231.h](../../src/TemperatureDS3231.h) header
declares the TemperatureDS3231 class derived from
[ESensor](../classes.md#esensor) supporting a DS3231 within the
[ESensors](../classes.md) framework.

```cpp
#include <Wire.h>
#include <TemperatureDS3231.h>

Temperature3231 temp;

void setup() {
  temp.begin(Wire);
}

void loop() {
  float T = temp.read();
}
```
