import argparse
import numpy as np
import pandas as pd
import datetime as dt
import matplotlib.pyplot as plt


def sensors(path):
    data = pd.read_csv(path, sep=',')
    tc = data.columns[0]
    data[tc] = pd.to_datetime(data[tc])
    data[tc] = pd.Series(data[tc].dt.to_pydatetime(), dtype=object)
    header = list(data)[1:]
    # plot data:
    colors = plt.rcParams['axes.prop_cycle'].by_key()['color']
    fig, axs = plt.subplots(len(header), 1, squeeze=False, sharex=True);
    for k, hn in enumerate(header):
        axs[k,0].plot(np.array(data[tc]), np.array(data[hn]),
                      '-', color=colors[k%len(colors)])
        name = hn
        unit = ''
        if '/' in hn:
            hnp = hn.split('/')
            name = hnp[0]
            unit = '/'.join(hnp[1:])
        if len(unit) > 0:
            if len(unit) > 2 and unit[-2] == '.':
                unit = unit[:-2]
            axs[k,0].set_ylabel('%s [%s]' % (name, unit))
        else:
            axs[k,0].set_ylabel(hn)
    plt.setp(axs[-1,0].get_xticklabels(), ha='right',
             rotation=30, rotation_mode='anchor')
    plt.show()
    

if __name__ == '__main__':
    # command line arguments:
    parser = argparse.ArgumentParser(add_help=True,
        description='Display sensor data.')
        #epilog='version %s by Benda-Lab (2015-%s)' % (__version__, __year__))
    #parser.add_argument('--version', action='version', version=__version__)
    parser.add_argument('file', nargs=1, type=str,
                        help='csv file containing the sensor data to be shown')
    args = parser.parse_args()
    # options:
    path = args.file[0]
    # run:
    sensors(path)
