# Bosch Sensortec BME280

Senses

- [temperature](../parameters/temperature.md)
- [humidity](../parameters/humidity.md)
- [air pressure](../parameters/airpressure.md)

This chip is controlled via an I2C or SPI bus.


## Resources

- [Bosch Sensortec Website](https://www.bosch-sensortec.com/products/environmental-sensors/humidity-sensors-bme280/)
- [Datasheet](https://www.bosch-sensortec.com/media/boschsensortec/downloads/datasheets/bst-bme280-ds002.pdf)
- [Driver](https://github.com/BoschSensortec/BME280_driver)

- I2C address is 0x77 !


## ESensors Software

The [SenseBME280.h](../../src/SenseBME280.h) header declares classes
supporting the BME280 within the [ESensors](../classes.md) framework.
It is based on the [SparkFun BME280
Library](https://github.com/sparkfun/SparkFun_BME280_Arduino_Library).

```cpp
#include<SenseBME280.h>
```

It provides the following classes:

### ESensor device

- `SenseBME280`

```cpp
SenseBME280 bme;

void setup() {
  Wire.begin();       // init the default I2C bus.
  bme.beginI2C(Wire, 0x77); // init the BME280 sensor on the defaul Wire I2C bus with address 0x77.
}
```

### ESensors

- `TemperatureBME280`: temperature in degree celsius.
- `HumidityBME280`: relative humidity.
- `PressureBME280`: air pressure in Pascal.

```cpp
TemperatureBME280 temp(&bme);
HumidityBME280 hum(&bme);
PressureBME280 pres(&bme);

void setup() {
  pres.setHecto();   // air pressure in hPa
}
```


## Hardware

- [BlueDot BME280+TSL2591 Advanced Weather Station](https://www.bluedot.space/products/bme280-tsl2591/)

  ![pinout](https://image.jimcdn.com/app/cms/image/transf/dimension=697x10000:format=png/path/s9044904ce8b43c5c/image/ic78b28bd0a4d9113/version/1525169534/i2c-wiring-for-bme280-tsl2591-board.png)

- [BlueDot BME280 Weather Station](https://www.bluedot.space/products/bme280/)

  ![pinout](https://image.jimcdn.com/app/cms/image/transf/dimension=697x10000:format=png/path/s9044904ce8b43c5c/image/id0c55c24650bbce2/version/1525168839/i2c-wiring-for-bluedot-bme280-board.png)

- [Adafruit BME280 Humidity + Barometric Pressure + Temperature Sensor Breakout](https://learn.adafruit.com/adafruit-bme280-humidity-barometric-pressure-temperature-sensor-breakout)

  ![pinout](https://cdn-learn.adafruit.com/assets/assets/000/026/680/medium800/sensors_pinout.jpg?1437768166)

- [Sensatio Bosch BME280](https://www.sensatio.io/sensors/bosch-bme280)

  ![pinout](https://www.sensatio.io/wp-content/uploads/2020/05/BME280.jpg)


## Library survey

For our purposes (acquisition of weather data at low rates and low
power, flexible bus interfaces), the following two libraries seem to
be most appropriate:

- [SparkFun BME280 Arduino Library](https://github.com/sparkfun/SparkFun_BME280_Arduino_Library): Takes pointer to wire object. Various derived measures. Supports configuration. Supports power modes.
- [BMx280MI](https://bitbucket.org/christandlg/bmx280mi): Non-blocking read request, takes pointer to Wire object. Exposes power modes. In the BMx280_I2C example, fix I2C address to 0x77 (line 25).


A search via the library manager of the Arduino IDE also results in
(April 2022):

- [Adafruit BME280 Library](https://github.com/adafruit/Adafruit_BME280_Library): Based on adafruit bus libraries.
- [BlueDot BME280 Library](https://github.com/BlueDot-Arduino/BlueDot_BME280): Fixed Wire or SPI interface, conversion to altitude.
- [BME280 by Tyler Glenn](https://github.com/finitespace/BME280): Calculates derived measures like dew point, sea level pressure, etc., fixed Wire object.
- [Bme280 by Eduard Malokhvill](https://github.com/malokhvii-eduard/arduino-bme280): Different predefined configuration settings, non flexible bus interface.
- [BME280 library by Zanduino](https://github.com/Zanduino/BME280): Non flexible bus interface.
- [Bolder flight systems BME280](https://github.com/bolderflight/bme280): Well documented library, based on driver provided by Bosch and Wire.h, takes pointer to Wire object. In the i2c example, fix I2C address to 0x77 (line 39). Operates in normal mode only (continuous sampling).
- [Forced-BME280](https://github.com/JVKran/Forced-BME280): Wire.h, some calibration and configuration code via defines.
- [Grove Barometer Sensor BME280](https://github.com/Seeed-Studio/Grove_BME280): Wire.h, very basic interface, sensor not configurable.
- [Gyver BME280](https://github.com/GyverLibs/GyverBME280): Non-english docs
- [JWA BME280_Bosch_Wrapper](https://github.com/janw-cz/JWA_BME280): Based on driver provided by Bosch and Wire.h.
- [Melopero BME280 Arduino Library](https://github.com/melopero/Melopero_BME280_Arduino_Library): Based on driver provided by Bosch and Wire.h.
- [Simple BME280](https://gitlab.com/riva-lab/SimpleBME280): Non-english docs.

