#ifndef MOVEMENTS_H
#define MOVEMENTS_H

#include <Servo.h>
#include <avr/pgmspace.h>

#define NUM_SERVOS 8
#define ACE 9               // number of columns (8 servos + time)
#define SERVO_PERIOD 20     // ms

extern Servo servo[NUM_SERVOS];
extern int servoCal[NUM_SERVOS];
extern int servoPos[NUM_SERVOS];

// --------------------------------------------------
// PROGMEM MOVEMENT PROGRAMS
// --------------------------------------------------

static const int servoPrg02step = 11;
static const int servoPrg02[][ACE] PROGMEM = {
{70,90,90,110,110,90,90,70,100},
{90,90,90,110,110,90,45,90,100},
{70,90,90,110,110,90,45,70,100},
{70,90,90,90,90,90,45,70,100},
{70,45,135,90,90,90,90,70,100},
{70,45,135,110,110,90,90,70,100},
{90,90,135,110,110,90,90,90,100},
{90,90,90,110,110,135,90,90,100},
{70,90,90,110,110,135,90,70,100},
{70,90,90,110,90,135,90,70,100},
{70,90,90,110,110,90,90,70,100}
};

static const int servoPrg03step = 11;
static const int servoPrg03[][ACE] PROGMEM = {
{70,90,90,110,110,90,90,70,100},
{90,45,90,110,110,90,90,90,100},
{70,45,90,110,110,90,90,70,100},
{70,45,90,90,90,90,90,70,100},
{70,90,90,90,90,135,45,70,100},
{70,90,90,110,110,135,45,70,100},
{90,90,135,110,110,90,90,90,100},
{90,90,135,110,110,90,90,90,100},
{70,90,135,110,110,90,90,70,100},
{70,90,135,90,110,90,90,70,100},
{70,90,90,110,110,90,90,70,100}
};

static const int servoPrg06step = 8;
static const int servoPrg06[][ACE] PROGMEM = {
{70,90,90,110,110,90,90,70,100},
{90,90,90,110,110,90,90,90,100},
{90,135,90,110,110,90,135,90,100},
{70,135,90,110,110,90,135,70,100},
{70,135,90,90,90,90,135,70,100},
{70,135,135,90,90,135,135,70,100},
{70,135,135,110,110,135,135,70,100},
{70,90,90,110,110,90,90,70,100}
};

static const int servoPrg07step = 8;
static const int servoPrg07[][ACE] PROGMEM = {
{70,90,90,110,110,90,90,70,100},
{70,90,90,90,90,90,90,70,100},
{70,90,45,90,90,45,90,70,100},
{70,90,45,110,110,45,90,70,100},
{90,90,45,110,110,45,90,90,100},
{90,45,45,110,110,45,45,90,100},
{70,45,45,110,110,45,45,70,100},
{70,90,90,110,110,90,90,70,100}
};

static const int servoPrg08step = 1;
static const int servoPrg08[][ACE] PROGMEM = {
{110,90,90,70,70,90,90,110,500}
};

static const int servoPrg09step = 4;
static const int servoPrg09[][ACE] PROGMEM = {
{120,90,90,110,60,90,90,70,200},
{70,90,90,110,110,90,90,70,200},
{120,90,90,110,60,90,90,70,200},
{70,90,90,110,110,90,90,70,200}
};

static const int servoPrg10step = 11;
static const int servoPrg10[][ACE] PROGMEM = {
{120,90,90,110,60,90,90,70,200},
{120,70,70,110,60,70,70,70,200},
{120,110,110,110,60,110,110,70,200},
{120,70,70,110,60,70,70,70,200},
{120,110,110,110,60,110,110,70,200},
{70,90,90,70,110,90,90,110,200},
{70,70,70,70,110,70,70,110,200},
{70,110,110,70,110,110,110,110,200},
{70,70,70,70,110,70,70,110,200},
{70,110,110,70,110,110,110,110,200},
{70,90,90,70,110,90,90,110,200}
};

static const int servoPrg11step = 11;
static const int servoPrg11[][ACE] PROGMEM = {
{70,90,90,110,110,90,90,70,300},
{100,90,90,80,80,90,90,100,400},
{70,90,90,110,110,90,90,70,500},
{100,90,90,80,80,90,90,100,600},
{70,90,90,110,110,90,90,70,700},
{100,90,90,80,80,90,90,100,1300},
{70,90,90,110,110,90,90,70,1800},
{135,90,90,45,45,90,90,135,200},
{70,90,90,45,60,90,90,135,500},
{70,90,90,45,110,90,90,135,500},
{70,90,90,110,110,90,90,70,500}
};

static const int servoPrg13step = 10;
static const int servoPrg13[][ACE] PROGMEM = {
{90,90,90,90,90,90,90,90,300},
{50,90,90,90,90,90,90,90,300},
{90,90,90,130,90,90,90,90,300},
{90,90,90,90,90,90,90,50,300},
{90,90,90,90,130,90,90,90,300},
{50,90,90,90,90,90,90,90,300},
{90,90,90,130,90,90,90,90,300},
{90,90,90,90,90,90,90,50,300},
{90,90,90,90,130,90,90,90,300},
{90,90,90,90,90,90,90,90,300}
};

static const int servoPrg14step = 9;
static const int servoPrg14[][ACE] PROGMEM = {
{70,45,135,110,110,135,45,70,300},
{115,45,135,65,110,135,45,70,300},
{70,45,135,110,65,135,45,115,300},
{115,45,135,65,110,135,45,70,300},
{70,45,135,110,65,135,45,115,300},
{115,45,135,65,110,135,45,70,300},
{70,45,135,110,65,135,45,115,300},
{115,45,135,65,110,135,45,70,300},
{75,45,135,105,110,135,45,70,300}
};

// --------------------------------------------------
// Movement runner
// --------------------------------------------------
inline void runServoPrg(const int servoPrg[][ACE], int step);

// API functions
void initServos(const int servoPins[NUM_SERVOS]);
void neutralStand();

void walkForward();
void walkBackward();
void rotateLeft();
void rotateRight();
void lieDownPose();
void sayHiMotion();
void fightMotion();
void pushUpMotion();
void danceMove1();
void danceMove2();

#endif
