/*

  This example is a plain vanilla ESPFMfGK totally open and active features for anything.

  It might be good solution for everything that will be used on the bench only. But keep
  in mind: it is open as f*ck and anyone can delete/modify/see everything.

  esp32 dev module
    -- cpu freq: 240 mhz
    -- flash freq: 80 mhz
    -- flash size: 4 mb
    -- part sch: 4 mb w. ffat (1.2 app, 1.5 ffat)
    

*/

#include <WiFi.h>
#include <FS.h>
// Remove the file systems that are not needed.
#include <SD.h>
#include <LittleFS.h>
#include <SD_MMC.h>
#include <FFat.h>
#include <SPI.h>
// the thing.
#include <ESPFMfGK.h>

// have a look at this concept to keep your private data safe!
// https://github.com/holgerlembke/privatedata
#include <privatedata.h>

const char *ssid = privatedata_mySSID;      // Change this to your WiFi SSID
const char *password = privatedata_myWAP2;  // Change this to your WiFi password


const word filemanagerport = 8080;
// we want a different port than the webserver
ESPFMfGK filemgr(filemanagerport);

const uint8_t LED_BUILTIN = 2;

void setup() {
  Serial.begin(115200);
  delay(1000);
  Serial.println("\n\nESPFMfGK plain demo " __DATE__ " " __TIME__);

  // login into WiFi
  // Change needed!
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(10);
  }

  configTzTime("CET-1CEST,M3.5.0,M10.5.0/3", "pool.ntp.org", "");

  addFileSystems();
  setupFilemanager();

  pinMode(LED_BUILTIN, OUTPUT);
}

void loop() {
  filemgr.handleClient();

  static uint32_t ticker = 0;
  if (millis() - ticker > 1000) {
    digitalWrite(LED_BUILTIN, !digitalRead(LED_BUILTIN));
    ticker = millis();
  }
}

//