
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
/*
 *
 *	File		:	HANUMAN_32__TFT_ST7735S.h
 *	Release		:	v0.1
 *
 *	Created on	:	-----
 *		Author	:	hii-nice-2-meet-u
 *
 */
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#ifndef INC_HANUMAN_32__TFT_ST7735S_H
#define INC_HANUMAN_32__TFT_ST7735S_H

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#include "HANUMAN_32____MACRO.h"
#include "HANUMAN_32___SPI_Device.h"

#include <stdio.h>
#include <stdarg.h>

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#define COLOR_RED     0xF800
#define COLOR_ORANGE  0xFAA0
#define COLOR_YELLOW  0xFFE0
#define COLOR_GREEN   0x07E0
#define COLOR_CYAN    0x07FF
#define COLOR_BLUE    0x001F
#define COLOR_NAVY    0x000F
#define COLOR_INDIGO  0x4810
#define COLOR_VIOLET  0x780F
#define COLOR_MAGENTA 0xF81F
#define COLOR_BLACK   0x0000
#define COLOR_WHITE   0xFFFF

// ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

class TFT_ST7735S
{

public:
	TFT_ST7735S(void);

	void text(uint8_t line, uint8_t col, const char* text, ...);
	void textWithBackground(uint8_t line, uint8_t col, const char* text, ...);

	void clear(void);
	void fill_Screen(uint16_t color);

	void draw_Bitmap(uint8_t posX, uint8_t posY, uint8_t* _bitmap, uint8_t width, uint8_t length, uint16_t color);
	void draw_Bitmap(uint8_t posX, uint8_t posY, const uint8_t* _bitmap, uint8_t width, uint8_t length, uint16_t color);
	void draw_BitmapColor(uint8_t posX, uint8_t posY, const uint16_t* _bitmap, uint8_t width, uint8_t length);
	void draw_BitmapColor(uint8_t posX, uint8_t posY, uint16_t* _bitmap, uint8_t width, uint8_t length);

	void draw_Char(uint8_t posX, uint8_t posY, uint8_t character, uint16_t color);
	void draw_Pixel(uint8_t posX, uint8_t posY, uint16_t color);
	void draw_HorizonLine(uint8_t posX, uint16_t color);
	void draw_VerticalLine(uint8_t posY, uint16_t color);
	void draw_Line(uint8_t posX0, uint8_t posY0, uint8_t posX1, uint8_t posY1, uint16_t color);
	void draw_Rectangle(uint8_t posX0, uint8_t posY0, uint8_t posX1, uint8_t posY1, uint16_t color);
	void draw_Circle(uint8_t posX, uint8_t posY, uint8_t radius, uint16_t color);

	void fill_Rectangle(uint8_t posX0, uint8_t posY0, uint8_t posX1, uint8_t posY1, uint16_t color);
	void fill_Circle(uint8_t posX, uint8_t posY, uint8_t radius, uint16_t color);

	void set_TextSize(uint8_t size);
	void set_TextColor(uint16_t color);
	void set_TextBackgroundColor(uint16_t color);
	void set_BackgroundColor(uint16_t color);
	void set_RotationMode(uint8_t RotationMode);
	void set_Display_ON(bool DisplayStatus);
	void set_InvertMode(bool InvertMode);

private:
	SPISettings SPISettings_TFT_ST7735S = SPISettings(__DEFINE__SPI_FREQ_TFT_ST7735S, MSBFIRST, SPI_MODE0);
	SPIClass*   privSPI_TFT             = &SPI;
	uint8_t     _RotationMode           = 0;
	uint8_t     _height                 = 127;
	uint8_t     _width                  = 159;
	uint8_t     _TextSize               = 1;
	uint16_t    _TextColor              = 0xFFFF;
	uint16_t    _TextBackgroundColor    = 0xF800;
	uint16_t    _BackgroundColor        = 0x0000;
	void        SendCommand(uint8_t cmd);
	void        SendCommand(uint8_t cmd, uint8_t data);
	void        SendCommandAndData_8b(uint8_t cmd, uint8_t data);
	void        SendCommandAndData_16b(uint8_t cmd, uint16_t data);
	void        SendData_8b(uint8_t data);
	void        SendData_16b(uint16_t data);
	void        SendDataBytes(const uint8_t* buffer, uint16_t size_of_buffer);
	void        SetAddrWindow(uint8_t x0, uint8_t y0, uint8_t x1, uint8_t y1);
	void        SoftwareReset(void);
	void        set_SleepMode(bool SleepMode);
	void        draw_FastHorizonLine(uint8_t posX, uint8_t posY, uint8_t length, uint16_t color);
	void        draw_FastVerticalLine(uint8_t posX, uint8_t posY, uint8_t length, uint16_t color);

	const uint8_t BitmapFont[96][5] = {

	    {0b00000000, 0b00000000, 0b00000000, 0b00000000, 0b00000000}, // space (32)
	    {0b00100001, 0b00001000, 0b01000010, 0b00000000, 0b10000000}, // !
	    {0b01010010, 0b10010100, 0b00000000, 0b00000000, 0b00000000}, // "
	    {0b01010010, 0b10111110, 0b10101111, 0b10101001, 0b01000000}, // #
	    {0b00100011, 0b11101000, 0b11100010, 0b11111000, 0b10000000}, // $
	    {0b11000110, 0b01000100, 0b01000100, 0b01001100, 0b01100000}, // %
	    {0b01100100, 0b10101000, 0b10001010, 0b11001001, 0b10100000}, // &
	    {0b01100001, 0b00010000, 0b00000000, 0b00000000, 0b00000000}, // '
	    {0b00010001, 0b00010000, 0b10000100, 0b00010000, 0b01000000}, // (
	    {0b01000001, 0b00000100, 0b00100001, 0b00010001, 0b00000000}, // )
	    {0b00000010, 0b10001001, 0b11110010, 0b00101000, 0b00000000}, // *
	    {0b00000001, 0b00001001, 0b11110010, 0b00010000, 0b00000000}, // +
	    {0b00000000, 0b00000000, 0b00000110, 0b00010001, 0b00000000}, // ,
	    {0b00000000, 0b00000001, 0b11110000, 0b00000000, 0b00000000}, // -
	    {0b00000000, 0b00000000, 0b00000000, 0b00110001, 0b10000000}, // .
	    {0b00000000, 0b01000100, 0b01000100, 0b01000000, 0b00000000}, // /
	    {0b01110100, 0b01100111, 0b01011100, 0b11000101, 0b11000000}, // 0
	    {0b00100011, 0b00001000, 0b01000010, 0b00010001, 0b11000000}, // 1
	    {0b01110100, 0b01000010, 0b00100010, 0b00100011, 0b11100000}, // 2
	    {0b11111000, 0b10001000, 0b00100000, 0b11000101, 0b11000000}, // 3
	    {0b00010001, 0b10010101, 0b00101111, 0b10001000, 0b01000000}, // 4
	    {0b11111100, 0b00111100, 0b00010000, 0b11000101, 0b11000000}, // 5
	    {0b00110010, 0b00100001, 0b11101000, 0b11000101, 0b11000000}, // 6
	    {0b11111000, 0b01000100, 0b01000100, 0b00100001, 0b00000000}, // 7
	    {0b01110100, 0b01100010, 0b11101000, 0b11000101, 0b11000000}, // 8
	    {0b01110100, 0b01100010, 0b11110000, 0b10001001, 0b10000000}, // 9
	    {0b00000011, 0b00011000, 0b00000110, 0b00110000, 0b00000000}, // :
	    {0b00000011, 0b00011000, 0b00000110, 0b00010001, 0b00000000}, // ;
	    {0b00001000, 0b10001000, 0b10000010, 0b00001000, 0b00100000}, // <
	    {0b00000000, 0b00111110, 0b00001111, 0b10000000, 0b00000000}, // =
	    {0b10000010, 0b00001000, 0b00100010, 0b00100010, 0b00000000}, // >
	    {0b01110100, 0b01000010, 0b00100010, 0b00000000, 0b10000000}, // ?
	    {0b01110100, 0b01000010, 0b11011010, 0b11010101, 0b11000000}, // @
	    {0b01110100, 0b01100011, 0b00011111, 0b11000110, 0b00100000}, // A
	    {0b11110100, 0b01100011, 0b11101000, 0b11000111, 0b11000000}, // B
	    {0b01110100, 0b01100001, 0b00001000, 0b01000101, 0b11000000}, // C
	    {0b11100100, 0b10100011, 0b00011000, 0b11001011, 0b10000000}, // D
	    {0b11111100, 0b00100001, 0b11101000, 0b01000011, 0b11100000}, // E
	    {0b11111100, 0b00100001, 0b11001000, 0b01000010, 0b00000000}, // F
	    {0b01110100, 0b01100001, 0b00001001, 0b11000101, 0b11000000}, // G
	    {0b10001100, 0b01100011, 0b11111000, 0b11000110, 0b00100000}, // H
	    {0b01110001, 0b00001000, 0b01000010, 0b00010001, 0b11000000}, // I
	    {0b00111000, 0b10000100, 0b00100001, 0b01001001, 0b10000000}, // J
	    {0b10001100, 0b10101001, 0b10001010, 0b01001010, 0b00100000}, // K
	    {0b10000100, 0b00100001, 0b00001000, 0b01000011, 0b11100000}, // L
	    {0b10001110, 0b11101011, 0b00011000, 0b11000110, 0b00100000}, // M
	    {0b10001100, 0b01110011, 0b01011001, 0b11000110, 0b00100000}, // N
	    {0b01110100, 0b01100011, 0b00011000, 0b11000101, 0b11000000}, // O
	    {0b11110100, 0b01100011, 0b11101000, 0b01000010, 0b00000000}, // P
	    {0b01110100, 0b01100011, 0b00011010, 0b11001001, 0b10100000}, // Q
	    {0b11110100, 0b01100011, 0b11101010, 0b01001010, 0b00100000}, // R
	    {0b01111100, 0b00100000, 0b11100000, 0b10000111, 0b11000000}, // S
	    {0b11111001, 0b00001000, 0b01000010, 0b00010000, 0b10000000}, // T
	    {0b10001100, 0b01100011, 0b00011000, 0b11000101, 0b11000000}, // U
	    {0b10001100, 0b01100011, 0b00011000, 0b10101000, 0b10000000}, // V
	    {0b10001100, 0b01100011, 0b01011010, 0b11101110, 0b00100000}, // W
	    {0b10001100, 0b01010100, 0b01000101, 0b01000110, 0b00100000}, // X
	    {0b10001100, 0b01010100, 0b01000010, 0b00010000, 0b10000000}, // Y
	    {0b11111000, 0b01000100, 0b01000100, 0b01000011, 0b11100000}, // Z
	    {0b00111001, 0b00001000, 0b01000010, 0b00010000, 0b11100000}, // [
	    {0b00000100, 0b00010000, 0b01000001, 0b00000100, 0b00000000}, //
	    {0b11100001, 0b00001000, 0b01000010, 0b00010011, 0b10000000}, // ]
	    {0b00100010, 0b10100010, 0b00000000, 0b00000000, 0b00000000}, // ^
	    {0b00000000, 0b00000000, 0b00000000, 0b00000011, 0b11100000}, // _
	    {0b01000001, 0b00000100, 0b00000000, 0b00000000, 0b00000000}, // `
	    {0b00000000, 0b00011100, 0b00010111, 0b11000101, 0b11100000}, // a
	    {0b10000100, 0b00101101, 0b10011000, 0b11000111, 0b11000000}, // b
	    {0b00000000, 0b00011101, 0b00001000, 0b01000101, 0b11000000}, // c
	    {0b00001000, 0b01011011, 0b00111000, 0b11000101, 0b11100000}, // d
	    {0b00000000, 0b00011101, 0b00011111, 0b11000001, 0b11000000}, // e
	    {0b00110010, 0b01010001, 0b11000100, 0b00100001, 0b00000000}, // f
	    {0b00000000, 0b00011111, 0b00010111, 0b10000100, 0b11000000}, // g
	    {0b10000100, 0b00101101, 0b10011000, 0b11000110, 0b00100000}, // h
	    {0b00100000, 0b00011000, 0b01000010, 0b00010001, 0b11000000}, // i
	    {0b00010000, 0b00001100, 0b00100001, 0b01001001, 0b10000000}, // j
	    {0b01000010, 0b00010010, 0b10100110, 0b00101001, 0b00100000}, // k
	    {0b01100001, 0b00001000, 0b01000010, 0b00010001, 0b11000000}, // l
	    {0b00000000, 0b00110101, 0b01011010, 0b11000110, 0b00100000}, // m
	    {0b00000000, 0b00101101, 0b10011000, 0b11000110, 0b00100000}, // n
	    {0b00000000, 0b00011101, 0b00011000, 0b11000101, 0b11000000}, // o
	    {0b00000000, 0b00111101, 0b00011111, 0b01000010, 0b00000000}, // p
	    {0b00000000, 0b00011011, 0b00110111, 0b10000100, 0b00100000}, // q
	    {0b00000000, 0b00101101, 0b10011000, 0b01000010, 0b00000000}, // r
	    {0b00000000, 0b00011101, 0b00000111, 0b00000111, 0b11000000}, // s
	    {0b01000010, 0b00111000, 0b10000100, 0b00100100, 0b11000000}, // t
	    {0b00000000, 0b00100011, 0b00011000, 0b11001101, 0b10100000}, // u
	    {0b00000000, 0b00100011, 0b00011000, 0b10101000, 0b10000000}, // v
	    {0b00000000, 0b00100011, 0b00011010, 0b11010101, 0b01000000}, // w
	    {0b00000000, 0b00100010, 0b10100010, 0b00101010, 0b00100000}, // x
	    {0b00000000, 0b00100011, 0b00010111, 0b10000101, 0b11000000}, // y
	    {0b00000000, 0b00111110, 0b00100010, 0b00100011, 0b11100000}, // z
	    {0b00010001, 0b00001000, 0b10000010, 0b00010000, 0b01000000}, // {
	    {0b00100001, 0b00001000, 0b01000010, 0b00010000, 0b10000000}, // |
	    {0b01000001, 0b00001000, 0b00100010, 0b00010001, 0b00000000}  // }

	};
};

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

// //* ----------------------------------------------------------------
// // clang-format off

// // 'ARTRON_80x80, 80x80px
// const unsigned char epd_bitmap_1[] PROGMEM = {
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x1f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xc0, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x3f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xe0,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x7f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf8, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
// 	0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x03, 0xf8, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xf8, 0x7f,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xfc, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x0f, 0xfe, 0x7f, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x7f, 0x80, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xbb, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f,
// 	0xff, 0xbb, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xff, 0xdd, 0xe0, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x3f, 0xfd, 0xdd, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xf8, 0xee,
// 	0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf8, 0xe6, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0xff, 0xf0, 0x77, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf0, 0x33, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0, 0x3b, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff,
// 	0xc0, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xc0, 0x1d, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x07, 0xff, 0x80, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xff, 0x80, 0x0e,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x1f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x7f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
// 	0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x04,
// 	0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff,
// 	0xfe, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x1f, 0x00, 0x00,
// 	0x00, 0x0f, 0xff, 0xff, 0xfc, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xfc, 0x00,
// 	0x00, 0x3f, 0x80, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x7f, 0xc0, 0x00, 0x00, 0x1f,
// 	0xff, 0xff, 0xf8, 0x00, 0x00, 0x7f, 0xc0, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xf0, 0x00, 0x00, 0xff,
// 	0xe0, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xe0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x7f, 0xff, 0xff,
// 	0xe0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x3f, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x7f, 0xe0, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
// 	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

// // 'ARTRON_80x80, 80x80px
// const unsigned char epd_bitmap_2[] PROGMEM = {
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xfc, 0x00,
//  0x00, 0x00, 0x00, 0x7f, 0xff, 0xe0, 0xff, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf0,
//  0xff, 0xff, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xf0, 0x7f, 0xff, 0xfc, 0x00, 0x00, 0x00,
//  0x01, 0xff, 0xff, 0xf8, 0x7f, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x01, 0xff, 0xff, 0xf8, 0x3f, 0xe7,
//  0xf0, 0x00, 0x00, 0x00, 0x03, 0xff, 0xff, 0xfc, 0x00, 0x07, 0xf0, 0x00, 0x00, 0x00, 0x07, 0xff,
//  0xff, 0xfc, 0x1f, 0xc7, 0xe0, 0x00, 0x00, 0x00, 0x07, 0xff, 0xff, 0xfe, 0x1f, 0xef, 0xe0, 0x00,
//  0x00, 0x00, 0x0f, 0xff, 0xff, 0xfe, 0x0f, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x0f, 0xff, 0xff, 0xff,
//  0x07, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x1f, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x1f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xf8,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xf0, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xff, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
//  0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x07, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xfb, 0x80,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x0f, 0xf7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0xe6, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39,
//  0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x70, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf1, 0xb0, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf7, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x01, 0xe6, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xee, 0xe0, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x03, 0xdc, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xdd,
//  0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0xb9, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x0f, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x77, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x1e, 0xee, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0xcc, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x3d, 0xdc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0x98,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7b, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x77, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x37, 0x60, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2e, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x0e, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1d, 0xc0, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x09, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x80,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
//  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

// // clang-format on

// //* ----------------------------------------------------------------
