// Arduino.h

#ifndef _ARDUINO_H_
#define _ARDUINO_H_

// MIT License
//
// Copyright (c) 2025 Hiroaki SHIBUKI a.k.a. hidori
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#include <stddef.h>
#include <stdint.h>
#include <string.h>

#define PROGMEM
#define pgm_read_byte_near(addr) (*(const uint8_t*)(addr))
#define pgm_read_byte(addr) (*(const uint8_t*)(addr))
#define memcpy_P(dest, src, num) memcpy((dest), (src), (num))
#define strcmp_P(s1, s2) strcmp((s1), (s2))
#define strncmp_P(s1, s2, n) strncmp((s1), (s2), (n))
#define strlen_P(s) strlen(s)
#define strncpy_P(dest, src, n) strncpy((dest), (src), (n))

template <typename T>
T min(T a, T b) {
  return (a < b) ? a : b;
}

class Print {
 public:
  virtual size_t write(uint8_t) = 0;
  virtual size_t write(const uint8_t* buffer, size_t size) = 0;
};

class Stream : public Print {
 public:
  virtual int available() = 0;
  virtual int read() = 0;
  virtual int peek() = 0;
  virtual void flush() = 0;
};

#endif  // _ARDUINO_H_
