# WS2812 Bitbang — Single LED driver

Library that provides the simple function ws2812Write(pin, color) to set the color of **a single** WS2812 LED without prior initialization and without any special peripherial hardware requirements (no Timer, RMT, IRQ, DMA...) by using bitbang output. Currently ESP MCUs are supported. 

## Features
- No initalization of library or ws2812 LED required
- Simple api: `ws2812Write(uint8_t pin, uint32_t color_rgb)` Color 0xRRGGBB
- Extended api: `ws2812Write(uint8_t pin, uint32_t color, uint8_t led_count, ws2812_write_led_type_t led_type)` if you want to set color of more than one LED or need other color orders
- Minimal Footprint but time sensitive, works only for certain MCUs (tested on ESP8266, ESP32 and ESP32S3) and clock frequencies

## Info
- Blocks interrupts while pushing out data to LED (around 30us per LED)
- Data latching pause is not generated by this library, so wait at least 50us between ws2812Write calls to same port (usually no need to do something here as you don't update the LED that often and the start of the function takes quite some time to calculate timing and resort color values). In extreme case add `delayMicroseconds(50);` manually to allow latching of data into LEDs.
- With the third argument more than one LED can be set if you are using LED stripes, but all will be set to the same color.

## API
```c
void ws2812Write(uint8_t pin, uint32_t color_rgb, uint8_t led_count = 1, ws2812_write_led_type_t led_type = WS2812WRITE_GRB);
