/*
 * SPDX-FileCopyrightText: 2015-2021 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */

#ifndef __ESP_NIMBLE_MEM_H__
#define __ESP_NIMBLE_MEM_H__

#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

void *nimble_platform_mem_malloc(size_t size);
void *nimble_platform_mem_calloc(size_t n, size_t size);
void nimble_platform_mem_free(void *ptr);

#ifndef ESP_PLATFORM
#define nimble_platform_mem_malloc malloc
#define nimble_platform_mem_calloc calloc
#define nimble_platform_mem_free free
#endif

#ifdef __cplusplus
}
#endif

#endif /* __ESP_NIMBLE_MEM_H__ */
