/**
   Arduino 控制气泵 充放气状态  每次动作间隔 5秒
   
  01AirPumpTest
  02DynamicBreath
  集成化气泵02——动态呼吸   https://www.bilibili.com/video/BV1WN411S7LJ
  气泵交互艺术——血液心脏   https://www.bilibili.com/video/BV1tT42117g6
  气泵交互艺术——神经元     https://www.bilibili.com/video/BV1VtsteRErj
  气泵交互艺术——棺柩心脏   https://www.bilibili.com/video/BV1Yz421y7xE
  02_2DoubleDynamicBreath
  集成化气泵02_2——双气泵动态呼吸   https://www.bilibili.com/video/BV1LW421c7mS
  02_3DoubleIndependentDynamicBreath
  02_4FourDynamicBreath
  集成化气泵02_3——四气泵（单个轮替动态呼吸）   https://www.bilibili.com/video/BV14z421Q7Ku
  02_5FourIndependentDynamicBreath
  02_6SixIndependentDynamicBreath
  六气泵独立动态呼吸
  你知道气泵能用于什么交互艺术吗？   https://www.bilibili.com/video/BV1uL411i7RL
  03HeartBeat
  集成化气泵03——模拟心跳可视化   https://www.bilibili.com/video/BV1FM4y177RU
  03_2DynamicBreathAndHeartBeat
  集成化气泵03_2——动态呼吸+心脏泵泵跳   https://www.bilibili.com/video/BV1TW421c7iU
  04_1PulseSensor
  集成化气泵04_1——心率存在感应1   https://www.bilibili.com/video/BV1xw4m1R7TN
  04_2MAX30102HeartRate
  集成化气泵04_2——心率存在感应2   https://www.bilibili.com/video/BV19u4m1M7Jr
  04_3MAX30100HeartRate
  集成化气泵04_3——心率存在感应3   https://www.bilibili.com/video/BV1UH4y1s7PV
  04_4DoubleAirPumpMAX30102HeartRate
  双头气泵登场，一个比两个气泵强？   https://www.bilibili.com/video/BV14ZsfevEbZ
  04_5BluetoothHeartRateAirPump
  可被蓝牙控制，会根据心率分档位的集成化气泵？   https://www.bilibili.com/video/BV1152SYzE4m
  05SoundSensor
  集成化气泵05——口吹气球   https://www.bilibili.com/video/BV1x8411D7kt
  05_2DecibelSoundSensor
  集成化气泵的新玩法，用来打氧？   https://www.bilibili.com/video/BV1mn1LYCEg6
  06PressureSensor
  你知道“压力”如何可视化吗？   https://www.bilibili.com/video/BV12m4y1H7sV
  06_2PressureSensorFourAirPump
  集成化气泵06_2——压力可视化（四气泵）   https://www.bilibili.com/video/BV1Cj421R7fn
  07HX711WeightSensor
  重量可视化 Arduino HX711称重传感器   https://www.bilibili.com/video/BV1tN411B7hZ
  08HCSR04UltrasonicSensor
  超声波距离可视化   https://www.bilibili.com/video/BV19u4y1Q79C
  08_2HCSR04UltrasonicSensorFourAirPump
  集成化气泵08_2——超声波距离可视化（四气泵）   https://www.bilibili.com/video/BV1hr42187fd
  09VL53L0TOFLaserSensor
  集成化气泵09——激光测距可视化气球   https://www.bilibili.com/video/BV1Wh4y1U76Z
  10DHT11TemperatureSensor
  集成化气泵10——温度可视化   https://www.bilibili.com/video/BV1g34y1G78t
  11DHT11HumilitySensor
  集成化气泵11——湿度可视化   https://www.bilibili.com/video/BV1Gp4y1u78p
  12HCSR501PIRSensor
  集成化气泵12——人体存在可视化   https://www.bilibili.com/video/BV1zm4y1g7sq
  13SoilMoistureSensor
  集成化气泵13——土壤湿度可视化   https://www.bilibili.com/video/BV1Eu411F79c
  13_2SoilMoistureSensorFourAirPump
  集成化气泵13_2——土壤湿度可视化（四气泵）   https://www.bilibili.com/video/BV1Hu4m1u7Nr
  14ButtonControl
  集成化气泵14——按钮控制   https://www.bilibili.com/video/BV1Fu4m1G7eG
  14_2OneButtonControl
  体积太大？更小的nano集成化气泵来咯！按钮控制   https://www.bilibili.com/video/BV1VoyoYTE7r
  14_3ThreeButtonControl
  气体艺术‼按钮可控时长的气泵它来咯   https://www.bilibili.com/video/BV1p9SuYaEjb
  15TTP223TouchSensor
  集成化气泵15——触摸传感可视化   https://www.bilibili.com/video/BV1e2421M7Bw
  16PhotosensitiveSensor
  集成化气泵16——光敏传感可视化   https://www.bilibili.com/video/BV1b2421M74S
  17PotentiometerControl
  集成化气泵17——电位器控制   https://www.bilibili.com/video/BV1ct421t7Wf
  18BluetoothVibrationAirPump
  集成化气泵18——蓝牙震动气泵   https://www.bilibili.com/video/BV1iGeweGEa9
  19AirPumpMatrix
  气泵玩到极致！我用Arduino做了一个多种效果的气球矩阵！   https://www.bilibili.com/video/BV1Qj411L7mb
  20GP2Y0A21YK0FInfraredBreathingCarpet
  会呼吸舞动的地毯，你见过吗？   https://www.bilibili.com/video/BV15k4y197f1
  21AirPumpStepByStep
  集成化气泵21——气球台阶（六气泵）   https://www.bilibili.com/video/BV1fm421J7LH
  22AirPumpBomb
  集成化气泵22——气泵炸药包   https://www.bilibili.com/video/BV1yx4y1h7ub
  23MP121GrassPlot
  【售后反馈】气泵交互艺术——呼吸草坪   https://www.bilibili.com/video/BV1HsHLetED5
  24VoiceRecognitionAirPump
  解放双手，可以语音远程控制的集成化气泵！   https://www.bilibili.com/video/BV1phs6e3Eoo
  25AirPumpDoubleBanger
  集成化气泵25——气泵双响炮3（两充两放）   https://www.bilibili.com/video/BV1rr421g7Xv
  26UltrasonicAirPumpInteractiveGame
  集成化气泵26——超声波气泵互动装置   https://www.bilibili.com/video/BV1Bt421K7zc
  27ButtonWS2812LEDAirPump
  集成化气泵27——按钮灯带气泵   https://www.bilibili.com/video/BV1SJ4m1M7Zq
  28ProcessingAirPumpInteractive
  【赤鱼科技】Processing和气泵装置交互新玩法   https://www.bilibili.com/video/BV1yk28YUEFZ
*/


#define airPumpPin    5                    // 控制气泵充气 引脚
#define airValvePin   6                    // 控制气阀放气 引脚

#define airPumpON     HIGH                 // 气泵打开 开启充气
#define airPumpOFF  !airPumpON             // 气泵关闭 停止充气

#define airValveON     HIGH                // 气阀打开 开启放气
#define airValveOFF  !airValveON           // 气阀关闭 停止放气

void setup() {
  Serial.begin(9600);
  pinMode(airPumpPin, OUTPUT);             // 设置引脚输出
  pinMode(airValvePin, OUTPUT);            // 设置引脚输出
  digitalWrite(airPumpPin, airPumpOFF);    // 初始状态 关闭气泵 停止充气
  digitalWrite(airValvePin, airValveON);   // 初始状态 气阀打开 开启放气
}

void loop() {
  digitalWrite(airPumpPin, airPumpON);          // 气泵开启 开启充气
  //analogWrite(airPumpPin, 200);               // 如果想要修改充气速度，可在此行代码修改200这个数字（范围0-255），越大速度越快，删除”//”后修改后面数字，在上一行代码开头添加”//”
  digitalWrite(airValvePin, airValveOFF);       // 气阀关闭 停止放气
  delay(4000);

  digitalWrite(airPumpPin, airPumpOFF);         // 气泵关闭 停止充气
  digitalWrite(airValvePin, airValveON);        // 气阀开启 开启放气
  //analogWrite(airValvePin, 200);              // 如果想要修改放气速度，可在此行代码修改200这个数字（范围0-255），越大速度越快，删除”//”后修改后面数字，在上一行代码开头添加”//”
  delay(3500);
}
