#include <stdio.h>
#include <math.h>

#include <Log2Representation.h>

void out(const char *name, float x, pmf_logarithmic value) {
  float ld2 = log2(x);
  float pmf = ld2 * 512;
  int16_t pmf_int = (uint16_t)round(pmf);
  puts("");
  printf("// %s = %f  %d = 0x%04x\n", name, pmf, pmf_int, pmf_int);
  if (pmf_int != value) {
    printf("// %s should be 0x%04x\n", name, pmf_int);
  }
  printf("#define %s ((pmf_logarithmic)0x%04x)\n", name, value);
  float back = pow(2.0, float(pmf_int) / 512);
  printf("// => converted back => %.2f\n", back);
}

int main() {
  puts("// Autogenerated by extras/gen_pmf_const/main");
  puts("// DO NOT EDIT");
  puts("#ifndef LOG2REPRESENTATIONCONST_H");
  puts("#define LOG2REPRESENTATIONCONST_H");
  puts("");
  puts("#include <Log2Representation.h>");

  pmf_logarithmic x;

  x = log2_from((uint8_t)1);
  out("LOG2_CONST_1", 1.0, x);

  x = log2_shr(log2_from((uint8_t)3), 1);
  out("LOG2_CONST_3_DIV_2", 1.5, x);

  x = log2_multiply(log2_from((uint32_t)16e6), log2_from((uint32_t)8e6));
  out("LOG2_CONST_128E12", 1.28e14, x);

  x = log2_from((uint32_t)16e6);
  out("LOG2_CONST_16E6", 1.6e7, x);

  x = log2_from((uint16_t)500);
  out("LOG2_CONST_500", 500, x);

  x = log2_from((uint16_t)1000);
  out("LOG2_CONST_1000", 1000, x);

  x = log2_from((uint16_t)2000);
  out("LOG2_CONST_2000", 2000, x);

  x = log2_from((uint16_t)32000);
  out("LOG2_CONST_32000", 32000, x);

  x = log2_multiply(log2_from((uint32_t)16e6), log2_from((uint32_t)8e6));
  x = log2_sqrt(x);
  out("LOG2_CONST_16E6_DIV_SQRT_OF_2", 1.6e7 / sqrt(2), x);

  x = log2_from((uint32_t)21e6);
  out("LOG2_CONST_21E6", 21e6, x);

  x = log2_from((uint16_t)42000);
  out("LOG2_CONST_42000", 42000, x);

  x = log2_divide(log2_from((uint32_t)21e6), log2_sqrt(log2_from((uint8_t)2)));
  out("LOG2_CONST_21E6_DIV_SQRT_OF_2", 21e6 / sqrt(2), x);

  x = log2_square(log2_from((uint32_t)21e6));
  x = log2_shr(x, 1);
  out("LOG2_CONST_2205E11", 2.205e14, x);

  x = log2_from(__UINT32_MAX__);
  out("LOG2_CONST_UINT32_MAX", __UINT32_MAX__, x);

  x = log2_from((uint16_t)__UINT16_MAX__);
  out("LOG2_CONST_UINT16_MAX", __UINT16_MAX__, x);

  puts("");
  puts("// used in Log2Representation.cpp as example");
  printf("// ");
  x = log2_from((uint16_t)15373);
  out("LOG2_CONST_15373", 15373, x);

  puts("#endif");

  return 0;
}
