/*!
	@file    FontSevenSeg_LTSM.hpp
	@author  Gavin Lyons
	@brief   Library font file for SevenSeg font.
*/

#pragma once
#include <display16_common_LTSM.hpp>

// === Font Data ===

/// @cond

/*
	Font type: Seven Segment extended numeric 14 chars( numeric extended )
	Font size: 32x50 pixels
	Memory usage : 2804 bytes
	Note: This is a clear reading seven segment font with some special symbols / . - :
*/
static const uint8_t FontSevenSeg[2804] FLASH_STORAGE = {
0x20,0x32,0x2D,0x0D,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xFF,0x00,0x01,0xFF,0xFF,0xC0,0x07,0xFF,0xFF,0xF0,0x03,0xFF,0xFF,0xE0,0x00,0xFF,0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // -
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0xF8,0x00,0x00,0x01,0xFC,0x00,0x00,0x01,0xFC,0x00,0x00,0x01,0xFC,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // .
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x3C,0x00,0x7F,0xFF,0x0C,0x01,0xFF,0xFF,0xC4,0x07,0xFF,0xFF,0xF0,0x13,0xFF,0xFF,0xE0,0x1C,0xFF,0xFF,0x80,0x1F,0x00,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x0F,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // /

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0xB0,0x06,0x7F,0xFF,0x78,0x0F,0x00,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x00,0x00,0x3C,0x1C,0x00,0x00,0x0C,0x10,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x1C,0x00,0x00,0x0C,0x1F,0x00,0x00,0x3C,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x0F,0x00,0x00,0x78,0x06,0x7F,0xFF,0x30,0x00,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 1
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0xB0,0x00,0x7F,0xFF,0x78,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x3C,0x00,0xFF,0xFF,0x0C,0x01,0xFF,0xFF,0xC4,0x07,0xFF,0xFF,0xF0,0x13,0xFF,0xFF,0xE0,0x1C,0xFF,0xFF,0x80,0x1F,0x00,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x0F,0x00,0x00,0x00,0x06,0x7F,0xFF,0x00,0x00,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 2
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0xB0,0x00,0x7F,0xFF,0x78,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x3C,0x00,0xFF,0xFF,0x0C,0x01,0xFF,0xFF,0xC4,0x07,0xFF,0xFF,0xF0,0x03,0xFF,0xFF,0xE0,0x00,0xFF,0xFF,0x8C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x78,0x00,0x7F,0xFF,0x30,0x00,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 3
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x06,0x00,0x00,0x78,0x0F,0x00,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x00,0x00,0x3C,0x1C,0xFF,0xFF,0x0C,0x11,0xFF,0xFF,0xC4,0x07,0xFF,0xFF,0xF0,0x03,0xFF,0xFF,0xE0,0x00,0xFF,0xFF,0x8C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 4
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0x80,0x06,0x7F,0xFF,0x00,0x0F,0x00,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x00,0x00,0x00,0x1C,0xFF,0xFF,0x00,0x11,0xFF,0xFF,0xC0,0x07,0xFF,0xFF,0xF0,0x03,0xFF,0xFF,0xE0,0x00,0xFF,0xFF,0x8C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x78,0x00,0x7F,0xFF,0x30,0x00,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 5
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0x80,0x06,0x7F,0xFF,0x00,0x0F,0x00,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x80,0x00,0x00,0x1F,0x00,0x00,0x00,0x1C,0xFF,0xFF,0x00,0x11,0xFF,0xFF,0xC0,0x07,0xFF,0xFF,0xF0,0x13,0xFF,0xFF,0xE0,0x1C,0xFF,0xFF,0x8C,0x1F,0x00,0x00,0x3C,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x0F,0x00,0x00,0x78,0x06,0x7F,0xFF,0x30,0x00,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 6
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0xB0,0x00,0x7F,0xFF,0x78,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 7
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0xB0,0x06,0x7F,0xFF,0x78,0x0F,0x00,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x00,0x00,0x3C,0x1C,0xFF,0xFF,0x0C,0x11,0xFF,0xFF,0xC4,0x07,0xFF,0xFF,0xF0,0x13,0xFF,0xFF,0xE0,0x1C,0xFF,0xFF,0x8C,0x1F,0x00,0x00,0x3C,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x0F,0x00,0x00,0x78,0x06,0x7F,0xFF,0x30,0x00,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 8
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0xFF,0x00,0x00,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0xB0,0x06,0x7F,0xFF,0x78,0x0F,0x00,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x80,0x00,0xFC,0x1F,0x00,0x00,0x3C,0x1C,0xFF,0xFF,0x0C,0x11,0xFF,0xFF,0xC4,0x07,0xFF,0xFF,0xF0,0x03,0xFF,0xFF,0xE0,0x00,0xFF,0xFF,0x8C,0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x78,0x00,0x7F,0xFF,0x30,0x00,0xFF,0xFF,0x80,0x01,0xFF,0xFF,0xC0,0x00,0xFF,0xFF,0x80,0x00,0x7F,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 9
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0xF8,0x00,0x00,0x01,0xFC,0x00,0x00,0x01,0xFC,0x00,0x00,0x01,0xFC,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0xF8,0x00,0x00,0x01,0xFC,0x00,0x00,0x01,0xFC,0x00,0x00,0x01,0xFC,0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // :
};

/// @endcond
