/*!
	@file    FontMint_LTSM.hpp
	@author  Gavin Lyons
	@brief   Library font file for Mint font.
*/

#pragma once
#include <display16_common_LTSM.hpp>

// === Font Data ===

/// @cond

/*
	Mint
	Font type    : 91 characters
	Font size    : 24x32 pixels
	Memory usage : 8740 bytes
	Creators notes: The character before the lowercase 'a' is normally a grave accent,
	but have been changed to the 'º' character to be able to show °C on the screen.
*/
static const uint8_t FontMint [8740] FLASH_STORAGE = {
0x18,0x20,0x20,0x5A,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // <space>
0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // !
0x00,0x00,0x00,0x01,0xC0,0xE0,0x03,0xE1,0xF0,0x03,0xE1,0xF0,0x03,0xE1,0xF0,0x01,0xE0,0xF0,0x00,0xE0,0x70,0x01,0xC0,0xE0,0x03,0xC1,0xE0,0x0F,0x87,0xC0,0x0E,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // "
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x70,0x00,0x38,0x70,0x00,0x70,0xE0,0x00,0x70,0xE0,0x00,0x70,0xE0,0x00,0x70,0xE0,0x0F,0xFF,0xF8,0x0F,0xFF,0xF8,0x0F,0xFF,0xF8,0x00,0xE1,0xC0,0x00,0xE1,0xC0,0x00,0xE1,0xC0,0x01,0xC3,0x80,0x01,0xC3,0x80,0x01,0xC3,0x80,0x0F,0xFF,0xF8,0x0F,0xFF,0xF8,0x0F,0xFF,0xF8,0x03,0x87,0x00,0x03,0x87,0x00,0x03,0x87,0x00,0x03,0x87,0x00,0x07,0x0E,0x00,0x07,0x0E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // #
0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x7F,0x00,0x01,0xFF,0xC0,0x03,0xFF,0xC0,0x07,0x80,0x80,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x80,0x00,0x03,0xC0,0x00,0x03,0xF8,0x00,0x01,0xFE,0x00,0x00,0x7F,0x80,0x00,0x0F,0xC0,0x00,0x03,0xC0,0x00,0x01,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x02,0x01,0xC0,0x07,0xFF,0xC0,0x07,0xFF,0x80,0x01,0xFE,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,  // $
0x00,0x00,0x00,0x07,0x80,0x70,0x0F,0xC0,0xE0,0x0C,0xC0,0xE0,0x18,0x61,0xC0,0x18,0x63,0x80,0x18,0x63,0x80,0x18,0x67,0x00,0x18,0x67,0x00,0x18,0x6E,0x00,0x0C,0xDC,0x00,0x0F,0xDC,0x00,0x07,0xB8,0x00,0x00,0x3B,0xC0,0x00,0x77,0xE0,0x00,0x76,0x60,0x00,0xEC,0x30,0x01,0xCC,0x30,0x01,0xCC,0x30,0x03,0x8C,0x30,0x03,0x8C,0x30,0x07,0x0C,0x30,0x0E,0x06,0x60,0x0E,0x07,0xE0,0x1C,0x03,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // %
0x00,0x00,0x00,0x00,0x7C,0x00,0x00,0xFF,0x00,0x01,0xFF,0x00,0x03,0xC7,0x80,0x03,0x83,0x80,0x03,0x83,0x80,0x03,0x83,0x80,0x03,0x87,0x00,0x01,0xCF,0x00,0x01,0xFE,0x00,0x00,0xFC,0x00,0x01,0xF0,0x70,0x03,0xF8,0x70,0x03,0xBC,0x70,0x07,0x1E,0x60,0x0E,0x0F,0xE0,0x0E,0x07,0xE0,0x0E,0x03,0xC0,0x0E,0x01,0xC0,0x0F,0x03,0xE0,0x07,0x8F,0xE0,0x07,0xFF,0x70,0x03,0xFE,0x70,0x00,0xF8,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // &
0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // '
0x00,0x07,0x00,0x00,0x0F,0x80,0x00,0x0F,0x00,0x00,0x1E,0x00,0x00,0x3C,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x0F,0x00,0x00,0x07,0x80,0x00,0x03,0x00,0x00,0x01,0x00,  // (
0x00,0x60,0x00,0x00,0xF0,0x00,0x00,0x78,0x00,0x00,0x3C,0x00,0x00,0x1E,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x1E,0x00,0x00,0x3C,0x00,0x00,0x78,0x00,0x00,0xF0,0x00,0x00,0x60,0x00,0x00,0x40,0x00,  // )
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x02,0x1C,0x20,0x03,0xC9,0xE0,0x07,0xFF,0xF0,0x01,0xFF,0xC0,0x00,0x1C,0x00,0x00,0x36,0x00,0x00,0x77,0x00,0x00,0xF3,0x80,0x01,0xE3,0xC0,0x00,0xE3,0x80,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // *
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // +
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x1F,0x00,0x00,0x0F,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x78,0x00,0x00,0x70,0x00,0x00,0x00,0x00,  // ,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // -
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x1C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // .
0x00,0x01,0xC0,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x07,0x00,0x00,0x07,0x00,0x00,  // /

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00,0x01,0xFF,0x00,0x03,0xFF,0x80,0x03,0xC7,0x80,0x07,0x83,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x30,0xE0,0x0E,0x78,0xE0,0x0E,0x78,0xE0,0x0E,0x78,0xE0,0x0E,0x30,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x83,0xC0,0x03,0xC7,0x80,0x03,0xFF,0x80,0x01,0xFF,0x00,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 0
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x7C,0x00,0x00,0xFC,0x00,0x03,0xFC,0x00,0x07,0x9C,0x00,0x02,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x03,0xFF,0xC0,0x03,0xFF,0xC0,0x03,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 1
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x03,0xFF,0x00,0x07,0xFF,0x80,0x07,0x87,0xC0,0x02,0x03,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x03,0x80,0x00,0x07,0x80,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0xE0,0x00,0x01,0xC0,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x07,0x00,0x00,0x07,0xFF,0xE0,0x07,0xFF,0xE0,0x07,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 2
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFC,0x00,0x0F,0xFF,0x00,0x0F,0xFF,0x80,0x06,0x07,0x80,0x00,0x03,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x03,0xC0,0x00,0x07,0x80,0x00,0xFF,0x00,0x00,0xFF,0x00,0x00,0xFF,0x80,0x00,0x07,0xC0,0x00,0x01,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x01,0xE0,0x04,0x03,0xC0,0x0F,0xFF,0x80,0x0F,0xFF,0x00,0x03,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 3
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x80,0x00,0x0F,0x80,0x00,0x1F,0x80,0x00,0x3F,0x80,0x00,0x3B,0x80,0x00,0x73,0x80,0x00,0xF3,0x80,0x01,0xE3,0x80,0x01,0xC3,0x80,0x03,0x83,0x80,0x03,0x83,0x80,0x07,0x03,0x80,0x0F,0x03,0x80,0x0E,0x03,0x80,0x1E,0x03,0x80,0x1F,0xFF,0xF0,0x1F,0xFF,0xF0,0x1F,0xFF,0xF0,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 4
0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0x80,0x03,0xFF,0x80,0x03,0xFF,0x80,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x03,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0xF0,0x00,0x07,0xFE,0x00,0x07,0xFF,0x00,0x00,0x1F,0x80,0x00,0x07,0x80,0x00,0x03,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x03,0xC0,0x0C,0x07,0x80,0x0F,0xFF,0x00,0x0F,0xFE,0x00,0x03,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 5
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xC0,0x00,0x1F,0xC0,0x00,0x7F,0xC0,0x00,0xFC,0x00,0x01,0xE0,0x00,0x03,0xC0,0x00,0x03,0x80,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x06,0x7E,0x00,0x0F,0xFF,0x80,0x0F,0xFF,0xC0,0x0F,0x03,0xC0,0x0E,0x01,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x07,0x00,0xE0,0x07,0x01,0xC0,0x07,0xC3,0xC0,0x03,0xFF,0x80,0x01,0xFF,0x00,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 6
0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x00,0x00,0xE0,0x00,0x01,0xC0,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 7
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00,0x01,0xFF,0x00,0x03,0xFF,0x80,0x03,0xC7,0xC0,0x07,0x03,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x81,0xC0,0x03,0xC3,0x80,0x03,0xF7,0x00,0x01,0xFE,0x00,0x01,0xFF,0x80,0x03,0xCF,0xC0,0x07,0x03,0xC0,0x06,0x01,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0F,0x01,0xE0,0x07,0x83,0xC0,0x07,0xFF,0xC0,0x03,0xFF,0x80,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 8
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,0x00,0x01,0xFF,0x00,0x03,0xFF,0x80,0x07,0x87,0xC0,0x07,0x01,0xC0,0x0E,0x01,0xC0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0F,0x00,0xE0,0x07,0x81,0xE0,0x07,0xFF,0xE0,0x03,0xFF,0xE0,0x00,0xFE,0xE0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x03,0xC0,0x00,0x07,0x80,0x00,0x0F,0x00,0x00,0x7E,0x00,0x07,0xFC,0x00,0x07,0xF8,0x00,0x07,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // 9
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // :
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x3C,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x70,0x00,0x01,0xE0,0x00,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // ;
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x01,0xE0,0x00,0x0F,0xE0,0x00,0x3F,0xC0,0x00,0xFE,0x00,0x03,0xF8,0x00,0x0F,0xC0,0x00,0x0F,0x00,0x00,0x0F,0xC0,0x00,0x07,0xF8,0x00,0x00,0xFE,0x00,0x00,0x3F,0xC0,0x00,0x0F,0xE0,0x00,0x01,0xE0,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // <
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // =
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x0F,0x00,0x00,0x0F,0xE0,0x00,0x07,0xF8,0x00,0x00,0xFE,0x00,0x00,0x3F,0x80,0x00,0x07,0xE0,0x00,0x01,0xE0,0x00,0x07,0xE0,0x00,0x3F,0xC0,0x00,0xFE,0x00,0x07,0xF8,0x00,0x0F,0xE0,0x00,0x0F,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // >
0x00,0x00,0x00,0x00,0xFE,0x00,0x03,0xFF,0x80,0x03,0xFF,0xC0,0x01,0x03,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x01,0xC0,0x00,0x03,0x80,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x1C,0x00,0x00,0x3C,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // ?

0x00,0x00,0x00,0x00,0x3F,0x00,0x00,0xFF,0x80,0x01,0xFF,0xC0,0x01,0xE1,0xE0,0x03,0x80,0xE0,0x03,0x80,0x70,0x07,0x00,0x70,0x07,0x00,0x70,0x07,0x07,0xF0,0x0E,0x1F,0xF0,0x0E,0x3F,0xF0,0x0E,0x3C,0x70,0x0E,0x78,0x70,0x0E,0x70,0x70,0x0E,0x70,0x70,0x0E,0x70,0x70,0x0E,0x70,0x70,0x0E,0x78,0x70,0x0E,0x38,0x70,0x07,0x3F,0xF0,0x07,0x1F,0xF0,0x07,0x07,0xE0,0x07,0x80,0x00,0x03,0xC0,0x00,0x03,0xC0,0x00,0x01,0xF0,0x00,0x00,0xFF,0xC0,0x00,0x7F,0xC0,0x00,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,  // @
0x00,0x00,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0x7E,0x00,0x00,0xFF,0x00,0x00,0xF7,0x00,0x00,0xE7,0x00,0x00,0xE7,0x00,0x01,0xE7,0x80,0x01,0xC3,0x80,0x01,0xC3,0x80,0x03,0xC3,0xC0,0x03,0xC1,0xC0,0x03,0x81,0xC0,0x03,0x81,0xC0,0x07,0x81,0xE0,0x07,0xFF,0xE0,0x07,0xFF,0xE0,0x07,0xFF,0xE0,0x0F,0x00,0xF0,0x0E,0x00,0x70,0x0E,0x00,0x70,0x0E,0x00,0x70,0x1E,0x00,0x78,0x1C,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // A
0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xFC,0x00,0x0F,0xFF,0x00,0x0F,0xFF,0x80,0x0E,0x07,0xC0,0x0E,0x03,0xC0,0x0E,0x01,0xC0,0x0E,0x01,0xC0,0x0E,0x01,0xC0,0x0E,0x03,0x80,0x0E,0x07,0x80,0x0F,0xFF,0x00,0x0F,0xFF,0x00,0x0F,0xFF,0x80,0x0E,0x03,0xC0,0x0E,0x01,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x01,0xE0,0x0E,0x07,0xC0,0x0F,0xFF,0xC0,0x0F,0xFF,0x00,0x0F,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // B
0x00,0x00,0x00,0x00,0x3F,0x80,0x00,0x7F,0xE0,0x01,0xFF,0xE0,0x03,0xE0,0x40,0x03,0xC0,0x00,0x07,0x80,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0F,0x00,0x00,0x07,0x00,0x00,0x07,0x80,0x00,0x03,0xC0,0x00,0x03,0xE0,0x40,0x01,0xFF,0xE0,0x00,0xFF,0xE0,0x00,0x3F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // C
0x00,0x00,0x00,0x0F,0xF0,0x00,0x0F,0xFE,0x00,0x0F,0xFF,0x00,0x0E,0x0F,0x80,0x0E,0x03,0x80,0x0E,0x03,0xC0,0x0E,0x01,0xC0,0x0E,0x01,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x01,0xE0,0x0E,0x01,0xC0,0x0E,0x03,0xC0,0x0E,0x03,0x80,0x0E,0x0F,0x80,0x0F,0xFF,0x00,0x0F,0xFE,0x00,0x0F,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // D
0x00,0x00,0x00,0x07,0xFF,0xC0,0x07,0xFF,0xC0,0x07,0xFF,0xC0,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0xFF,0x80,0x07,0xFF,0x80,0x07,0xFF,0x80,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0xFF,0xE0,0x07,0xFF,0xE0,0x07,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // E
0x00,0x00,0x00,0x07,0xFF,0xE0,0x07,0xFF,0xE0,0x07,0xFF,0xE0,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0xFF,0xC0,0x07,0xFF,0xC0,0x07,0xFF,0xC0,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // F
0x00,0x00,0x00,0x00,0x3F,0x80,0x00,0xFF,0xC0,0x01,0xFF,0xE0,0x03,0xE0,0xC0,0x03,0xC0,0x40,0x07,0x80,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0F,0x00,0xE0,0x07,0x00,0xE0,0x07,0x80,0xE0,0x03,0xC0,0xE0,0x03,0xE0,0xE0,0x01,0xFF,0xE0,0x00,0xFF,0xE0,0x00,0x3F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // G
0x00,0x00,0x00,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // H
0x00,0x00,0x00,0x07,0xFF,0xC0,0x07,0xFF,0xC0,0x07,0xFF,0xC0,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x07,0xFF,0xC0,0x07,0xFF,0xC0,0x07,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // I
0x00,0x00,0x00,0x01,0xFF,0xC0,0x01,0xFF,0xC0,0x01,0xFF,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x04,0x03,0xC0,0x07,0x07,0x80,0x0F,0xFF,0x00,0x07,0xFE,0x00,0x01,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // J
0x00,0x00,0x00,0x0E,0x01,0xE0,0x0E,0x03,0xC0,0x0E,0x03,0x80,0x0E,0x07,0x80,0x0E,0x0F,0x00,0x0E,0x0E,0x00,0x0E,0x1C,0x00,0x0E,0x3C,0x00,0x0E,0x78,0x00,0x0E,0xF0,0x00,0x0F,0xE0,0x00,0x0F,0xE0,0x00,0x0F,0xF0,0x00,0x0E,0xF8,0x00,0x0E,0x7C,0x00,0x0E,0x3E,0x00,0x0E,0x1E,0x00,0x0E,0x0F,0x00,0x0E,0x07,0x80,0x0E,0x03,0xC0,0x0E,0x03,0xC0,0x0E,0x01,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // K
0x00,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0xFF,0xE0,0x07,0xFF,0xE0,0x07,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // L
0x00,0x00,0x00,0x03,0x00,0x60,0x03,0x80,0xF0,0x07,0x80,0xF0,0x07,0x80,0xF0,0x06,0xC1,0xB0,0x06,0xC1,0xB0,0x06,0xE3,0xB0,0x06,0x63,0x30,0x06,0x63,0x30,0x06,0x77,0x30,0x06,0x36,0x30,0x06,0x36,0x30,0x06,0x3E,0x30,0x06,0x1C,0x38,0x0E,0x1C,0x38,0x0E,0x00,0x38,0x0E,0x00,0x38,0x0E,0x00,0x38,0x0E,0x00,0x38,0x0E,0x00,0x38,0x0E,0x00,0x38,0x0E,0x00,0x38,0x0E,0x00,0x38,0x0E,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // M
0x00,0x00,0x00,0x07,0x80,0x70,0x07,0xC0,0x70,0x07,0xC0,0x70,0x07,0xE0,0x70,0x07,0xE0,0x70,0x07,0xF0,0x70,0x07,0x70,0x70,0x07,0x70,0x70,0x07,0x38,0x70,0x07,0x38,0x70,0x07,0x1C,0x70,0x07,0x1C,0x70,0x07,0x0E,0x70,0x07,0x0E,0x70,0x07,0x06,0x70,0x07,0x07,0x70,0x07,0x07,0x70,0x07,0x03,0xF0,0x07,0x03,0xF0,0x07,0x01,0xF0,0x07,0x01,0xF0,0x07,0x00,0xF0,0x07,0x00,0xF0,0x07,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // N
0x00,0x00,0x00,0x00,0x7C,0x00,0x01,0xFF,0x00,0x03,0xFF,0x80,0x07,0x83,0xC0,0x0F,0x01,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x1C,0x00,0xF0,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0xF0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0F,0x01,0xE0,0x07,0x83,0xC0,0x03,0xFF,0x80,0x01,0xFF,0x00,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // O

0x00,0x00,0x00,0x07,0xFC,0x00,0x07,0xFF,0x00,0x07,0xFF,0x80,0x07,0x03,0xC0,0x07,0x01,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x01,0xE0,0x07,0x03,0xC0,0x07,0xFF,0x80,0x07,0xFF,0x00,0x07,0xFC,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // P
0x00,0x00,0x00,0x00,0x7C,0x00,0x01,0xFF,0x00,0x03,0xFF,0x80,0x07,0x83,0xC0,0x0F,0x01,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x1C,0x00,0xF0,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0xF0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0F,0x01,0xE0,0x07,0x83,0xC0,0x03,0xFF,0x80,0x01,0xFF,0x00,0x00,0xFE,0x00,0x00,0x38,0x00,0x00,0x3C,0x00,0x00,0x1F,0x00,0x00,0x0F,0xE0,0x00,0x07,0xE0,0x00,0x00,0xC0,0x00,0x00,0x00,  // Q
0x00,0x00,0x00,0x0F,0xF8,0x00,0x0F,0xFE,0x00,0x0F,0xFF,0x00,0x0E,0x07,0x80,0x0E,0x03,0xC0,0x0E,0x01,0xC0,0x0E,0x01,0xC0,0x0E,0x01,0xC0,0x0E,0x01,0xC0,0x0E,0x01,0xC0,0x0E,0x03,0x80,0x0E,0x07,0x80,0x0F,0xFF,0x00,0x0F,0xFE,0x00,0x0F,0xFC,0x00,0x0E,0x1E,0x00,0x0E,0x0E,0x00,0x0E,0x07,0x00,0x0E,0x07,0x00,0x0E,0x03,0x80,0x0E,0x03,0x80,0x0E,0x01,0xC0,0x0E,0x01,0xC0,0x0E,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // R
0x00,0x00,0x00,0x00,0x7F,0x00,0x01,0xFF,0xC0,0x03,0xFF,0xC0,0x03,0xC0,0x80,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x80,0x00,0x03,0xE0,0x00,0x01,0xF8,0x00,0x00,0xFE,0x00,0x00,0x3F,0x80,0x00,0x0F,0xC0,0x00,0x03,0xC0,0x00,0x01,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x04,0x01,0xE0,0x0F,0x03,0xC0,0x0F,0xFF,0xC0,0x07,0xFF,0x80,0x01,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // S
0x00,0x00,0x00,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // T
0x00,0x00,0x00,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0F,0x01,0xE0,0x07,0x01,0xC0,0x07,0x83,0xC0,0x03,0xFF,0x80,0x01,0xFF,0x00,0x00,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // U
0x00,0x00,0x00,0x1C,0x00,0x70,0x1C,0x00,0x70,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x03,0x83,0x80,0x03,0x83,0x80,0x03,0x83,0x80,0x03,0x87,0x80,0x01,0xC7,0x00,0x01,0xC7,0x00,0x01,0xC7,0x00,0x00,0xEE,0x00,0x00,0xEE,0x00,0x00,0xEE,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // V
0x00,0x00,0x00,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x38,0xE0,0x0E,0x38,0xE0,0x0E,0x38,0xE0,0x0E,0x6C,0xE0,0x0E,0x6C,0xE0,0x0E,0x6C,0xE0,0x0E,0xC6,0xE0,0x0E,0xC6,0xE0,0x0E,0xC6,0xE0,0x0F,0x83,0xE0,0x0F,0x83,0xE0,0x0F,0x83,0xE0,0x0F,0x01,0xE0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // W
0x00,0x00,0x00,0x1E,0x00,0xF0,0x0E,0x00,0xE0,0x0F,0x01,0xE0,0x07,0x01,0xC0,0x03,0x83,0x80,0x03,0x83,0x80,0x01,0xC7,0x00,0x01,0xEF,0x00,0x00,0xEE,0x00,0x00,0xFE,0x00,0x00,0x7C,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x7C,0x00,0x00,0xFE,0x00,0x00,0xEE,0x00,0x01,0xC7,0x00,0x03,0xC7,0x80,0x03,0x83,0x80,0x07,0x83,0xC0,0x07,0x01,0xC0,0x0F,0x01,0xE0,0x0E,0x00,0xE0,0x1E,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // X
0x00,0x00,0x00,0x1C,0x00,0x70,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0F,0x01,0xE0,0x07,0x01,0xC0,0x07,0x83,0xC0,0x03,0x83,0x80,0x03,0xC3,0x80,0x01,0xC7,0x00,0x01,0xEF,0x00,0x00,0xEE,0x00,0x00,0xFE,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // Y
0x00,0x00,0x00,0x07,0xFF,0xE0,0x07,0xFF,0xE0,0x07,0xFF,0xE0,0x00,0x01,0xC0,0x00,0x03,0xC0,0x00,0x03,0x80,0x00,0x07,0x00,0x00,0x0F,0x00,0x00,0x0E,0x00,0x00,0x1E,0x00,0x00,0x3C,0x00,0x00,0x38,0x00,0x00,0x78,0x00,0x00,0x70,0x00,0x00,0xE0,0x00,0x01,0xE0,0x00,0x01,0xC0,0x00,0x03,0xC0,0x00,0x03,0x80,0x00,0x07,0x80,0x00,0x07,0x00,0x00,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // Z
0x01,0xFF,0x00,0x01,0xFF,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xFF,0x00,0x01,0xFF,0x00,  // [
0x03,0x80,0x00,0x03,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x1C,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x00,0xE0,0x00,0x00,0xE0,  // <backslash>
0x00,0xFF,0x80,0x00,0xFF,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0xFF,0x80,0x00,0xFF,0x80,  // ]
0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0xEE,0x00,0x00,0xEE,0x00,0x01,0xC7,0x00,0x01,0xC7,0x00,0x03,0xC7,0x80,0x03,0x83,0x80,0x07,0x83,0xC0,0x07,0x01,0xC0,0x0F,0x01,0xE0,0x02,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // ^
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xFF,0xF8,0x3F,0xFF,0xF8,0x3F,0xFF,0xF8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // _

0x00,0x00,0x00,0x00,0x7C,0x00,0x00,0xFE,0x00,0x01,0xC7,0x00,0x01,0x83,0x00,0x01,0x83,0x00,0x01,0x83,0x00,0x01,0xC7,0x00,0x00,0xFE,0x00,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // `
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x01,0xFF,0x80,0x01,0xFF,0xC0,0x01,0x83,0xE0,0x00,0x01,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x7F,0xE0,0x01,0xFF,0xE0,0x03,0xFF,0xE0,0x07,0xC0,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x80,0xE0,0x03,0xFF,0xE0,0x01,0xFF,0xE0,0x00,0x7F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // a
0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x7E,0x00,0x07,0xFF,0x00,0x07,0xFF,0x80,0x07,0x83,0xC0,0x07,0x01,0xC0,0x07,0x01,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x01,0xE0,0x07,0x01,0xC0,0x07,0x07,0xC0,0x07,0xFF,0x80,0x07,0xFF,0x00,0x03,0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // b
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xC0,0x00,0xFF,0xE0,0x03,0xFF,0xE0,0x03,0xE0,0x40,0x07,0x80,0x00,0x07,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x00,0x07,0x80,0x00,0x03,0xE0,0x60,0x03,0xFF,0xE0,0x00,0xFF,0xE0,0x00,0x3F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // c
0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x7E,0xE0,0x00,0xFF,0xE0,0x01,0xFF,0xE0,0x03,0xC1,0xE0,0x03,0x80,0xE0,0x07,0x80,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x80,0xE0,0x03,0x80,0xE0,0x03,0xE0,0xE0,0x01,0xFF,0xE0,0x00,0xFF,0xE0,0x00,0x3F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // d
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7E,0x00,0x01,0xFF,0x00,0x03,0xFF,0x80,0x07,0xC3,0xC0,0x07,0x01,0xC0,0x07,0x00,0xE0,0x0E,0x00,0xE0,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x0E,0x00,0x00,0x0E,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0xC0,0xC0,0x03,0xFF,0xC0,0x01,0xFF,0xC0,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // e
0x00,0x0F,0xC0,0x00,0x3F,0xF0,0x00,0x7F,0xF0,0x00,0x78,0x30,0x00,0xF0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x0F,0xFF,0xC0,0x0F,0xFF,0xC0,0x0F,0xFF,0xC0,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // f
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7F,0x00,0x01,0xFF,0xC0,0x03,0xFF,0xC0,0x07,0x81,0xC0,0x07,0x01,0xC0,0x0F,0x01,0xC0,0x0E,0x01,0xC0,0x0E,0x01,0xC0,0x0E,0x01,0xC0,0x0E,0x01,0xC0,0x0E,0x01,0xC0,0x0E,0x01,0xC0,0x07,0x01,0xC0,0x07,0x83,0xC0,0x03,0xFF,0xC0,0x01,0xFF,0xC0,0x00,0xFD,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x00,0x03,0xC0,0x06,0x07,0x80,0x07,0xFF,0x80,0x07,0xFF,0x00,0x03,0xFC,0x00,0x00,0x00,0x00,  // g
0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0xFC,0x00,0x07,0xFF,0x00,0x07,0xFF,0x80,0x07,0x07,0x80,0x07,0x03,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // h
0x00,0x00,0x00,0x00,0x60,0x00,0x00,0xF0,0x00,0x00,0xF0,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0xF0,0x00,0x0F,0xF0,0x00,0x0F,0xF0,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x70,0x00,0x00,0x78,0x20,0x00,0x3F,0xE0,0x00,0x3F,0xE0,0x00,0x0F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // i
0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x0F,0x00,0x00,0x0F,0x00,0x00,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0x80,0x03,0xFF,0x80,0x03,0xFF,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x00,0x03,0x80,0x06,0x0F,0x00,0x0F,0xFF,0x00,0x0F,0xFE,0x00,0x03,0xF8,0x00,  // j
0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x01,0xE0,0x07,0x03,0xC0,0x07,0x07,0x80,0x07,0x0F,0x00,0x07,0x1E,0x00,0x07,0x3C,0x00,0x07,0x78,0x00,0x07,0xF0,0x00,0x07,0xE0,0x00,0x07,0xF0,0x00,0x07,0x78,0x00,0x07,0x1C,0x00,0x07,0x0F,0x00,0x07,0x07,0x00,0x07,0x03,0x80,0x07,0x03,0xC0,0x07,0x01,0xE0,0x07,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // k
0x07,0xF8,0x00,0x07,0xF8,0x00,0x07,0xF8,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x38,0x00,0x00,0x3C,0x10,0x00,0x1F,0xF0,0x00,0x1F,0xF0,0x00,0x07,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // l
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xE3,0xC0,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x0E,0x3C,0xF0,0x0E,0x1C,0x70,0x0E,0x1C,0x70,0x0E,0x1C,0x70,0x0E,0x1C,0x70,0x0E,0x1C,0x70,0x0E,0x1C,0x70,0x0E,0x1C,0x70,0x0E,0x00,0x70,0x0E,0x00,0x70,0x0E,0x00,0x70,0x0E,0x00,0x70,0x0E,0x00,0x70,0x0E,0x00,0x70,0x0E,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // m
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFE,0x00,0x03,0xFF,0x80,0x03,0xFF,0xC0,0x03,0x83,0xC0,0x03,0x81,0xE0,0x03,0x80,0xE0,0x03,0x80,0xE0,0x03,0x80,0xE0,0x03,0x80,0xE0,0x03,0x80,0xE0,0x03,0x80,0xE0,0x03,0x80,0xE0,0x03,0x80,0xE0,0x03,0x80,0xE0,0x03,0x80,0xE0,0x03,0x80,0xE0,0x03,0x80,0xE0,0x03,0x80,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // n
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7C,0x00,0x01,0xFF,0x00,0x03,0xFF,0x80,0x07,0x83,0xC0,0x07,0x01,0xC0,0x0F,0x01,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x07,0x01,0xE0,0x07,0x01,0xC0,0x07,0x83,0xC0,0x03,0xFF,0x80,0x01,0xFF,0x00,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // o

0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xFC,0x00,0x07,0xFF,0x00,0x07,0xFF,0x80,0x07,0x07,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x01,0xE0,0x07,0x01,0xC0,0x07,0x83,0xC0,0x07,0xFF,0x80,0x07,0xFF,0x00,0x07,0x7C,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,  // p
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0x80,0x00,0xFF,0xE0,0x01,0xFF,0xE0,0x03,0xE0,0xE0,0x03,0x80,0xE0,0x03,0x80,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x80,0xE0,0x03,0x80,0xE0,0x03,0xC1,0xE0,0x01,0xFF,0xE0,0x00,0xFF,0xE0,0x00,0x3E,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,  // q
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0xC0,0x07,0xFF,0xC0,0x07,0xFF,0xC0,0x07,0x80,0x80,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // r
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,0x00,0x01,0xFF,0x80,0x03,0xFF,0x80,0x07,0x81,0x80,0x07,0x00,0x00,0x07,0x00,0x00,0x07,0xC0,0x00,0x03,0xF0,0x00,0x01,0xFE,0x00,0x00,0x7F,0x00,0x00,0x1F,0x80,0x00,0x03,0xC0,0x00,0x01,0xC0,0x00,0x01,0xC0,0x06,0x03,0xC0,0x07,0xFF,0x80,0x07,0xFF,0x80,0x01,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // s
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x0F,0xFF,0xE0,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xE0,0x00,0x00,0xF0,0x20,0x00,0x7F,0xE0,0x00,0x7F,0xE0,0x00,0x1F,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // t
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x81,0xC0,0x03,0xC1,0xC0,0x03,0xFF,0xC0,0x01,0xFF,0xC0,0x00,0x7F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // u
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x70,0x1E,0x00,0xF0,0x0E,0x00,0xE0,0x0E,0x00,0xE0,0x0F,0x01,0xE0,0x07,0x01,0xC0,0x07,0x01,0xC0,0x07,0x83,0xC0,0x03,0x83,0x80,0x03,0x83,0x80,0x03,0xC7,0x00,0x01,0xC7,0x00,0x01,0xEF,0x00,0x00,0xEE,0x00,0x00,0xFE,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x7C,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // v
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x00,0x70,0x1C,0x10,0x70,0x0C,0x38,0xE0,0x0E,0x38,0xE0,0x0E,0x38,0xE0,0x0E,0x28,0xE0,0x0E,0x6C,0xE0,0x0E,0x6C,0xE0,0x06,0x44,0xC0,0x06,0xC6,0xC0,0x06,0xC7,0xC0,0x07,0x87,0xC0,0x07,0x83,0xC0,0x07,0x83,0x80,0x03,0x03,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // w
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1E,0x01,0xE0,0x0F,0x03,0xC0,0x07,0x03,0x80,0x03,0x87,0x80,0x03,0xCF,0x00,0x01,0xEE,0x00,0x00,0xFC,0x00,0x00,0x7C,0x00,0x00,0x78,0x00,0x00,0x7C,0x00,0x00,0xFE,0x00,0x01,0xEE,0x00,0x01,0xC7,0x00,0x03,0xC3,0x80,0x07,0x83,0xC0,0x0F,0x01,0xC0,0x0E,0x01,0xE0,0x1E,0x00,0xF0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // x
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x70,0x0F,0x00,0xF0,0x07,0x00,0xE0,0x07,0x00,0xE0,0x07,0x80,0xE0,0x03,0x81,0xE0,0x03,0x81,0xC0,0x03,0xC1,0xC0,0x01,0xC3,0xC0,0x01,0xC3,0x80,0x01,0xE3,0x80,0x00,0xE7,0x80,0x00,0xF7,0x80,0x00,0x77,0x00,0x00,0x7F,0x00,0x00,0x3E,0x00,0x00,0x3E,0x00,0x00,0x1E,0x00,0x00,0x3C,0x00,0x00,0x3C,0x00,0x00,0x78,0x00,0x0F,0xF0,0x00,0x0F,0xF0,0x00,0x0F,0xC0,0x00,  // y
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0xFF,0xC0,0x07,0xFF,0xC0,0x07,0xFF,0xC0,0x00,0x03,0x80,0x00,0x07,0x80,0x00,0x0F,0x00,0x00,0x1E,0x00,0x00,0x1C,0x00,0x00,0x38,0x00,0x00,0x78,0x00,0x00,0xF0,0x00,0x00,0xE0,0x00,0x01,0xE0,0x00,0x03,0xC0,0x00,0x03,0x80,0x00,0x07,0xFF,0xC0,0x07,0xFF,0xC0,0x07,0xFF,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  // z
};


/// @endcond
