/*!
	@file    FontGll_LTSM.hpp
	@author  Gavin Lyons
	@brief   Library font file for gll font.
*/

#pragma once
#include <display16_common_LTSM.hpp>

// === Font Data ===

/// @cond

/*!
	Standard ASCII 8x8 font
	ASCII Range 59 chars (no lowercase letters)
	Memory usage : 476 bytes
*/
static const uint8_t FontGll[476] FLASH_STORAGE = {
0x08,0x08,0x20,0x3A,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x80, 0x00, // '!'
0xA0, 0xA0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // '"'
0x28, 0x28, 0x7C, 0x28, 0x7C, 0x28, 0x28, 0x00, // '#'
0x10, 0x3C, 0x50, 0x38, 0x14, 0x78, 0x10, 0x00, // '$'
0xC2, 0xC6, 0x0C, 0x18, 0x30, 0x63, 0xC3, 0x00, // '%'
0x30, 0x48, 0x30, 0x4A, 0x44, 0x44, 0x3A, 0x00, // '&'
0xC0, 0x40, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, // '''
0x10, 0x20, 0x40, 0x40, 0x40, 0x20, 0x10, 0x00, // '('
0x40, 0x20, 0x10, 0x10, 0x10, 0x20, 0x40, 0x00, // ')'
0x00, 0x28, 0x38, 0x7C, 0x38, 0x28, 0x00, 0x00, // '*'
0x00, 0x10, 0x10, 0x7C, 0x10, 0x10, 0x00, 0x00, // '+'
0x00, 0x00, 0x00, 0x00, 0x30, 0x10, 0x20, 0x00, // ','
0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00, // '-'
0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x30, 0x00, // '.'
0x02, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0x00, // '/'
0x38, 0x44, 0x4C, 0x54, 0x64, 0x44, 0x38, 0x00, // '0'
0x10, 0x30, 0x10, 0x10, 0x10, 0x10, 0x7C, 0x00, // '1'
0x38, 0x44, 0x04, 0x18, 0x20, 0x40, 0x7C, 0x00, // '2'
0x38, 0x44, 0x04, 0x18, 0x04, 0x44, 0x38, 0x00, // '3'
0x08, 0x18, 0x28, 0x48, 0x7C, 0x08, 0x08, 0x00, // '4'
0x7C, 0x40, 0x78, 0x04, 0x04, 0x44, 0x38, 0x00, // '5'
0x38, 0x44, 0x40, 0x78, 0x44, 0x44, 0x38, 0x00, // '6'
0x7C, 0x04, 0x08, 0x10, 0x20, 0x20, 0x20, 0x00, // '7'
0x38, 0x44, 0x44, 0x38, 0x44, 0x44, 0x38, 0x00, // '8'
0x38, 0x44, 0x44, 0x3C, 0x04, 0x44, 0x38, 0x00, // '9'
0x00, 0x30, 0x30, 0x00, 0x30, 0x30, 0x00, 0x00, // ':'
0x00, 0x30, 0x30, 0x00, 0x30, 0x10, 0x20, 0x00, // ';'
0x0C, 0x18, 0x30, 0x60, 0x30, 0x18, 0x0C, 0x00, // '<'
0x00, 0x00, 0x7C, 0x00, 0x7C, 0x00, 0x00, 0x00, // '='
0x30, 0x18, 0x0C, 0x06, 0x0C, 0x18, 0x30, 0x00, // '>'
0x38, 0x44, 0x04, 0x18, 0x10, 0x00, 0x10, 0x00, // '?'
0x38, 0x44, 0x54, 0x5C, 0x40, 0x44, 0x38, 0x00, // '@'
0x10, 0x28, 0x44, 0x44, 0x7C, 0x44, 0x44, 0x00, // 'A'
0x78, 0x44, 0x44, 0x78, 0x44, 0x44, 0x78, 0x00, // 'B'
0x38, 0x44, 0x40, 0x40, 0x40, 0x44, 0x38, 0x00, // 'C'
0x70, 0x48, 0x44, 0x44, 0x44, 0x48, 0x70, 0x00, // 'D'
0x7C, 0x40, 0x40, 0x78, 0x40, 0x40, 0x7C, 0x00, // 'E'
0x7C, 0x40, 0x40, 0x78, 0x40, 0x40, 0x40, 0x00, // 'F'
0x38, 0x44, 0x40, 0x40, 0x4C, 0x44, 0x38, 0x00, // 'G'
0x44, 0x44, 0x44, 0x7C, 0x44, 0x44, 0x44, 0x00, // 'H'
0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, // 'I'
0x1C, 0x08, 0x08, 0x08, 0x08, 0x48, 0x30, 0x00, // 'J'
0x44, 0x48, 0x50, 0x60, 0x50, 0x48, 0x44, 0x00, // 'K'
0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7C, 0x00, // 'L'
0x44, 0x6C, 0x54, 0x54, 0x44, 0x44, 0x44, 0x00, // 'M'
0x44, 0x64, 0x54, 0x4C, 0x44, 0x44, 0x44, 0x00, // 'N'
0x38, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, // 'O'
0x78, 0x44, 0x44, 0x78, 0x40, 0x40, 0x40, 0x00, // 'P'
0x38, 0x44, 0x44, 0x44, 0x54, 0x48, 0x34, 0x00, // 'Q'
0x78, 0x44, 0x44, 0x78, 0x50, 0x48, 0x44, 0x00, // 'R'
0x38, 0x44, 0x40, 0x38, 0x04, 0x44, 0x38, 0x00, // 'S'
0x7C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, // 'T'
0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00, // 'U'
0x44, 0x44, 0x44, 0x44, 0x44, 0x28, 0x10, 0x00, // 'V'
0x44, 0x44, 0x44, 0x54, 0x54, 0x54, 0x28, 0x00, // 'W'
0x44, 0x44, 0x28, 0x10, 0x28, 0x44, 0x44, 0x00, // 'X'
0x44, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x00, // 'Y'
0x7C, 0x04, 0x08, 0x10, 0x20, 0x40, 0x7C, 0x00 // 'Z'
};

/// @endcond
