[![Website](https://img.shields.io/badge/Website-Link-blue.svg)](https://gavinlyonsrepo.github.io/)  [![Rss](https://img.shields.io/badge/Subscribe-RSS-yellow.svg)](https://gavinlyonsrepo.github.io//feed.xml)  [![Donate](https://img.shields.io/badge/Donate-PayPal-green.svg)](https://www.paypal.com/paypalme/whitelight976)

# TM1638plus 

## Table of contents

  * [Overview](#overview)
  * [Installation](#installation)
  * [Software](#software)
  * [Documentation](#documentation)
  * [Tested](#tested)

## Overview

* Name: TM1638plus
* Description: 

An Arduino library to display data on a 8-digit TM1638 seven segment module's.
This library supports all 3 of the known models on market. see Documentation section below.
As of version 2.2.0 the library also supports TM1637 & MAX7219 seven segment module's.

* Main Author: Gavin Lyons.

## Installation

The library is included in the official Arduino library manger and the optimum way to install it 
is using the library manager which can be opened by the *manage libraries* option in Arduino IDE. 
Search "tm1638" in search bar of library manager to find it.

See link below for instruction for this and for the other methods too.

[Installing Additional Arduino Libraries guide](https://www.arduino.cc/en/Guide/Libraries)

## Software 

The API (application programming interface)  html documentation is at link. Hosted on github pages and generated by Doxygen software. Here the user will find lots of information on files, functions & data types. 

[Software API Url Link](https://gavinlyonsrepo.github.io/misc/software_docs/TM1638plus/index.html)

### Class system

![ pics ](https://github.com/gavinlyonsrepo/TM1638plus/blob/master/extra/images/class.png)

### Debug messages 

Debug messages can be turned on by setting displaylib_LED_debug to true, these will be sent
to serial monitor in event of some error's or warning's. 

## Documentation

This library supports three variants of the TM1638, which for purposes of this documentation, 
will be named Model 1, Model 2 and Model 3.   
The library also supports two variants of TM1637(model 4 & 5),  
and the MAX7219 seven segment modules(model 6)

| Model Name | PCB Labels | LEDs | Push buttons | Digits |
| ------ | ------ |  ------ | ------ | ------ |
| Model 1 | TM1638 LED & KEY | 8 red only | 8 | 8 |
| Model 2 | TM1638 KEYS, QYF  | 0 | 16 | 8 |
| Model 3 | TM1638 V1.3 or LKM1638 | 8 bi color, red or green| 8 | 8 |
| Model 4 | TM1637 | centered semi:colon | 0 | 4 |
| Model 5 | TM1637 | 0 | 0 | 4|
| Model 6 | MAX7219 | 0 | 0 |8|

| Component name | Type | Interface | Readme URL link |
| -------- | ---------- | --------- | ---------- |
| TM1638 |seven segment module|GPIO| [Readme](extra/doc/tm1638/README.md)|
| TM1637|seven segment module|GPIO| [Readme](extra/doc/tm1637/README.md)|
| MAX7219|seven segment module|SPI HW & SW| [Readme](extra/doc/max7219/README.md)|

Models 1-3 Pictured left to right.

![ model pics ](https://github.com/gavinlyonsrepo/TM1638plus/blob/master/extra/images/tm16383.jpg)

Model 4-5 

![ model 45 pic](https://github.com/gavinlyonsrepo/TM1638plus/blob/master/extra/images/model45.jpg)

Model 6 

![ max pic](https://github.com/gavinlyonsrepo/TM1638plus/blob/master/extra/images/max.jpg)


## Tested


* Tested on following MCU  & Development platforms.
* Examples files are set up for Arduino UNO R4
* File GPIO_OTHER_MCUs.txt in extra folder gives pins tested  for other MCU(tm1638)

1. Arduino UNO & NANO v3.
2. ESP32.
3. STM32 STM32F103C8T6 "the blue pill".
4. ESP8266.
5. Teensy 4.0. (may not work at highest frequency see  note #2 in notes section)
6. Arduino R4 minima 


