/*!
	@file seven_segment_font_data.cpp
	@brief Implementation of the SevenSegmentFont class, font data file seven segment font
	@author Gavin Lyons.
 */

#include "seven_segment_font_data.h"

/*!
 	@brief Font data table for ASCII values mapped to seven-segment representation.
 	 	Offset starts at ASCII value 32 (space).
 		Encoded in dp-gfedcba bit order.
 */
const uint8_t SevenSegmentFont::fontData[91] = {
	0x00, 0x86, 0x22, 0x7E, 0x6D, 0xD2, 0x46, 0x20, 0x29, 0x0B, /* space - ) */
	0x21, 0x70, 0x10, 0x40, 0x80, 0x52, 0x3F, 0x06, 0x5B, 0x4F, /* * - 3 */
	0x66, 0x6D, 0x7D, 0x07, 0x7F, 0x6F, 0x09, 0x0D, 0x61, 0x48, /* 4 - = */
	0x43, 0xD3, 0x5F, 0x77, 0x7C, 0x39, 0x5E, 0x79, 0x71, 0x3D, /* > - G */
	0x76, 0x30, 0x1E, 0x75, 0x38, 0x15, 0x37, 0x3F, 0x73, 0x6B, /* H - Q */
	0x33, 0x6D, 0x78, 0x3E, 0x3E, 0x2A, 0x76, 0x6E, 0x5B, 0x39, /* R - [ */
	0x64, 0x0F, 0x23, 0x08, 0x02, 0x5F, 0x7C, 0x58, 0x5E, 0x7B, /* \ - e */
	0x71, 0x6F, 0x74, 0x10, 0x0C, 0x75, 0x30, 0x14, 0x54, 0x5C, /* f - o */
	0x73, 0x67, 0x50, 0x6D, 0x78, 0x1C, 0x1C, 0x14, 0x76, 0x6E, /* p - y */
	0x5B                                                        /* z  */
};

/*!
	@brief Retrieves a pointer to the seven-segment font data table.
	@return Pointer to the font data array.
 */
const uint8_t *SevenSegmentFont::pFontSevenSegptr() 
{
	return fontData;
}


