## Release 1.4.1 - 2024/12/2

1. 紧急修复了在禁用 `DYNAMIC_PIN_SETTINGS` 之后点不亮屏幕的bug

## Release 1.4.0 - 2024/12/1

### 新增内容

1. 新增用户引脚配置数据字段的读取和写入接口

2. 附加了时间管理库, 位于 `extra/ctg_timelib` 文件夹内. 本库可用于替代 [Arduino TimeLib](https://github.com/PaulStoffregen/Time), 使ESPxxxx系列主控可以与GNU C time库使用同一个时间访问接口, 并显著减小代码体积.

3. 新增 `getDepth` 函数, 用于获得当前墨水屏的显示颜色深度

4. 新增 `setAutoFullRefresh` 函数, 可用于设置自动慢刷, 防止连续快刷导致屏幕对比度降低甚至刷坏屏幕

5. 新增 `screenshot` 函数, 可截屏并保存在SD卡中.

6. 新增 `SDdeinit` 函数, 调用后SD卡将会不可用, 用于安全卸载SD卡或者重新检测SD卡的可用性.

7. 新增 `recoverI2C` 函数, 在I2C引脚被复用的情形下, 使用I2C功能会影响其他引脚的复用功能. 该函数可以在I2C用完之后还原这些复用引脚的功能设置

8. 新增 `setSDbusy` 函数, 在SD卡的CS引脚被复用作按键时, 调用 `setSDbusy(1)` 标记此时SD卡正在被占用, `setSDbusy(0)` 来释放. **该函数仅建议在需要兼容SD卡被复用作按键的硬件上使用. 其他情况用处不大. 前往** `guy_driver_config.h` **文件并禁用宏** `READGUY_ALLOW_SDCS_AS_BUTTON` **是最佳选择**

9. 新增实验性功能 `READGUY_ALLOW_DC_AS_BUTTON`, `READGUY_ALLOW_EPDCS_AS_BUTTON`, `READGUY_ALLOW_SDCS_AS_BUTTON`, 详见文件 `guy_driver_config.h` .

10. 内置服务器功能现在支持设置请求类型为 UPLOAD, HEAD, POST, PUT, PATCH, DELETE 和 OPTIONS 的服务函数, 以及请求返回 404 Not Found 的响应.

### 优化

1. 优化了大部分代码结构 (给一些函数加上const和inline标志, 提高效率) , 并修复了部分变量未初始化就调用的bug

2. 优化了配置网页的结构, 现在配置引脚的按钮在网页最下方了

3. 优化部分示例程序, 增加并更新部分注释, 更易读 更易用

4. 完全移除了内部对 RTC 的支持.

5. 为 1.54 寸 LilyGo 屏幕, 2.9 寸前置光屏幕和 2.7 寸屏幕提供了睡眠模式下快速唤醒的支持.

6. 为 LCD 墨水屏模拟器提供了快速但不支持同屏灰度的模拟模式.

### Bug 修复

1. 修复在禁用 dynamic_pin_settings 时, 数组访问越界的bug

2. 修复了禁用 WiFi 功能但未配置引脚时, 程序会异常继续运行的bug

3. 按键任务函数结构重构, 解决了按键被复用时, 无法设置按键为高电平触发的情况

## Release 1.3.7 - 2024/3/11

1. 配网页面, 增加了用户引脚数据 (可以配置其他功能的引脚. 此功能似乎是为了准备给esp32s3用sdmmc库驱动sd卡用的)

2. 增加 `guy_button` 按键库功能的接口函数

3. 修复部分bug

## Release 1.3.6 - 2024/3/11

1. 按键功能: 正式更新特殊操作按法, 此按法可用于切换输入法或菜单定位等功能. 同时更新ex03演示, 演示更清晰.

2. 修复其他bug, 比如示例wifi-text-show中, 中文网页无法在windows系统上呈现等...

## Release 1.3.5 - 2024/3/4

1. 2024/2/25更新: 修复了按键bug, 双按键有时候识别不灵, 三按键不支持移植到拨轮硬件操作, 现在全修好了

2. 2024/2/26更新: 增加了新环境 : 针对无串口芯片的 ESP32C3 新增的选项

3. 2024/2/28更新: 增加了新的示例: WiFi传文本

4. 优化ESP32C3的配置体验

## Release 1.3.4 - 2023/11/24

1. 添加5.83寸屏幕驱动. 默认开启, 嫌flash占用大的可以手动关

2. 修复别的一些bug

## Release 1.3.3 - 2023/11/12

1. 添加了2.66寸三色和黑白的不同驱动程序.

2. guy_epaper 文件夹内添加了一些文件. 为添加新版本驱动做准备.

3. 现在SD卡功能是可移除的. 可以自定义文件系统来初始化并使用. 但是对应的, SD卡引脚设定保留.

4. 优化按键手势的按动手感.

5. 重构了"固定引脚"(DYNAMIC_PIN_SETTINGS被注释)的宏定义逻辑代码. 现在如果在运行过"固定引脚"的程序之后, 再运行常规固件不需要二次配置.

6. 增大了S3的按钮任务栈空间, 避免因为stack overflow导致的任务终止.

7. 修复若干其他方面的bug, 比如配置引脚时, 屏幕没转向.

## Release 1.3.2 - 2023/11/8

1. 按键驱动 (guy_button) 获得新操作更新: (New button gesture)
  
  - 单按键操作更新: 现在双击效果为选择/确定, 三击效果为返回, 长按效果为向上翻页;

  - 单按键新增点按后长按操作; 

  - 双按键新增按住按键1点按按键2操作;

  - 三按键新增按住按键1点按按键3操作.

2. 新增获取系统内存的API函数 getFreeMem().

3. 修复若干驱动层bug.

## Release 1.3.1 - 2023/11/7

1. 增加了分步绘制的支持. 可以使用 READGUY_FAST_START 等绘制选项来控制绘制过程:
  
  - READGUY_SLOW       慢刷, 完整的进行一次慢刷, 等于连续执行慢刷开始和慢刷结束.

  - READGUY_FAST       快刷, 完整的进行一次快刷, 需要等待刷完才能继续执行代码.

  - READGUY_SLOW_START 慢刷开始, 此过程不会进行等待, 发送完要刷新的缓存之后立刻返回

  - READGUY_FAST_START 快刷开始.

  - READGUY_SLOW_END   慢刷结束, 调用慢刷开始之后才能执行. 会等待到屏幕刷完再执行后续操作.

  - READGUY_FAST_END   快刷结束, 如果两次调用间隔时间屏幕已经刷完, 那么该函数会完成刷屏后续操作之后立刻返回.

2. 修复了首次配置驱动时, 墨水屏显示页面错位的bug (现在对于新设备, 配置起来会像以前一样丝滑)

3. 修复若干其他bug

## Release 1.3.0 - 2023/11/6

1. 增加了真.保姆级的教程 (详细到注释比代码多很多倍)

2. 目前所有支持的屏幕设备都可以在主控复位之后, 不需要调用init函数即可直接快刷(也不会变成慢刷). 为此, 调用init函数之后, 会让屏幕的下一次刷新变为慢刷.

3. 优化了所有的驱动程序. 包括灰度效果, 内存占用等.

4. 增加了更多的图片显示示例程序. 现在支持多种图片显示方式:

  4.1. 在内存中开辟新画布(sprite). 支持颜色格式有1,2,4,8bit灰度(greyscale), 1,2,4,8bit调色板(palette), 8bit-RGB332, 16bit-RGB565, 24bit-RGB888.

  4.2. 画布可以用抖动算法在屏幕上显示为二值图.
  
  4.3. 画布可以在屏幕上显示为16级灰度图.
  
  4.4. 画布可以显示在屏幕缓存中, 此过程不刷新屏幕. 下次刷新屏幕时, 画布内容将呈现在屏幕缓存中.

  4.5. 将画布缩放到指定的宽度和高度后显示.

  4.6. 显示BMP, JPG, PNG(仅限ESP32系列)图片文件到画布上.

  4.7. 直接将图片文件刷新到屏幕上, 无需画布(sprite).

  4.8. 将图片文件显示到屏幕缓存内, (不显示).

  4.9. 将图片文件以16级灰度显示到屏幕上, 无需画布(sprite).

  4.10. 缩放显示图片文件, 需要指定缩放比例. >1.0为放大, <1.0为缩小. (float scale_x, float scale_y).

5. 修复若干bug.

## Release 1.2.0 - 2023/11/3

1. 添加了图片demo, 和 可选关闭的WiFi 的示例程序。其中图片相关功能相当节省内存, 还请大胆使用。

2. 新增了接口函数 getReadguy...(), guyMemoryWidth(), guyMemoryHeight(), guyDriverWidth(), guyDriverHeight() 等函数, 可以在程序内获取到一些硬件相关信息。

3. 增加了保姆级教程, 比现有教程更加简单易用。

4. 修复了一些bug。现在4.2寸HINK屏幕的16灰度刷新不会导致内存溢出了.

## Release 1.1.1 - 2023/10/20

1. 引脚配置页更新，内置预设开发板的引脚预定义。此选项的内置定义可以被用户更改成自己的板子预定义。

2. 可以配置wifi并对时。

3. 支持在库内设置i2c总线。实际i2c功能需要自己编写程序，本库只提供了i2c引脚的定义接口。此次更新之后，设备需要重新配网。

4. 支持16级灰度的抖动算法，并可在编译时切换显示算法。

5. 添加了更多例程，例程注释更简洁易用。比如 WiFi获取时间demo, 按键demo, 文本和字体demo, 使用静态引脚定义的demo.

6. 修复了一些bug.

## Release 1.1.0 - 2023/09/25

1. 可以配网了 也可以在线更新固件了. 注意在2MB flash的硬件上是无法通过在线更新固件的. 现在还需要你通过示例来进行配网!

2. 增加了更多示例程序.

3. 修复了一些bug

4. 适配了16级灰度的floyd steinberg抖动算法, 提升了灰度的画质 (显示灰度渐变色, 则不会产生色块, 而是自然的像素抖动)

### Release 1.0.2 - 2023/09/24

1. 进行了ESP32C3, ESP32S3和ESP32S2的功能测试.

2. 修复了一些bug, 包括可能会让一部分内存被两个任务连续释放导致ESP32触发assert的问题.

3. 更新了一些示例.

### Release 1.0.1 - 2023/09/23

1. 更改文件结构 (Git:我谢谢你). 现在可以像arduino库一样使用readguy了.

2. 优化platformio.ini的描述, 现在对新人开发者来说结构更清晰了.

3. 合并了 2.66英寸(Vusion价签屏) 和2.13英寸B型(红黑白三色屏和部分价签屏) 的驱动程序.

4. 现在支持使用arduino IDE进行项目开发.

5. 修复了若干bug

# Release 1.0.0 - 2023/09/18

可以通过WiFi进行配置显示屏和SD卡设置. 目前支持 1.54, 2.13, 2.66, 2.9, 3.7, 4.2 英寸的10种屏幕

开发只能使用 lovyanGFX 库的函数来绘制到EPD屏幕上.

目前有按键的驱动和背光的驱动, 但是因为此项目只有驱动程序, 还不能阅读, 只有墨水屏的demo.

关于都支持哪些屏幕可以看readme

# Pre-alpha 0.0.1 - 2022/11/23

可以通过WiFi进行配置显示屏和SD卡设置. 目前只支持4种屏幕

开发可以使用adafruit_GFX的函数来绘制到EPD屏幕上.

目前没有按键的驱动, 还不能阅读, 只有墨水屏的demo.
