## How to contribute to LcdMenu

### **Did you find a bug?**

* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/forntoh/LcdMenu/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/forntoh/LcdMenu/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

### **Did you write a patch that fixes a bug?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

### **Did you fix whitespace, format code, or make a purely cosmetic patch?**

Changes that are cosmetic in nature and do not add anything substantial to the stability, functionality, or testability of LcdMenu will generally not be accepted.

### **Do you intend to add a new feature or change an existing one?**

* Suggest your change in the [ideas category of the discussions tab](https://github.com/forntoh/LcdMenu/discussions/categories/ideas) and start writing code.

* Do not open an issue on GitHub until you have collected positive feedback about the change. GitHub issues are primarily intended for bug reports and fixes.

* **Make sure that you apply the [separation of concerns](https://en.wikipedia.org/wiki/Separation_of_concerns) rule.**

* **Must include** an example project using the new feature.
  * All examples should be saved like `examples/[myexample]/[myexample].ino`
  * **Why? This project contains workflows that run automatically when a pull request is opened, the workflow compiles the project and checks for compatibility issues, you don't need the owner of the repo to run checks.**

### **Do you have questions about the source code?**

* Ask any question about how to use LcdMenu in the [Q&A](https://github.com/forntoh/LcdMenu/discussions/categories/q-a).

Thanks! :heart: :heart: :heart:

Forntoh Thomas
