#include "TS_lib.h"
#include "Arduino.h"
#include "communication.h"

TS_lib::TS_lib(const Stream* s1) 
	: TS_lib(s1, &Rt_values{}, &Page{}, 0) {} 

TS_lib::TS_lib(const Stream* s1, const Rt_values* rt_values, const Page* pages, const uint16_t num_pages) {
	_serial1 = s1;
	_rt_data = Rt_data(rt_values);
	_pages = Pages(pages, num_pages);
	_pages.loadStoredPages();
	_comm = Communication(_serial1, DEFAULT_CODE_VERSION, &_rt_data, &_pages);
	_comm_legacy = Communication_legacy(_serial1, DEFAULT_CODE_VERSION);
}

void TS_lib::update() {
	if (_serial1->available() > 0) {
		if (_comm_legacy.isLegacy(_serial1->peek())) {
			_comm_legacy.serialReceiveLegacy();
		} else {
			_comm.serialReceive();
		}
	}
}


void TS_lib::setCodeVersion(const char* code_version) {
	_code_version = code_version;
	_comm.setCodeVersion(code_version);
	_comm_legacy.setCodeVersion(code_version);
}

char* TS_lib::getCodeVersion(void) {
	return _code_version;
}

void TS_lib::setPages(const Page* pages, const uint16_t num_pages) {
	_pages.setPages(pages, num_pages);
	_pages.loadStoredPages();
}

void TS_lib::setRtData(const Rt_values* rt_values) {
	_rt_data.setRtValues(rt_values);
}

Page* TS_lib::getPages(void) {
	return _pages.getPages();
}

Page* TS_lib::getPage(const uint16_t pageNum) {
	_pages.getPage(pageNum);
}

Rt_values* TS_lib::getRtData(void) {
	return _rt_data.getRtValues();
}
