/**
 * @file BacklightColors.cpp
 * @brief Implementation of the BacklightColors class, defining RGB values for various colors.
 *
 * The BacklightColors class provides predefined RGB color constants for use in projects
 * requiring consistent color definitions.
 */

#include "BacklightColors.h"

const int BacklightColors::BLACK[3] = {0, 0, 0};         ///< Black color (0, 0, 0).
const int BacklightColors::WHITE[3] = {255, 255, 255};   ///< White color (255, 255, 255).
const int BacklightColors::HOTPINK[3] = {255, 10, 127};  ///< Hot Pink color (255, 10, 127).
const int BacklightColors::RED[3] = {255, 10, 10};       ///< Red color (255, 10, 10).
const int BacklightColors::ORANGE[3] = {255, 127, 10};   ///< Orange color (255, 127, 10).
const int BacklightColors::YELLOW[3] = {255, 255, 10};   ///< Yellow color (255, 255, 10).
const int BacklightColors::LIME[3] = {127, 255, 10};     ///< Lime Green color (127, 255, 10).
const int BacklightColors::GREEN[3] = {10, 255, 10};     ///< Green color (10, 255, 10).
const int BacklightColors::TEAL[3] = {10, 255, 127};     ///< Teal color (10, 255, 127).
const int BacklightColors::CYAN[3] = {10, 255, 255};     ///< Cyan color (10, 255, 255).
const int BacklightColors::SKY[3] = {10, 127, 255};      ///< Sky Blue color (10, 127, 255).
const int BacklightColors::BLUE[3] = {10, 10, 255};      ///< Blue color (10, 10, 255).
const int BacklightColors::PURPLE[3] = {127, 10, 255};   ///< Purple color (127, 10, 255).
const int BacklightColors::MAGENTA[3] = {255, 10, 255};  ///< Magenta color (255, 10, 255).
