// Example for the SPY functionality of the library.
//  The ppm signal to be analyzed must be provided on pin rx_pin
//  This example willnot run on an ESP32. Use an ESP32C3 for example.
//
//  Please change the definition of the rx_pin (tx_pin) ....
//  For just a demo, you can have a ppm signal generated by the application:
//     If you want to use it, you must connect pin rx_pin and tx_pin
//     See some lines in comment.

#include <ESP32_ppm.h>
//#define  generatePPM // uncomment if yo want to generate the ppm signal in the demo.Put a jumper between rx_pin and tx_pin

// for ESP32C3 S32 Dev kit
#define rx_pin 6
#ifdef generatePPM
#define tx_pin 7
#endif

#define spyDuration 10000  // duration of test in ms

result_ppmSpy_t* ppmResultSpy;
ppmSpy myPPM_Spy;

#ifdef generatePPM
int* ppmArrayTX;
ppmWriter myPPM_TX(FALLING);
#endif

void setup()
{
  Serial.begin(115200);
  delay(3000);
  Serial.printf("Starting ppm spy analysis on pin %d during %dms.\n", rx_pin, spyDuration);

#ifdef generatePPM
  Serial.printf(" The ppm signal is generated by the demo: put a jumper between pins %d and %d.\n", rx_pin, tx_pin);
  ppmArrayTX = myPPM_TX.begin(tx_pin);
  myPPM_TX.startTest(10); //
#endif
  ppmResultSpy = myPPM_Spy.begin(rx_pin);
  if (ppmResultSpy == NULL) {
    Serial.println("Error. ppmSpy not available with this configuration? (not supported by ESP32 ?)");
    while (true) {delay(500);}
  }
  myPPM_Spy.start(spyDuration); // Default is 1000 (1s)
  Serial.printf("Started ... Reading on pin %d\n", rx_pin);
}

void loop() {
  if (myPPM_Spy.doneSpy()) {
    Serial.println("The end ...");
    Serial.printf("polarity:%s\nmaxFrame:%d\tminFrame:%d\n", (ppmResultSpy->polarity == RISING ? "RISING" : "FALLING"),
                  ppmResultSpy->maxFrame, ppmResultSpy->minFrame);
    Serial.printf("maxLow:%d\tminLow:%d\nmaxHigh:%d\tminHigh:%d\n",
                  ppmResultSpy->maxLow, ppmResultSpy->minLow,
                  ppmResultSpy->maxHigh, ppmResultSpy->minHigh);
    Serial.printf("minChan:%d\tmaxChan:%d\n", ppmResultSpy->minChan, ppmResultSpy->maxChan);
  }
}
