/*
 * SPDX-FileCopyrightText: 2024-2025 Espressif Systems (Shanghai) CO LTD
 *
 * SPDX-License-Identifier: Apache-2.0
 */
#pragma once

// *INDENT-OFF*

#ifndef ESP_PANEL_BOARD_USE_EXPANDER
    #ifdef CONFIG_ESP_PANEL_BOARD_USE_EXPANDER
        #define ESP_PANEL_BOARD_USE_EXPANDER CONFIG_ESP_PANEL_BOARD_USE_EXPANDER
    #else
        #define ESP_PANEL_BOARD_USE_EXPANDER 0
    #endif
#endif

#if ESP_PANEL_BOARD_USE_EXPANDER
// Chip
#ifndef ESP_PANEL_BOARD_EXPANDER_CHIP
    #ifdef CONFIG_ESP_PANEL_BOARD_EXPANDER_CHIP_CH422G
        #define ESP_PANEL_BOARD_EXPANDER_CHIP CH422G
    #elif defined(CONFIG_ESP_PANEL_BOARD_EXPANDER_CHIP_HT8574)
        #define ESP_PANEL_BOARD_EXPANDER_CHIP HT8574
    #elif defined(CONFIG_ESP_PANEL_BOARD_EXPANDER_CHIP_TCA95XX_8BIT)
        #define ESP_PANEL_BOARD_EXPANDER_CHIP TCA95XX_8BIT
    #elif defined(CONFIG_ESP_PANEL_BOARD_EXPANDER_CHIP_TCA95XX_16BIT)
        #define ESP_PANEL_BOARD_EXPANDER_CHIP TCA95XX_16BIT
    #else
        #error "Missing configuration: ESP_PANEL_BOARD_EXPANDER_CHIP_*"
    #endif
#endif

// Skip bus host initialization
#ifndef ESP_PANEL_BOARD_EXPANDER_SKIP_INIT_HOST
    #ifdef CONFIG_ESP_PANEL_BOARD_EXPANDER_SKIP_INIT_HOST
        #define ESP_PANEL_BOARD_EXPANDER_SKIP_INIT_HOST CONFIG_ESP_PANEL_BOARD_EXPANDER_SKIP_INIT_HOST
    #else
        #define ESP_PANEL_BOARD_EXPANDER_SKIP_INIT_HOST 0
    #endif
#endif

// I2C bus settings
#ifndef ESP_PANEL_BOARD_EXPANDER_I2C_HOST_ID
    #ifdef CONFIG_ESP_PANEL_BOARD_EXPANDER_I2C_HOST_ID
        #define ESP_PANEL_BOARD_EXPANDER_I2C_HOST_ID CONFIG_ESP_PANEL_BOARD_EXPANDER_I2C_HOST_ID
    #else
        #error "Missing configuration: ESP_PANEL_BOARD_EXPANDER_I2C_HOST_ID"
    #endif
#endif
#ifndef ESP_PANEL_BOARD_EXPANDER_I2C_ADDRESS
    #ifdef CONFIG_ESP_PANEL_BOARD_EXPANDER_I2C_ADDRESS
        #define ESP_PANEL_BOARD_EXPANDER_I2C_ADDRESS CONFIG_ESP_PANEL_BOARD_EXPANDER_I2C_ADDRESS
    #else
        #error "Missing configuration: ESP_PANEL_BOARD_EXPANDER_I2C_ADDRESS"
    #endif
#endif
#if !ESP_PANEL_BOARD_EXPANDER_SKIP_INIT_HOST
    #ifndef ESP_PANEL_BOARD_EXPANDER_I2C_CLK_HZ
        #ifdef CONFIG_ESP_PANEL_BOARD_EXPANDER_I2C_CLK_HZ
            #define ESP_PANEL_BOARD_EXPANDER_I2C_CLK_HZ CONFIG_ESP_PANEL_BOARD_EXPANDER_I2C_CLK_HZ
        #else
            #error "Missing configuration: ESP_PANEL_BOARD_EXPANDER_I2C_CLK_HZ"
        #endif
    #endif
    #ifndef ESP_PANEL_BOARD_EXPANDER_I2C_IO_SCL
        #ifdef CONFIG_ESP_PANEL_BOARD_EXPANDER_I2C_IO_SCL
            #define ESP_PANEL_BOARD_EXPANDER_I2C_IO_SCL CONFIG_ESP_PANEL_BOARD_EXPANDER_I2C_IO_SCL
        #else
            #error "Missing configuration: ESP_PANEL_BOARD_EXPANDER_I2C_IO_SCL"
        #endif
    #endif
    #ifndef ESP_PANEL_BOARD_EXPANDER_I2C_IO_SDA
        #ifdef CONFIG_ESP_PANEL_BOARD_EXPANDER_I2C_IO_SDA
            #define ESP_PANEL_BOARD_EXPANDER_I2C_IO_SDA CONFIG_ESP_PANEL_BOARD_EXPANDER_I2C_IO_SDA
        #else
            #error "Missing configuration: ESP_PANEL_BOARD_EXPANDER_I2C_IO_SDA"
        #endif
    #endif
    #ifndef ESP_PANEL_BOARD_EXPANDER_I2C_SCL_PULLUP
        #ifdef CONFIG_ESP_PANEL_BOARD_EXPANDER_I2C_SCL_PULLUP
            #define ESP_PANEL_BOARD_EXPANDER_I2C_SCL_PULLUP CONFIG_ESP_PANEL_BOARD_EXPANDER_I2C_SCL_PULLUP
        #else
            #define ESP_PANEL_BOARD_EXPANDER_I2C_SCL_PULLUP 0
        #endif
    #endif
    #ifndef ESP_PANEL_BOARD_EXPANDER_I2C_SDA_PULLUP
        #ifdef CONFIG_ESP_PANEL_BOARD_EXPANDER_I2C_SDA_PULLUP
            #define ESP_PANEL_BOARD_EXPANDER_I2C_SDA_PULLUP CONFIG_ESP_PANEL_BOARD_EXPANDER_I2C_SDA_PULLUP
        #else
            #define ESP_PANEL_BOARD_EXPANDER_I2C_SDA_PULLUP 0
        #endif
    #endif
#endif // !ESP_PANEL_BOARD_EXPANDER_SKIP_INIT_HOST
#endif // ESP_PANEL_BOARD_USE_EXPANDER

// *INDENT-ON*
